"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelationshipExpression = RelationshipExpression;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _distance_form = require("./distance_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/spatial_join_wizard/wizard_form/relationship_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RelationshipExpression(props) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  function closePopover() {
    setIsPopoverOpen(false);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "spatialJoinRelationship",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      color: "subdued",
      description: _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.withinExpressionDescription', {
        defaultMessage: 'within'
      }),
      value: _i18n.i18n.translate('xpack.maps.spatialJoin.wizardForm.withinExpressionValue', {
        defaultMessage: '{distance} {units} of layer features',
        values: {
          distance: props.distance,
          units: _distance_form.KM_ABBREVIATION
        }
      }),
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      uppercase: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "s",
    anchorPosition: "downCenter",
    repositionOnScroll: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_distance_form.DistanceForm, {
    initialDistance: props.distance,
    onDistanceChange: props.onDistanceChange,
    onClose: closePopover,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
}