"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../common/constants");
var _tooltip_property = require("../tooltips/tooltip_property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AbstractField {
  constructor({
    fieldName,
    origin
  }) {
    (0, _defineProperty2.default)(this, "_fieldName", void 0);
    (0, _defineProperty2.default)(this, "_origin", void 0);
    this._fieldName = fieldName;
    this._origin = origin || _constants.FIELD_ORIGIN.SOURCE;
  }
  supportsFieldMetaFromEs() {
    throw new Error('must implement AbstractField#supportsFieldMetaFromEs');
  }
  supportsFieldMetaFromLocalData() {
    throw new Error('must implement AbstractField#supportsFieldMetaFromLocalData');
  }
  getName() {
    return this._fieldName;
  }
  getMbFieldName() {
    return this.getName();
  }
  getRootName() {
    return this.getName();
  }
  canValueBeFormatted() {
    return false;
  }
  getSource() {
    throw new Error('must implement AbstractField#getSource');
  }
  isValid() {
    return !!this._fieldName;
  }
  async getDataType() {
    return 'string';
  }
  async getLabel() {
    return this._fieldName;
  }
  async createTooltipProperty(value) {
    const label = await this.getLabel();
    return new _tooltip_property.TooltipProperty(this.getName(), label, value);
  }
  getOrigin() {
    return this._origin;
  }
  async getExtendedStatsFieldMetaRequest() {
    return null;
  }
  async getPercentilesFieldMetaRequest(percentiles) {
    return null;
  }
  async getCategoricalFieldMetaRequest(size) {
    return null;
  }
  isEqual(field) {
    return this._origin === field.getOrigin() && this._fieldName === field.getName();
  }
  pluckRangeFromTileMetaFeature(metaFeature) {
    return null;
  }
  isCount() {
    return false;
  }
}
exports.AbstractField = AbstractField;