"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformMapAttributesOut = transformMapAttributesOut;
var _references = require("../migrations/references");
var _stored_map_attributes = require("./stored_map_attributes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformMapAttributesOut(storedMapAttributes, references) {
  const {
    attributes: injectedAttributes
  } = (0, _references.injectReferences)({
    attributes: storedMapAttributes,
    references
  });
  return {
    title: injectedAttributes.title,
    ...(injectedAttributes.description ? {
      description: injectedAttributes.description
    } : {}),
    ...(injectedAttributes.layerListJSON ? {
      layers: parseJSON([], injectedAttributes.layerListJSON)
    } : {}),
    ...parseMapStateJSON(injectedAttributes.mapStateJSON),
    ...parseUiStateJSON(injectedAttributes.uiStateJSON)
  };
}
function parseMapStateJSON(mapStateJSON) {
  const parsedMapState = parseJSON({}, mapStateJSON);
  const {
    refreshConfig,
    ...rest
  } = dropUnknownKeys(parsedMapState, _stored_map_attributes.mapStateKeys);
  return {
    ...rest,
    ...(refreshConfig ? {
      refreshInterval: {
        pause: refreshConfig.isPaused,
        value: refreshConfig.interval
      }
    } : {})
  };
}
function parseUiStateJSON(uiStateJSON) {
  const parsedUiState = parseJSON({}, uiStateJSON);
  return dropUnknownKeys(parsedUiState, _stored_map_attributes.uiStateKeys);
}
function parseJSON(emptyValue, jsonString) {
  if (!jsonString) return emptyValue;
  try {
    const parseResults = JSON.parse(jsonString);
    return parseResults;
  } catch (e) {
    // ignore malformed JSON, map will just use defaults
    return emptyValue;
  }
}
function dropUnknownKeys(value, knownKeys) {
  const valueWithKnownKeys = {};
  Object.keys(value).forEach(keyFromValue => {
    if (knownKeys.includes(keyFromValue)) valueWithKnownKeys[keyFromValue] = value[keyFromValue];
  });
  return valueWithKnownKeys;
}