"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PartitionTitlesAndTextSettings = PartitionTitlesAndTextSettings;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _constants = require("../constants");
var _partition_charts_meta = require("../partition_charts_meta");
var _constants2 = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/partition/toolbar/titles_and_text_setttings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PartitionTitlesAndTextSettings(props) {
  var _layer$percentDecimal;
  const {
    state,
    setState
  } = props;
  const layer = state.layers[0];
  const {
    categoryOptions,
    numberOptions
  } = _partition_charts_meta.PartitionChartsMeta[state.shape].toolbarPopover;
  const onStateChange = (0, _react.useCallback)(part => {
    setState({
      ...state,
      layers: [{
        ...layer,
        ...part
      }]
    });
  }, [layer, state, setState]);
  const onCategoryDisplayChange = (0, _react.useCallback)(option => onStateChange({
    categoryDisplay: option
  }), [onStateChange]);
  const onNumberDisplayChange = (0, _react.useCallback)(option => onStateChange({
    numberDisplay: option
  }), [onStateChange]);
  const onPercentDecimalsChange = (0, _react.useCallback)(option => {
    onStateChange({
      percentDecimals: option
    });
  }, [onStateChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, categoryOptions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.pieChart.labelSliceLabels', {
      defaultMessage: 'Slice labels'
    }),
    fullWidth: true,
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.pieChart.labelSliceLabels', {
      defaultMessage: 'Slice labels'
    }),
    options: categoryOptions,
    idSelected: layer.categoryDisplay,
    onChange: onCategoryDisplayChange,
    buttonSize: "compressed",
    isFullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  })) : null, numberOptions.length && layer.categoryDisplay !== 'hide' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.pieChart.sliceValues', {
      defaultMessage: 'Slice values'
    }),
    fullWidth: true,
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.pieChart.sliceValues', {
      defaultMessage: 'Slice values'
    }),
    options: numberOptions,
    idSelected: layer.numberDisplay,
    onChange: onNumberDisplayChange,
    buttonSize: "compressed",
    isFullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  })), layer.numberDisplay === _constants2.NumberDisplay.PERCENT && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: " ",
    fullWidth: true,
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(DecimalPlaceInput, {
    value: (_layer$percentDecimal = layer.percentDecimals) !== null && _layer$percentDecimal !== void 0 ? _layer$percentDecimal : _constants.DEFAULT_PERCENT_DECIMALS,
    setValue: onPercentDecimalsChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  }))) : null);
}
const DecimalPlaceInput = ({
  value,
  setValue
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    value,
    onChange: setValue
  }, {
    allowFalsyValue: true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "indexPattern-dimension-formatDecimals",
    value: inputValue,
    min: 0,
    max: 10,
    prepend: _i18n.i18n.translate('xpack.lens.pieChart.decimalPlaces', {
      defaultMessage: 'Decimal places'
    }),
    compressed: true,
    onChange: e => {
      handleInputChange(Number(e.currentTarget.value));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  });
};