"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PartitionFlyoutToolbar = PartitionFlyoutToolbar;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _flyout_toolbar = require("../../../shared_components/flyout_toolbar");
var _types = require("../../../../common/types");
var _appearance_settings = require("./appearance_settings");
var _titles_and_text_setttings = require("./titles_and_text_setttings");
var _partition_charts_meta = require("../partition_charts_meta");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/partition/toolbar/flyout_toolbar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function PartitionFlyoutToolbar(props) {
  const {
    isDisabled: hasDisabledSytleSettings
  } = _partition_charts_meta.PartitionChartsMeta[props.state.shape].toolbarPopover;
  const datatableToolbarContentMap = {
    style: hasDisabledSytleSettings ? undefined : PartitionStyleSettings
  };
  return /*#__PURE__*/_react.default.createElement(_flyout_toolbar.FlyoutToolbar, (0, _extends2.default)({}, props, {
    contentMap: datatableToolbarContentMap,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 10
    }
  }));
}
function PartitionStyleSettings(props) {
  const {
    state
  } = props;
  const layer = state.layers[0];
  const {
    emptySizeRatioOptions,
    isDisabled
  } = _partition_charts_meta.PartitionChartsMeta[state.shape].toolbarPopover;
  const selectedOption = emptySizeRatioOptions ? emptySizeRatioOptions.find(({
    value
  }) => {
    var _layer$emptySizeRatio;
    return value === (state.shape === 'pie' ? 0 : (_layer$emptySizeRatio = layer.emptySizeRatio) !== null && _layer$emptySizeRatio !== void 0 ? _layer$emptySizeRatio : _types.EmptySizeRatios.SMALL);
  }) : undefined;
  const showAppearanceSettings = (emptySizeRatioOptions === null || emptySizeRatioOptions === void 0 ? void 0 : emptySizeRatioOptions.length) && selectedOption;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showAppearanceSettings ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: '',
    buttonContent: _i18n.i18n.translate('xpack.lens.visualization.toolbar.appearance', {
      defaultMessage: 'Appearance'
    }),
    paddingSize: "s",
    initialIsOpen: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_appearance_settings.PartitionAppearanceSettings, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, (0, _extends2.default)({
    id: '',
    buttonContent: _i18n.i18n.translate('xpack.lens.visualization.toolbar.titlesAndText', {
      defaultMessage: 'Titles and text'
    }),
    paddingSize: "s",
    initialIsOpen: true,
    isDisabled: !!isDisabled
  }, !!isDisabled && {
    forceState: 'closed'
  }, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_titles_and_text_setttings.PartitionTitlesAndTextSettings, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  })))) : /*#__PURE__*/_react.default.createElement(_titles_and_text_setttings.PartitionTitlesAndTextSettings, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })));
}