"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEditEmbeddableFlyout = getEditEmbeddableFlyout;
exports.isEmbeddableEditActionCompatible = isEmbeddableEditActionCompatible;
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _public = require("@kbn/ui-actions-plugin/public");
var _rxjs = require("rxjs");
var _id_generator = require("../../../id_generator");
var _panel_management = require("../../../react_embeddable/inline_editing/panel_management");
var _setup_inline_editing = require("../../../react_embeddable/inline_editing/setup_inline_editing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const asyncNoop = async () => {};
function isEmbeddableEditActionCompatible(core, attributes) {
  // for ES|QL is compatible only when advanced setting is enabled
  const query = attributes.state.query;
  return (0, _esQuery.isOfAggregateQueryType)(query) ? core.uiSettings.get(_esqlUtils.ENABLE_ESQL) : true;
}
async function getEditEmbeddableFlyout({
  core,
  deps,
  attributes,
  lensEvent,
  container,
  onUpdate,
  onApply,
  onCancel,
  closeFlyout,
  applyButtonLabel
}) {
  var _lensEvent$dataLoadin;
  const isCompatibleAction = isEmbeddableEditActionCompatible(core, attributes);
  if (!isCompatibleAction) {
    throw new _public.IncompatibleActionError();
  }
  const uuid = (0, _id_generator.generateId)();
  const isNewlyCreated$ = new _rxjs.BehaviorSubject(false);
  const panelManagementApi = (0, _panel_management.setupPanelManagement)(uuid, container, {
    isNewlyCreated$,
    setAsCreated: () => isNewlyCreated$.next(false),
    isReadOnly: () => false,
    canEdit: () => true
  });
  const getInlineEditor = (0, _setup_inline_editing.prepareInlineEditPanel)({
    attributes
  }, () => ({
    attributes
  }), newState => onUpdate(newState.attributes), {
    dataLoading$: (_lensEvent$dataLoadin = lensEvent === null || lensEvent === void 0 ? void 0 : lensEvent.dataLoading$) !== null && _lensEvent$dataLoadin !== void 0 ? _lensEvent$dataLoadin : new _rxjs.BehaviorSubject(undefined),
    isNewlyCreated$
  }, panelManagementApi, {
    getInspectorAdapters: () => lensEvent === null || lensEvent === void 0 ? void 0 : lensEvent.adapters,
    inspect() {
      return {
        close: asyncNoop,
        onClose: Promise.resolve()
      };
    },
    closeInspector: asyncNoop,
    adapters$: new _rxjs.BehaviorSubject(lensEvent === null || lensEvent === void 0 ? void 0 : lensEvent.adapters)
  }, {
    coreStart: core,
    ...deps
  });
  const ConfigPanel = await getInlineEditor({
    onApply,
    onCancel,
    closeFlyout,
    applyButtonLabel
  });
  return ConfigPanel;
}