"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFocusUpdate = useFocusUpdate;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFirstFocusable = el => {
  const focusableSelector = 'button, [href], input, select, textarea, [tabindex]';
  if (!el) {
    return null;
  }
  if (el.matches(focusableSelector)) {
    return el;
  }
  const firstFocusable = el.querySelector(focusableSelector);
  if (!firstFocusable) {
    return null;
  }
  return firstFocusable;
};
function useFocusUpdate(ids) {
  const [nextFocusedId, setNextFocusedId] = (0, _react.useState)(null);
  const [refsById, setRefsById] = (0, _react.useState)(new Map());
  (0, _react.useEffect)(() => {
    const element = nextFocusedId && refsById.get(nextFocusedId);
    if (element) {
      const focusable = getFirstFocusable(element);
      setTimeout(() => focusable === null || focusable === void 0 ? void 0 : focusable.focus());
      setNextFocusedId(null);
    }
  }, [ids, refsById, nextFocusedId]);
  const registerNewRef = (0, _react.useCallback)((id, el) => {
    if (el) {
      setRefsById(refs => {
        return new Map(refs.set(id, el));
      });
    }
  }, []);
  const removeRef = (0, _react.useCallback)(id => {
    if (ids.length <= 1) {
      return setNextFocusedId(id);
    }
    const removedIndex = ids.findIndex(l => l === id);
    setRefsById(refs => {
      refs.delete(id);
      return new Map(refs);
    });
    const next = removedIndex === 0 ? ids[1] : ids[removedIndex - 1];
    return setNextFocusedId(next);
  }, [ids]);
  return {
    setNextFocusedId,
    removeRef,
    registerNewRef
  };
}