"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/app_plugin/shared/edit_on_the_fly/flyout_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const applyAndCloseLabel = _i18n.i18n.translate('xpack.lens.config.applyFlyoutLabel', {
  defaultMessage: 'Apply and close'
});
const FlyoutWrapper = ({
  children,
  toolbar,
  isInlineFlyoutVisible,
  isScrollable,
  displayFlyoutHeader,
  language,
  isNewPanel,
  isSaveable,
  onCancel,
  navigateToLensEditor,
  onApply,
  isReadOnly,
  applyButtonLabel = applyAndCloseLabel
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isInlineFlyoutVisible && displayFlyoutHeader && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    css: (0, _react2.css)`
            pointer-events: auto;
            background-color: ${euiTheme.colors.emptyShade};
          `,
    "data-test-subj": "editFlyoutHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "inlineEditingFlyoutLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.lens.config.showVisualizationLabel', {
    defaultMessage: 'Configuration'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: _i18n.i18n.translate('xpack.lens.config.experimentalLabelDataview.title', {
      defaultMessage: 'Technical preview'
    }),
    content: _i18n.i18n.translate('xpack.lens.config.experimentalLabelDataview.content', {
      defaultMessage: 'Inline editing currently offers limited configuration options.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    tabIndex: 0,
    label: "",
    iconType: "beaker",
    size: "s",
    css: (0, _react2.css)`
                            vertical-align: middle;
                          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 25
    }
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, navigateToLensEditor && !isReadOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: navigateToLensEditor,
    "data-test-subj": "navigateToLensEditorLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.lens.config.editLinkLabel', {
    defaultMessage: 'Edit in Lens'
  })))), toolbar && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 25
    }
  }, toolbar))), isInlineFlyoutVisible && isReadOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.lens.config.readOnly', {
      defaultMessage: 'Read-only: Changes will be reverted on close'
    }),
    color: "warning",
    iconType: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    className: "lnsEditFlyoutBody",
    css: (0, _react2.css)`
          // styles needed to display extra drop targets that are outside of the config panel main area
          overflow-y: auto;
          padding-left: ${euiTheme.components.forms.maxWidth};
          margin-left: -${euiTheme.components.forms.maxWidth};
          pointer-events: none;
          .euiFlyoutBody__overflow {
            transform: initial;
            -webkit-mask-image: none;
            padding-left: inherit;
            margin-left: inherit;
            ${!isScrollable && `
                overflow-y: hidden;
              `}
            > * {
              pointer-events: auto;
            }
          }
          .euiFlyoutBody__overflowContent {
            padding: 0;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, children), isInlineFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    id: "lnsCancelEditOnFlyFlyout",
    onClick: onCancel,
    flush: "left",
    "aria-label": _i18n.i18n.translate('xpack.lens.config.cancelFlyoutAriaLabel', {
      defaultMessage: 'Cancel applied changes'
    }),
    "data-test-subj": "cancelFlyoutButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.config.cancelFlyoutLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  }))), isReadOnly ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onApply,
    fill: true,
    disabled: Boolean(isNewPanel) ? false : !isSaveable,
    iconType: "check",
    "data-test-subj": "applyFlyoutButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 17
    }
  }, applyButtonLabel)))));
};
exports.FlyoutWrapper = FlyoutWrapper;