"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _cloud_response = require("./cloud_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * CloudService provides a mechanism for cloud services to be checked for
 * metadata that may help to determine the best defaults and priorities.
 */
class CloudService {
  constructor(name) {
    (0, _defineProperty2.default)(this, "_name", void 0);
    /**
     * Get the search-friendly name of the Cloud Service.
     */
    (0, _defineProperty2.default)(this, "getName", () => {
      return this._name;
    });
    /**
     * Using whatever mechanism is required by the current Cloud Service,
     * determine if Kibana is running in it and return relevant metadata.
     */
    (0, _defineProperty2.default)(this, "checkIfService", async signal => {
      try {
        return await this._checkIfService(signal);
      } catch (e) {
        return this._createUnconfirmedResponse();
      }
    });
    (0, _defineProperty2.default)(this, "_checkIfService", async signal => {
      // should always be overridden by a subclass
      return Promise.reject(new Error('not implemented'));
    });
    /**
     * Create a new CloudServiceResponse that denotes that this cloud service
     * is not being used by the current machine / VM.
     */
    (0, _defineProperty2.default)(this, "_createUnconfirmedResponse", () => {
      return _cloud_response.CloudServiceResponse.unconfirmed(this._name);
    });
    /**
     * Strictly parse JSON.
     */
    (0, _defineProperty2.default)(this, "_stringToJson", value => {
      // note: this will throw an error if this is not a string
      value = value.trim();
      try {
        const json = JSON.parse(value);
        // we don't want to return scalar values, arrays, etc.
        if (!(0, _lodash.isPlainObject)(json)) {
          throw new Error('not a plain object');
        }
        return json;
      } catch (e) {
        throw new Error(`'${value}' is not a JSON object`);
      }
    });
    /**
     * Convert the response to a JSON object and attempt to parse it using the
     * parseBody function.
     *
     * If the response cannot be parsed as a JSON object, or if it fails to be
     * useful, then parseBody should return null.
     */
    (0, _defineProperty2.default)(this, "_parseResponse", (body, parseBodyFn) => {
      // parse it if necessary
      const jsonBody = typeof body === 'string' ? this._stringToJson(body) : body;
      if ((0, _lodash.isObject)(jsonBody) && typeof parseBodyFn !== 'undefined') {
        const response = parseBodyFn(jsonBody);
        if (response) {
          return response;
        }
      }

      // use default handling
      throw new Error('Unable to handle body');
    });
    this._name = name.toLowerCase();
  }
}
exports.CloudService = CloudService;