"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inventoryViewSavedObjectType = exports.inventoryViewSavedObjectName = void 0;
var _configSchema = require("@kbn/config-schema");
var _Either = require("fp-ts/Either");
var _pipeable = require("fp-ts/pipeable");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inventoryViewSavedObjectName = exports.inventoryViewSavedObjectName = 'inventory-view';
const getInventoryViewTitle = savedObject => (0, _pipeable.pipe)(_types.inventoryViewSavedObjectRT.decode(savedObject), (0, _Either.fold)(() => `Inventory view [id=${savedObject.id}]`, ({
  attributes: {
    name
  }
}) => name));
const schemaV1 = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
const schemaV2 = _configSchema.schema.object({
  legend: _configSchema.schema.maybe(_configSchema.schema.object({
    steps: _configSchema.schema.number({
      max: 18,
      min: 2
    })
  }, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const inventoryV2Transform = doc => {
  var _asV2$attributes$lege;
  // steps property did exist, even though it wasn't present in the schema
  const asV2 = doc;
  if (typeof ((_asV2$attributes$lege = asV2.attributes.legend) === null || _asV2$attributes$lege === void 0 ? void 0 : _asV2$attributes$lege.steps) === 'undefined') {
    return {
      document: asV2
    };
  } else {
    var _asV2$attributes$lege2;
    let steps = (_asV2$attributes$lege2 = asV2.attributes.legend) === null || _asV2$attributes$lege2 === void 0 ? void 0 : _asV2$attributes$lege2.steps;
    if (steps > 18) {
      steps = 18;
    } else if (steps < 2) {
      steps = 2;
    }
    const document = {
      ...asV2,
      attributes: {
        ...asV2.attributes,
        legend: {
          ...asV2.attributes.legend,
          steps
        }
      }
    };
    return {
      document
    };
  }
};
const inventoryViewSavedObjectType = exports.inventoryViewSavedObjectType = {
  name: inventoryViewSavedObjectName,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'name',
    displayName: 'inventory view',
    getTitle: getInventoryViewTitle,
    icon: 'metricsApp',
    importableAndExportable: true
  },
  mappings: {
    dynamic: false,
    properties: {}
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        create: schemaV1
      }
    },
    2: {
      changes: [{
        type: 'unsafe_transform',
        transformFn: typeSafeGuard => typeSafeGuard(inventoryV2Transform)
      }],
      schemas: {
        forwardCompatibility: schemaV2,
        create: schemaV2
      }
    }
  }
};