"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNoSuchRemoteClusterMessage = exports.SavedObjectReferenceResolutionError = exports.NotFoundError = exports.NoSuchRemoteClusterError = exports.AnomalyThresholdRangeError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

class NotFoundError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, new.target.prototype);
  }
}
exports.NotFoundError = NotFoundError;
class AnomalyThresholdRangeError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, new.target.prototype);
  }
}
exports.AnomalyThresholdRangeError = AnomalyThresholdRangeError;
class SavedObjectReferenceResolutionError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'SavedObjectReferenceResolutionError';
  }
}
exports.SavedObjectReferenceResolutionError = SavedObjectReferenceResolutionError;
class NoSuchRemoteClusterError extends Error {
  constructor(message) {
    super(message || 'The configured remote cluster is missing or not reachable.');
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'NoSuchRemoteClusterError';
  }
}
exports.NoSuchRemoteClusterError = NoSuchRemoteClusterError;
const isNoSuchRemoteClusterMessage = message => {
  return message.includes('no_such_remote_cluster_exception');
};
exports.isNoSuchRemoteClusterMessage = isNoSuchRemoteClusterMessage;