"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _popover = require("../common/popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/search_bar/controls_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const helpMessages = {
  [_common.SERVICE_NAME]: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 16,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.serviceNameControl.popoverHelpLabel",
    defaultMessage: "Services detected via {APMDocs}",
    values: {
      APMDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://ela.st/docs-infra-apm",
        target: "_blank",
        "data-test-subj": "hostsViewServiceNameControlPopoverHelpLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 22,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.hostsViewPage.serviceNameControl.popoverHelpLink",
        defaultMessage: "APM",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 27,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 7
    }
  }))
};
const TitleWithPopoverMessage = ({
  title,
  helpMessage,
  embeddableId
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: embeddableId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    buttonAriaLabelText: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, helpMessage))));
};
const ControlTitle = ({
  title,
  embeddableId
}) => {
  const helpMessage = helpMessages[embeddableId];
  return helpMessage ? /*#__PURE__*/_react.default.createElement(TitleWithPopoverMessage, {
    title: title,
    helpMessage: helpMessage,
    embeddableId: embeddableId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: embeddableId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, title);
};
exports.ControlTitle = ControlTitle;