"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryRatePage = void 0;
var _react = _interopRequireDefault(require("react"));
var _subscription_splash_content = require("../../../components/subscription_splash_content");
var _log_analysis_setup = require("../../../components/logging/log_analysis_setup");
var _log_analysis = require("../../../containers/logs/log_analysis");
var _page_content = require("./page_content");
var _page_providers = require("./page_providers");
var _use_logs_breadcrumbs = require("../../../hooks/use_logs_breadcrumbs");
var _translations = require("../../../translations");
var _use_log_ml_job_id_formats_shim = require("../shared/use_log_ml_job_id_formats_shim");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_rate/page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LogEntryRatePage = () => {
  (0, _use_logs_breadcrumbs.useLogsBreadcrumbs)([{
    text: _translations.logsAnomaliesTitle
  }]);
  const {
    hasLogAnalysisReadCapabilities,
    hasLogAnalysisCapabilites
  } = (0, _log_analysis.useLogAnalysisCapabilitiesContext)();
  if (!hasLogAnalysisCapabilites) {
    return /*#__PURE__*/_react.default.createElement(_subscription_splash_content.SubscriptionSplashPage, {
      "data-test-subj": "logsLogEntryRatePage",
      pageHeader: {
        pageTitle: _translations.logsAnomaliesTitle
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    });
  }
  if (!hasLogAnalysisReadCapabilities) {
    return /*#__PURE__*/_react.default.createElement(_page_content.AnomaliesPageTemplate, {
      isEmptyState: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingResultsPrivilegesPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_use_log_ml_job_id_formats_shim.LogMlJobIdFormatsShimProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_page_providers.LogEntryRatePageProviders, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_content.LogEntryRatePageContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })));
};
exports.LogEntryRatePage = LogEntryRatePage;