"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNoDataConfig = exports.OnboardingFlow = void 0;
var _i18n = require("@kbn/i18n");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _empty_states = require("../../empty_states");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let OnboardingFlow = exports.OnboardingFlow = /*#__PURE__*/function (OnboardingFlow) {
  OnboardingFlow["Infra"] = "infra";
  OnboardingFlow["Hosts"] = "host";
  return OnboardingFlow;
}({});
const createCardConfig = (onboardingFlow, locators, docsLink) => {
  const onboardingLocator = locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  switch (onboardingFlow) {
    case OnboardingFlow.Hosts:
      {
        return {
          title: _i18n.i18n.translate('xpack.infra.hostsViewPage.noData.page.title', {
            defaultMessage: 'Detect and resolve problems with your hosts'
          }),
          description: _i18n.i18n.translate('xpack.infra.hostsViewPage.noData.card.description', {
            defaultMessage: 'Start collecting data for your hosts to understand metric trends, explore logs and deep insight into their performance'
          }),
          href: onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.getRedirectUrl({
            category: onboardingFlow
          }),
          buttonText: _i18n.i18n.translate('xpack.infra.hostsViewPage.noData.card.buttonLabel', {
            defaultMessage: 'Add data'
          }),
          docsLink
        };
      }
    default:
      {
        return {
          title: _empty_states.noMetricIndicesPromptTitle,
          description: _empty_states.noMetricIndicesPromptDescription,
          href: onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.getRedirectUrl({}),
          buttonText: _i18n.i18n.translate('xpack.infra.hostsViewPage.noData.card.buttonLabel', {
            defaultMessage: 'Add data'
          }),
          docsLink
        };
      }
  }
};
const getNoDataConfigDetails = ({
  onboardingFlow,
  locators,
  docsLink
}) => {
  return {
    action: {
      beats: {
        ...createCardConfig(onboardingFlow, locators, docsLink)
      }
    }
  };
};
const getNoDataConfig = ({
  hasData,
  loading,
  locators,
  onboardingFlow,
  docsLink
}) => {
  if (!onboardingFlow || hasData || loading) {
    return;
  }
  return getNoDataConfigDetails({
    onboardingFlow,
    locators,
    docsLink
  });
};
exports.getNoDataConfig = getNoDataConfig;