"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadDefaultConnector = void 0;
var _get_default_connector = require("../../common/utils/get_default_connector");
var _get_connector_list = require("./get_connector_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadDefaultConnector = async ({
  actions,
  request
}) => {
  const connectors = await (0, _get_connector_list.getConnectorList)({
    actions,
    request
  });
  return (0, _get_default_connector.getDefaultConnector)({
    connectors
  });
};
exports.loadDefaultConnector = loadDefaultConnector;