"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTokenLimitReachedError = createTokenLimitReachedError;
exports.createToolNotFoundError = createToolNotFoundError;
exports.createToolValidationError = createToolValidationError;
var _inferenceCommon = require("@kbn/inference-common");
var _i18n = require("@kbn/i18n");
var _errors = require("@kbn/inference-common/src/chat_complete/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTokenLimitReachedError(tokenLimit, tokenCount) {
  return new _inferenceCommon.InferenceTaskError(_errors.ChatCompletionErrorCode.TokenLimitReachedError, _i18n.i18n.translate('xpack.inference.chatCompletionError.tokenLimitReachedError', {
    defaultMessage: `Token limit reached. Token limit is {tokenLimit}, but the current conversation has {tokenCount} tokens.`,
    values: {
      tokenLimit,
      tokenCount
    }
  }), {
    tokenLimit,
    tokenCount
  });
}
function createToolNotFoundError(name) {
  return new _inferenceCommon.InferenceTaskError(_errors.ChatCompletionErrorCode.ToolNotFoundError, `Tool "${name}" called but was not available`, {
    name
  });
}
function createToolValidationError(message, meta) {
  return new _inferenceCommon.InferenceTaskError(_errors.ChatCompletionErrorCode.ToolValidationError, message, meta);
}