"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PublicApiService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../../common");
var _shared_imports = require("../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Index Management public API service
 */
class PublicApiService {
  /**
   * constructor
   * @param http http dependency
   */
  constructor(http) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }

  /**
   * Gets a list of all the enrich policies
   */
  getAllEnrichPolicies() {
    return (0, _shared_imports.sendRequest)(this.http, {
      path: `${_common.INTERNAL_API_BASE_PATH}/enrich_policies`,
      method: 'get'
    });
  }
}
exports.PublicApiService = PublicApiService;