"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConvertToLookupIndexModalContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_convert_index_to_lookup = require("../../../../../hooks/use_convert_index_to_lookup/use_convert_index_to_lookup");
var _convert_to_lookup_index_modal = require("./convert_to_lookup_index_modal");
var _notification = require("../../../../../services/notification");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/convert_to_lookup_index_modal/convert_to_lookup_index_modal_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConvertToLookupIndexModalContainer = ({
  onCloseModal,
  onSuccess,
  sourceIndexName
}) => {
  const {
    isConverting,
    errorMessage,
    convert
  } = (0, _use_convert_index_to_lookup.useConvertIndexToLookup)({
    sourceIndexName,
    onSuccess,
    onClose: onCloseModal
  });
  const onCloseModalWithInfoToast = () => {
    if (isConverting) {
      _notification.notificationService.showInfoToast(_i18n.i18n.translate('xpack.idxMgmt.convertToLookupIndexAction.indexConversionInProgressToastTitle', {
        defaultMessage: '{sourceIndexName} conversion into a lookup index is still in progress.',
        values: {
          sourceIndexName
        }
      }));
    }
    onCloseModal();
  };
  return /*#__PURE__*/_react.default.createElement(_convert_to_lookup_index_modal.ConvertToLookupIndexModal, {
    onCloseModal: onCloseModalWithInfoToast,
    onConvert: convert,
    sourceIndexName: sourceIndexName,
    isConverting: isConverting,
    errorMessage: errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
};
exports.ConvertToLookupIndexModalContainer = ConvertToLookupIndexModalContainer;