"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _fields_list_item_container = require("./fields_list_item_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/fields_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FieldsList = exports.FieldsList = /*#__PURE__*/_react.default.memo(function FieldsListComponent({
  fields,
  treeDepth,
  state,
  setPreviousState,
  isAddingFields,
  pendingFieldsRef
}) {
  if (fields === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("ul", {
    "data-test-subj": "fieldsList",
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.fieldListLabel', {
      defaultMessage: 'Saved mapping fields'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, fields.map((field, index) => /*#__PURE__*/_react.default.createElement(_fields_list_item_container.FieldsListItemContainer, {
    key: field.id,
    fieldId: field.id,
    treeDepth: treeDepth === undefined ? 0 : treeDepth,
    isLastItem: index === fields.length - 1,
    state: state,
    setPreviousState: setPreviousState,
    isAddingFields: isAddingFields,
    pendingFieldsRef: pendingFieldsRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })));
});