"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _check_license = require("../common/check_license");
var _content_management = require("../common/content_management");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class GraphPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    this.initializerContext = initializerContext;
  }
  setup(core, {
    home,
    contentManagement
  }) {
    if (home) {
      home.featureCatalogue.register({
        id: 'graph',
        title: 'Graph',
        subtitle: _i18n.i18n.translate('xpack.graph.pluginSubtitle', {
          defaultMessage: 'Reveal patterns and relationships.'
        }),
        description: _i18n.i18n.translate('xpack.graph.pluginDescription', {
          defaultMessage: 'Surface and analyze relevant relationships in your Elasticsearch data.'
        }),
        icon: 'graphApp',
        path: '/app/graph',
        showOnHomePage: false,
        category: 'data',
        solutionId: 'kibana',
        order: 600
      });
    }
    const config = this.initializerContext.config.get();
    contentManagement.registry.register({
      id: _content_management.CONTENT_ID,
      version: {
        latest: _content_management.LATEST_VERSION
      },
      name: _i18n.i18n.translate('xpack.graph.content.name', {
        defaultMessage: 'Graph Visualization'
      })
    });
    core.application.register({
      id: 'graph',
      title: 'Graph',
      order: 6000,
      appRoute: '/app/graph',
      euiIconType: 'logoKibana',
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      updater$: this.appUpdater$,
      mount: async params => {
        const [coreStart, pluginsStart] = await core.getStartServices();
        coreStart.chrome.docTitle.change(_i18n.i18n.translate('xpack.graph.pageTitle', {
          defaultMessage: 'Graph'
        }));
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        return renderApp({
          ...params,
          pluginInitializerContext: this.initializerContext,
          licensing: pluginsStart.licensing,
          core: coreStart,
          coreStart,
          navigation: pluginsStart.navigation,
          data: pluginsStart.data,
          unifiedSearch: pluginsStart.unifiedSearch,
          contentClient: pluginsStart.contentManagement.client,
          addBasePath: core.http.basePath.prepend,
          getBasePath: core.http.basePath.get,
          canEditDrillDownUrls: config.canEditDrillDownUrls,
          graphSavePolicy: config.savePolicy,
          storage: new _public2.Storage(window.localStorage),
          capabilities: coreStart.application.capabilities,
          chrome: coreStart.chrome,
          toastNotifications: coreStart.notifications.toasts,
          dataViews: pluginsStart.data.dataViews,
          overlays: coreStart.overlays,
          uiSettings: core.uiSettings,
          spaces: pluginsStart.spaces,
          inspect: pluginsStart.inspector,
          savedObjectsManagement: pluginsStart.savedObjectsManagement,
          contentManagement: pluginsStart.contentManagement
        });
      }
    });
  }
  start(core, {
    home,
    licensing
  }) {
    licensing.license$.subscribe(license => {
      const licenseInformation = (0, _check_license.checkLicense)(license);
      this.appUpdater$.next(() => ({
        status: licenseInformation.showAppLink ? licenseInformation.enableAppLink ? _public.AppStatus.accessible : _public.AppStatus.inaccessible : _public.AppStatus.inaccessible,
        tooltip: licenseInformation.showAppLink ? licenseInformation.message : undefined
      }));
      if (home && !licenseInformation.enableAppLink) {
        home.featureCatalogue.removeFeature('graph');
      }
    });
  }
  stop() {}
}
exports.GraphPlugin = GraphPlugin;