"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentTemplateAssetsMapCache = getAgentTemplateAssetsMapCache;
exports.getHandlebarsCompiledTemplateCache = getHandlebarsCompiledTemplateCache;
exports.getIsSpaceAwarenessEnabledCache = getIsSpaceAwarenessEnabledCache;
exports.getPackageAssetsMapCache = getPackageAssetsMapCache;
exports.getPackageInfoCache = getPackageInfoCache;
exports.runWithCache = runWithCache;
exports.setAgentTemplateAssetsMapCache = setAgentTemplateAssetsMapCache;
exports.setHandlebarsCompiledTemplateCache = setHandlebarsCompiledTemplateCache;
exports.setIsSpaceAwarenessEnabledCache = setIsSpaceAwarenessEnabledCache;
exports.setPackageAssetsMapCache = setPackageAssetsMapCache;
exports.setPackageInfoCache = setPackageInfoCache;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _async_hooks = require("async_hooks");
var _lruCache = require("lru-cache");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cacheStore = new _async_hooks.AsyncLocalStorage();
const PACKAGE_INFO_CACHE_SIZE = 20;
const PACKAGE_ASSETS_MAP_CACHE_SIZE = 1;
const AGENT_TEMPLATE_ASSETS_MAP_CACHE_SIZE = 5;
const HANDLEBARS_COMPILE_TEMPLATE_CACHE_SIZE = 200;
class CacheSession {
  constructor() {
    (0, _defineProperty2.default)(this, "_packageInfoCache", void 0);
    (0, _defineProperty2.default)(this, "_packageAssetsMap", void 0);
    (0, _defineProperty2.default)(this, "_agentTemplateAssetsMap", void 0);
    (0, _defineProperty2.default)(this, "_handlebarsCompiledTemplate", void 0);
    (0, _defineProperty2.default)(this, "_isSpaceAwarenessEnabledCache", void 0);
  }
  getPackageInfoCache() {
    if (!this._packageInfoCache) {
      this._packageInfoCache = new _lruCache.LRUCache({
        max: PACKAGE_INFO_CACHE_SIZE
      });
    }
    return this._packageInfoCache;
  }
  getPackageAssetsMapCache() {
    if (!this._packageAssetsMap) {
      this._packageAssetsMap = new _lruCache.LRUCache({
        max: PACKAGE_ASSETS_MAP_CACHE_SIZE
      });
    }
    return this._packageAssetsMap;
  }
  getAgentTemplateAssetsMapCache() {
    if (!this._agentTemplateAssetsMap) {
      this._agentTemplateAssetsMap = new _lruCache.LRUCache({
        max: AGENT_TEMPLATE_ASSETS_MAP_CACHE_SIZE
      });
    }
    return this._agentTemplateAssetsMap;
  }
  getHandlebarsCompiledTemplateCache() {
    if (!this._handlebarsCompiledTemplate) {
      this._handlebarsCompiledTemplate = new _lruCache.LRUCache({
        max: HANDLEBARS_COMPILE_TEMPLATE_CACHE_SIZE
      });
    }
    return this._handlebarsCompiledTemplate;
  }
  getIsSpaceAwarenessEnabledCache() {
    if (typeof this._isSpaceAwarenessEnabledCache === 'boolean') {
      return this._isSpaceAwarenessEnabledCache;
    }
  }
  setIsSpaceAwarenessEnabledCache(val) {
    this._isSpaceAwarenessEnabledCache = val;
  }
}
function getPackageInfoCache(pkgName, pkgVersion) {
  var _cacheStore$getStore, _cacheStore$getStore$;
  return (_cacheStore$getStore = cacheStore.getStore()) === null || _cacheStore$getStore === void 0 ? void 0 : (_cacheStore$getStore$ = _cacheStore$getStore.getPackageInfoCache()) === null || _cacheStore$getStore$ === void 0 ? void 0 : _cacheStore$getStore$.get(`${pkgName}:${pkgVersion}`);
}
function setPackageInfoCache(pkgName, pkgVersion, packageInfo) {
  var _cacheStore$getStore2, _cacheStore$getStore3;
  return (_cacheStore$getStore2 = cacheStore.getStore()) === null || _cacheStore$getStore2 === void 0 ? void 0 : (_cacheStore$getStore3 = _cacheStore$getStore2.getPackageInfoCache()) === null || _cacheStore$getStore3 === void 0 ? void 0 : _cacheStore$getStore3.set(`${pkgName}:${pkgVersion}`, packageInfo);
}
function getPackageAssetsMapCache(pkgName, pkgVersion) {
  var _cacheStore$getStore4, _cacheStore$getStore5;
  return (_cacheStore$getStore4 = cacheStore.getStore()) === null || _cacheStore$getStore4 === void 0 ? void 0 : (_cacheStore$getStore5 = _cacheStore$getStore4.getPackageAssetsMapCache()) === null || _cacheStore$getStore5 === void 0 ? void 0 : _cacheStore$getStore5.get(`${pkgName}:${pkgVersion}`);
}
function getIsSpaceAwarenessEnabledCache() {
  var _cacheStore$getStore6;
  return (_cacheStore$getStore6 = cacheStore.getStore()) === null || _cacheStore$getStore6 === void 0 ? void 0 : _cacheStore$getStore6.getIsSpaceAwarenessEnabledCache();
}
function setIsSpaceAwarenessEnabledCache(val) {
  var _cacheStore$getStore7;
  return (_cacheStore$getStore7 = cacheStore.getStore()) === null || _cacheStore$getStore7 === void 0 ? void 0 : _cacheStore$getStore7.setIsSpaceAwarenessEnabledCache(val);
}
function setPackageAssetsMapCache(pkgName, pkgVersion, assetsMap) {
  var _cacheStore$getStore8, _cacheStore$getStore9;
  return (_cacheStore$getStore8 = cacheStore.getStore()) === null || _cacheStore$getStore8 === void 0 ? void 0 : (_cacheStore$getStore9 = _cacheStore$getStore8.getPackageAssetsMapCache()) === null || _cacheStore$getStore9 === void 0 ? void 0 : _cacheStore$getStore9.set(`${pkgName}:${pkgVersion}`, assetsMap);
}
function getAgentTemplateAssetsMapCache(pkgName, pkgVersion) {
  var _cacheStore$getStore10, _cacheStore$getStore11;
  return (_cacheStore$getStore10 = cacheStore.getStore()) === null || _cacheStore$getStore10 === void 0 ? void 0 : (_cacheStore$getStore11 = _cacheStore$getStore10.getAgentTemplateAssetsMapCache()) === null || _cacheStore$getStore11 === void 0 ? void 0 : _cacheStore$getStore11.get(`${pkgName}:${pkgVersion}`);
}
function setAgentTemplateAssetsMapCache(pkgName, pkgVersion, assetsMap) {
  var _cacheStore$getStore12, _cacheStore$getStore13;
  return (_cacheStore$getStore12 = cacheStore.getStore()) === null || _cacheStore$getStore12 === void 0 ? void 0 : (_cacheStore$getStore13 = _cacheStore$getStore12.getAgentTemplateAssetsMapCache()) === null || _cacheStore$getStore13 === void 0 ? void 0 : _cacheStore$getStore13.set(`${pkgName}:${pkgVersion}`, assetsMap);
}
function getHandlebarsCompiledTemplateCache(tplStr) {
  var _cacheStore$getStore14, _cacheStore$getStore15;
  return (_cacheStore$getStore14 = cacheStore.getStore()) === null || _cacheStore$getStore14 === void 0 ? void 0 : (_cacheStore$getStore15 = _cacheStore$getStore14.getHandlebarsCompiledTemplateCache()) === null || _cacheStore$getStore15 === void 0 ? void 0 : _cacheStore$getStore15.get(tplStr);
}
function setHandlebarsCompiledTemplateCache(tplStr, tpl) {
  var _cacheStore$getStore16, _cacheStore$getStore17;
  return (_cacheStore$getStore16 = cacheStore.getStore()) === null || _cacheStore$getStore16 === void 0 ? void 0 : (_cacheStore$getStore17 = _cacheStore$getStore16.getHandlebarsCompiledTemplateCache()) === null || _cacheStore$getStore17 === void 0 ? void 0 : _cacheStore$getStore17.set(tplStr, tpl);
}
async function runWithCache(cb) {
  const cache = new CacheSession();
  return cacheStore.run(cache, cb);
}