"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsFirstTimeAgentUserQuery = void 0;
var _constants = require("../../../../../../../../common/constants");
var _hooks = require("../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsFirstTimeAgentUserQuery = () => {
  var _packagePolicies$item, _agents$data;
  const authz = (0, _hooks.useAuthz)();
  const {
    data: packagePolicies,
    isLoading: areAgentPoliciesLoading,
    isFetched: areAgentsFetched
  } = (0, _hooks.useGetPackagePoliciesQuery)({
    kuery: `${_constants.LEGACY_PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${_constants.FLEET_SERVER_PACKAGE}`
  }, {
    enabled: authz.fleet.readAgentPolicies
  });
  const policyIds = [...new Set((_packagePolicies$item = packagePolicies === null || packagePolicies === void 0 ? void 0 : packagePolicies.items.flatMap(item => item.policy_ids)) !== null && _packagePolicies$item !== void 0 ? _packagePolicies$item : [])];

  // now get all agents that are NOT part of a fleet server policy
  const serverPolicyIdsQuery = policyIds.map(policyId => `policy_id:"${policyId}"`).join(' or ');

  // get agents that are not unenrolled and not fleet server
  const kuery = `not (_exists_:"unenrolled_at")` + (serverPolicyIdsQuery.length ? ` and not (${serverPolicyIdsQuery})` : '');
  const {
    data: agents,
    isLoading: areAgentsLoading
  } = (0, _hooks.useGetAgentsQuery)({
    page: 1,
    perPage: 1,
    // we only need to know if there is at least one non-fleet agent
    showInactive: true,
    kuery
  }, {
    enabled: areAgentsFetched
  } // don't run the query until agent policies are loaded
  );
  return {
    isLoading: authz.fleet.readAgentPolicies && (areAgentPoliciesLoading || areAgentsLoading),
    isFirstTimeAgentUser: authz.fleet.readAgentPolicies && (agents === null || agents === void 0 ? void 0 : (_agents$data = agents.data) === null || _agents$data === void 0 ? void 0 : _agents$data.total) === 0
  };
};
exports.useIsFirstTimeAgentUserQuery = useIsFirstTimeAgentUserQuery;