"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SSLFormSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _multi_row_input = require("../multi_row_input");
var _constants = require("../../../../../../../common/constants");
var _output_form_secret_form_row = require("./output_form_secret_form_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/ssl_form_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SSLFormSection = props => {
  var _inputs$sslCertificat;
  const {
    type,
    inputs,
    useSecretsStorage,
    isConvertedToSecret,
    onToggleSecretAndClearValue
  } = props;
  const showmTLSText = type === _constants.outputType.Elasticsearch || type === _constants.outputType.RemoteElasticsearch;
  const showAccordionOpen = !!inputs.sslKeySecretInput.value || ((_inputs$sslCertificat = inputs.sslCertificateAuthoritiesInput.value) === null || _inputs$sslCertificat === void 0 ? void 0 : _inputs$sslCertificat.length) > 0 || !!inputs.sslCertificateInput.value || !!inputs.sslKeySecretInput.value;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: showAccordionOpen,
    id: "advancedSSLOptions",
    "data-test-subj": "advancedSSLOptionsButton",
    buttonClassName: "ingest-active-button",
    buttonContent: /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.editOutputFlyout.SSLOptionsToggleLabel",
      defaultMessage: "Authentication",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 17
      }
    }, showmTLSText ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.SSLOptionsDescription",
      defaultMessage: "Add these settings only when setting up an mTLS connection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 21
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.editOutputFlyout.SSLOptionsToggleLabel",
      defaultMessage: "Set up a TLS secure connection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 21
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, type === 'download_source' ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.editOutputFlyout.downloadSource.sslWarningCallout', {
      defaultMessage: 'Invalid settings can prevent Elastic Agent from being able to upgrade. If this happens, you will need to provide valid credentials.'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.editOutputFlyout.sslWarningCallout', {
      defaultMessage: 'Invalid settings can break the connection between Elastic Agent and the configured output. If this happens, you will need to provide valid credentials.'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder', {
      defaultMessage: 'Specify certificate authority'
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputLabel', {
      defaultMessage: 'Server SSL certificate authorities'
    }),
    multiline: true,
    sortable: false
  }, inputs.sslCertificateAuthoritiesInput.props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",
      defaultMessage: "Client SSL certificate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 15
      }
    })
  }, inputs.sslCertificateInput.formRowProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslCertificateInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateInputPlaceholder', {
      defaultMessage: 'Specify SSL certificate'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }))), !useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",
      defaultMessage: "Client SSL certificate key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 17
      }
    })
  }, inputs.sslKeyInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretAndClearValue,
    disabled: !useSecretsStorage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder', {
      defaultMessage: 'Specify certificate key'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeySecretInputTitle', {
      defaultMessage: 'Client SSL certificate key'
    })
  }, inputs.sslKeySecretInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    isConvertedToSecret: isConvertedToSecret,
    onToggleSecretStorage: onToggleSecretAndClearValue,
    cancelEdit: inputs.sslKeySecretInput.cancelEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslKeySecretInput.props, {
    "data-test-subj": "sslKeySecretInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeySecretInputPlaceholder', {
      defaultMessage: 'Specify certificate key'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }));
};
exports.SSLFormSection = SSLFormSection;