"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstallFleetServerStep = getInstallFleetServerStep;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _ = require("../..");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/fleet_server_instructions/steps/install_fleet_server.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getInstallFleetServerStep({
  isFleetServerReady,
  disabled,
  serviceToken,
  fleetServerHost,
  fleetServerPolicyId,
  deploymentMode
}) {
  return {
    title: _i18n.i18n.translate('xpack.fleet.fleetServerFlyout.installFleetServerTitle', {
      defaultMessage: 'Install Fleet Server to a centralized host'
    }),
    status: disabled ? 'disabled' : isFleetServerReady ? 'complete' : 'incomplete',
    children: !disabled && /*#__PURE__*/_react.default.createElement(InstallFleetServerStepContent, {
      serviceToken: serviceToken,
      fleetServerHost: fleetServerHost,
      fleetServerPolicyId: fleetServerPolicyId,
      deploymentMode: deploymentMode,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    })
  };
}
const InstallFleetServerStepContent = ({
  serviceToken,
  fleetServerHost,
  fleetServerPolicyId,
  deploymentMode
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const kibanaVersion = (0, _hooks.useKibanaVersion)();
  const {
    esOutput,
    esOutputProxy,
    downloadSource,
    downloadSourceProxy
  } = (0, _hooks.useFleetServerHostsForPolicy)(fleetServerPolicyId ? {
    id: fleetServerPolicyId
  } : null);
  const installCommands = ['linux_aarch64', 'linux_x86_64', 'mac_aarch64', 'mac_x86_64', 'windows', 'rpm_aarch64', 'rpm_x86_64', 'deb_aarch64', 'deb_x86_64', 'windows_msi'].reduce((acc, platform) => {
    var _esOutput$hosts$, _esOutput$hosts, _esOutput$ca_trusted_;
    acc[platform] = (0, _utils.getInstallCommandForPlatform)({
      platform,
      esOutputHost: (_esOutput$hosts$ = esOutput === null || esOutput === void 0 ? void 0 : (_esOutput$hosts = esOutput.hosts) === null || _esOutput$hosts === void 0 ? void 0 : _esOutput$hosts[0]) !== null && _esOutput$hosts$ !== void 0 ? _esOutput$hosts$ : '<ELASTICSEARCH_HOST>',
      esOutputProxy,
      serviceToken: serviceToken !== null && serviceToken !== void 0 ? serviceToken : '',
      policyId: fleetServerPolicyId,
      fleetServerHost,
      isProductionDeployment: deploymentMode === 'production',
      sslCATrustedFingerprint: (_esOutput$ca_trusted_ = esOutput === null || esOutput === void 0 ? void 0 : esOutput.ca_trusted_fingerprint) !== null && _esOutput$ca_trusted_ !== void 0 ? _esOutput$ca_trusted_ : undefined,
      kibanaVersion,
      downloadSource,
      downloadSourceProxy
    });
    return acc;
  }, {});
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.fleetServerFlyout.installFleetServerInstructions",
    defaultMessage: "Install Fleet Server agent on a centralized host so that other hosts you wish to monitor can connect to it. In production, we recommend using one or more dedicated hosts. For additional guidance, see our {installationLink}.",
    values: {
      installationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        external: true,
        href: docLinks.links.fleet.installElasticAgent,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.enrollmentInstructions.installationMessage.link",
        defaultMessage: "installation docs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_.PlatformSelector, {
    installCommand: installCommands,
    hasK8sIntegration: false,
    hasK8sIntegrationMultiPage: false,
    hasFleetServer: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }));
};