"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChunks = createChunks;
exports.toEsDoc = toEsDoc;
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createChunks(features, geoFieldType, maxChunkCharCount) {
  const chunks = [];
  let chunk = [];
  let chunkChars = 0;
  for (let i = 0; i < features.length; i++) {
    const doc = toEsDoc(features[i], geoFieldType);
    const docChars = JSON.stringify(doc).length + 1; // +1 adds CHAR for comma once document is in list
    if (chunk.length === 0 || chunkChars + docChars < maxChunkCharCount) {
      // add ES document to current chunk
      chunk.push(doc);
      chunkChars += docChars;
    } else {
      // chunk boundary found, start new chunk
      chunks.push(chunk);
      chunk = [doc];
      chunkChars = docChars;
    }
  }
  if (chunk.length) {
    chunks.push(chunk);
  }
  return chunks;
}
function toEsDoc(feature, geoFieldType) {
  const properties = feature.properties ? feature.properties : {};
  return {
    geometry: geoFieldType === _public.ES_FIELD_TYPES.GEO_SHAPE ? feature.geometry : feature.geometry.coordinates,
    ...properties
  };
}