"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsHeatmapConfig = getSyntheticsHeatmapConfig;
var _constants = require("../constants");
var _labels = require("../constants/labels");
var _synthetics = require("../constants/field_names/synthetics");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUMMARY_UP = 'summary.up';
const SUMMARY_DOWN = 'summary.down';
function getSyntheticsHeatmapConfig({
  dataView
}) {
  return {
    reportType: _constants.ReportTypes.HEATMAP,
    defaultSeriesType: 'bar_stacked',
    seriesTypes: [],
    xAxisColumn: {
      sourceField: '@timestamp'
    },
    yAxisColumns: [{
      sourceField: _constants.REPORT_METRIC_FIELD,
      operationType: 'median'
    }],
    hasOperationType: false,
    filterFields: ['observer.geo.name', 'monitor.type', 'tags', 'url.full'],
    breakdownFields: ['observer.geo.name', 'monitor.type', 'monitor.name', _synthetics.SYNTHETICS_STEP_NAME],
    baseFilters: [],
    definitionFields: [{
      field: 'monitor.name'
    }, {
      field: 'url.full',
      filters: (0, _utils.buildExistsFilter)('summary.up', dataView)
    }],
    metricOptions: [{
      label: 'Failed tests',
      id: 'failed_tests',
      columnFilter: {
        language: 'kuery',
        query: 'summary.down > 0'
      },
      format: 'number',
      field: _constants.RECORDS_FIELD
    }],
    labels: {
      ..._constants.FieldLabels,
      [SUMMARY_UP]: _labels.UP_LABEL,
      [SUMMARY_DOWN]: _labels.DOWN_LABEL
    }
  };
}