"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr = require("antlr4");
var _lexer_config = _interopRequireDefault(require("./lexer_config.js"));
var _esql_lexer; // @ts-nocheck
// Generated from src/antlr/esql_lexer.g4 by ANTLR 4.13.2
// noinspection ES6UnusedImports,JSUnusedGlobalSymbols,JSUnusedLocalSymbols
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class esql_lexer extends _lexer_config.default {
  constructor(input) {
    super(input);
    this._interp = new _antlr.LexerATNSimulator(this, esql_lexer._ATN, esql_lexer.DecisionsToDFA, new _antlr.PredictionContextCache());
  }
  get grammarFileName() {
    return "esql_lexer.g4";
  }
  get literalNames() {
    return esql_lexer.literalNames;
  }
  get symbolicNames() {
    return esql_lexer.symbolicNames;
  }
  get ruleNames() {
    return esql_lexer.ruleNames;
  }
  get serializedATN() {
    return esql_lexer._serializedATN;
  }
  get channelNames() {
    return esql_lexer.channelNames;
  }
  get modeNames() {
    return esql_lexer.modeNames;
  }

  // @Override
  sempred(localctx, ruleIndex, predIndex) {
    switch (ruleIndex) {
      case 5:
        return this.DEV_EXPLAIN_sempred(localctx, predIndex);
      case 24:
        return this.DEV_JOIN_FULL_sempred(localctx, predIndex);
      case 25:
        return this.DEV_JOIN_LEFT_sempred(localctx, predIndex);
      case 26:
        return this.DEV_JOIN_RIGHT_sempred(localctx, predIndex);
      case 27:
        return this.DEV_LOOKUP_sempred(localctx, predIndex);
      case 31:
        return this.DEV_INSIST_sempred(localctx, predIndex);
    }
    return true;
  }
  DEV_EXPLAIN_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 0:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_JOIN_FULL_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 1:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_JOIN_LEFT_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 2:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_JOIN_RIGHT_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 3:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_LOOKUP_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 4:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_INSIST_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 5:
        return this.isDevVersion();
    }
    return true;
  }
  static get _ATN() {
    if (!esql_lexer.__ATN) {
      esql_lexer.__ATN = new _antlr.ATNDeserializer().deserialize(esql_lexer._serializedATN);
    }
    return esql_lexer.__ATN;
  }
}
exports.default = esql_lexer;
_esql_lexer = esql_lexer;
(0, _defineProperty2.default)(esql_lexer, "LINE_COMMENT", 1);
(0, _defineProperty2.default)(esql_lexer, "MULTILINE_COMMENT", 2);
(0, _defineProperty2.default)(esql_lexer, "WS", 3);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT", 4);
(0, _defineProperty2.default)(esql_lexer, "ENRICH", 5);
(0, _defineProperty2.default)(esql_lexer, "DEV_EXPLAIN", 6);
(0, _defineProperty2.default)(esql_lexer, "COMPLETION", 7);
(0, _defineProperty2.default)(esql_lexer, "DISSECT", 8);
(0, _defineProperty2.default)(esql_lexer, "EVAL", 9);
(0, _defineProperty2.default)(esql_lexer, "GROK", 10);
(0, _defineProperty2.default)(esql_lexer, "LIMIT", 11);
(0, _defineProperty2.default)(esql_lexer, "RERANK", 12);
(0, _defineProperty2.default)(esql_lexer, "ROW", 13);
(0, _defineProperty2.default)(esql_lexer, "SAMPLE", 14);
(0, _defineProperty2.default)(esql_lexer, "SORT", 15);
(0, _defineProperty2.default)(esql_lexer, "STATS", 16);
(0, _defineProperty2.default)(esql_lexer, "WHERE", 17);
(0, _defineProperty2.default)(esql_lexer, "FROM", 18);
(0, _defineProperty2.default)(esql_lexer, "TS", 19);
(0, _defineProperty2.default)(esql_lexer, "FORK", 20);
(0, _defineProperty2.default)(esql_lexer, "FUSE", 21);
(0, _defineProperty2.default)(esql_lexer, "INLINE", 22);
(0, _defineProperty2.default)(esql_lexer, "INLINESTATS", 23);
(0, _defineProperty2.default)(esql_lexer, "JOIN_LOOKUP", 24);
(0, _defineProperty2.default)(esql_lexer, "DEV_JOIN_FULL", 25);
(0, _defineProperty2.default)(esql_lexer, "DEV_JOIN_LEFT", 26);
(0, _defineProperty2.default)(esql_lexer, "DEV_JOIN_RIGHT", 27);
(0, _defineProperty2.default)(esql_lexer, "DEV_LOOKUP", 28);
(0, _defineProperty2.default)(esql_lexer, "MV_EXPAND", 29);
(0, _defineProperty2.default)(esql_lexer, "DROP", 30);
(0, _defineProperty2.default)(esql_lexer, "KEEP", 31);
(0, _defineProperty2.default)(esql_lexer, "DEV_INSIST", 32);
(0, _defineProperty2.default)(esql_lexer, "RENAME", 33);
(0, _defineProperty2.default)(esql_lexer, "SET", 34);
(0, _defineProperty2.default)(esql_lexer, "SHOW", 35);
(0, _defineProperty2.default)(esql_lexer, "UNKNOWN_CMD", 36);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT_LINE_COMMENT", 37);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT_MULTILINE_COMMENT", 38);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT_WS", 39);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_POLICY_NAME", 40);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_LINE_COMMENT", 41);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_MULTILINE_COMMENT", 42);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_WS", 43);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_FIELD_LINE_COMMENT", 44);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_FIELD_MULTILINE_COMMENT", 45);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_FIELD_WS", 46);
(0, _defineProperty2.default)(esql_lexer, "EXPLAIN_WS", 47);
(0, _defineProperty2.default)(esql_lexer, "EXPLAIN_LINE_COMMENT", 48);
(0, _defineProperty2.default)(esql_lexer, "EXPLAIN_MULTILINE_COMMENT", 49);
(0, _defineProperty2.default)(esql_lexer, "PIPE", 50);
(0, _defineProperty2.default)(esql_lexer, "QUOTED_STRING", 51);
(0, _defineProperty2.default)(esql_lexer, "INTEGER_LITERAL", 52);
(0, _defineProperty2.default)(esql_lexer, "DECIMAL_LITERAL", 53);
(0, _defineProperty2.default)(esql_lexer, "AND", 54);
(0, _defineProperty2.default)(esql_lexer, "ASC", 55);
(0, _defineProperty2.default)(esql_lexer, "ASSIGN", 56);
(0, _defineProperty2.default)(esql_lexer, "BY", 57);
(0, _defineProperty2.default)(esql_lexer, "CAST_OP", 58);
(0, _defineProperty2.default)(esql_lexer, "COLON", 59);
(0, _defineProperty2.default)(esql_lexer, "SEMICOLON", 60);
(0, _defineProperty2.default)(esql_lexer, "COMMA", 61);
(0, _defineProperty2.default)(esql_lexer, "DESC", 62);
(0, _defineProperty2.default)(esql_lexer, "DOT", 63);
(0, _defineProperty2.default)(esql_lexer, "FALSE", 64);
(0, _defineProperty2.default)(esql_lexer, "FIRST", 65);
(0, _defineProperty2.default)(esql_lexer, "IN", 66);
(0, _defineProperty2.default)(esql_lexer, "IS", 67);
(0, _defineProperty2.default)(esql_lexer, "LAST", 68);
(0, _defineProperty2.default)(esql_lexer, "LIKE", 69);
(0, _defineProperty2.default)(esql_lexer, "NOT", 70);
(0, _defineProperty2.default)(esql_lexer, "NULL", 71);
(0, _defineProperty2.default)(esql_lexer, "NULLS", 72);
(0, _defineProperty2.default)(esql_lexer, "ON", 73);
(0, _defineProperty2.default)(esql_lexer, "OR", 74);
(0, _defineProperty2.default)(esql_lexer, "PARAM", 75);
(0, _defineProperty2.default)(esql_lexer, "RLIKE", 76);
(0, _defineProperty2.default)(esql_lexer, "TRUE", 77);
(0, _defineProperty2.default)(esql_lexer, "WITH", 78);
(0, _defineProperty2.default)(esql_lexer, "EQ", 79);
(0, _defineProperty2.default)(esql_lexer, "CIEQ", 80);
(0, _defineProperty2.default)(esql_lexer, "NEQ", 81);
(0, _defineProperty2.default)(esql_lexer, "LT", 82);
(0, _defineProperty2.default)(esql_lexer, "LTE", 83);
(0, _defineProperty2.default)(esql_lexer, "GT", 84);
(0, _defineProperty2.default)(esql_lexer, "GTE", 85);
(0, _defineProperty2.default)(esql_lexer, "PLUS", 86);
(0, _defineProperty2.default)(esql_lexer, "MINUS", 87);
(0, _defineProperty2.default)(esql_lexer, "ASTERISK", 88);
(0, _defineProperty2.default)(esql_lexer, "SLASH", 89);
(0, _defineProperty2.default)(esql_lexer, "PERCENT", 90);
(0, _defineProperty2.default)(esql_lexer, "LEFT_BRACES", 91);
(0, _defineProperty2.default)(esql_lexer, "RIGHT_BRACES", 92);
(0, _defineProperty2.default)(esql_lexer, "DOUBLE_PARAMS", 93);
(0, _defineProperty2.default)(esql_lexer, "NAMED_OR_POSITIONAL_PARAM", 94);
(0, _defineProperty2.default)(esql_lexer, "NAMED_OR_POSITIONAL_DOUBLE_PARAMS", 95);
(0, _defineProperty2.default)(esql_lexer, "OPENING_BRACKET", 96);
(0, _defineProperty2.default)(esql_lexer, "CLOSING_BRACKET", 97);
(0, _defineProperty2.default)(esql_lexer, "LP", 98);
(0, _defineProperty2.default)(esql_lexer, "RP", 99);
(0, _defineProperty2.default)(esql_lexer, "UNQUOTED_IDENTIFIER", 100);
(0, _defineProperty2.default)(esql_lexer, "QUOTED_IDENTIFIER", 101);
(0, _defineProperty2.default)(esql_lexer, "EXPR_LINE_COMMENT", 102);
(0, _defineProperty2.default)(esql_lexer, "EXPR_MULTILINE_COMMENT", 103);
(0, _defineProperty2.default)(esql_lexer, "EXPR_WS", 104);
(0, _defineProperty2.default)(esql_lexer, "METADATA", 105);
(0, _defineProperty2.default)(esql_lexer, "UNQUOTED_SOURCE", 106);
(0, _defineProperty2.default)(esql_lexer, "FROM_LINE_COMMENT", 107);
(0, _defineProperty2.default)(esql_lexer, "FROM_MULTILINE_COMMENT", 108);
(0, _defineProperty2.default)(esql_lexer, "FROM_WS", 109);
(0, _defineProperty2.default)(esql_lexer, "FORK_WS", 110);
(0, _defineProperty2.default)(esql_lexer, "FORK_LINE_COMMENT", 111);
(0, _defineProperty2.default)(esql_lexer, "FORK_MULTILINE_COMMENT", 112);
(0, _defineProperty2.default)(esql_lexer, "GROUP", 113);
(0, _defineProperty2.default)(esql_lexer, "SCORE", 114);
(0, _defineProperty2.default)(esql_lexer, "KEY", 115);
(0, _defineProperty2.default)(esql_lexer, "FUSE_LINE_COMMENT", 116);
(0, _defineProperty2.default)(esql_lexer, "FUSE_MULTILINE_COMMENT", 117);
(0, _defineProperty2.default)(esql_lexer, "FUSE_WS", 118);
(0, _defineProperty2.default)(esql_lexer, "INLINE_STATS", 119);
(0, _defineProperty2.default)(esql_lexer, "INLINE_LINE_COMMENT", 120);
(0, _defineProperty2.default)(esql_lexer, "INLINE_MULTILINE_COMMENT", 121);
(0, _defineProperty2.default)(esql_lexer, "INLINE_WS", 122);
(0, _defineProperty2.default)(esql_lexer, "JOIN", 123);
(0, _defineProperty2.default)(esql_lexer, "USING", 124);
(0, _defineProperty2.default)(esql_lexer, "JOIN_LINE_COMMENT", 125);
(0, _defineProperty2.default)(esql_lexer, "JOIN_MULTILINE_COMMENT", 126);
(0, _defineProperty2.default)(esql_lexer, "JOIN_WS", 127);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_LINE_COMMENT", 128);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_MULTILINE_COMMENT", 129);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_WS", 130);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_FIELD_LINE_COMMENT", 131);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_FIELD_MULTILINE_COMMENT", 132);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_FIELD_WS", 133);
(0, _defineProperty2.default)(esql_lexer, "MVEXPAND_LINE_COMMENT", 134);
(0, _defineProperty2.default)(esql_lexer, "MVEXPAND_MULTILINE_COMMENT", 135);
(0, _defineProperty2.default)(esql_lexer, "MVEXPAND_WS", 136);
(0, _defineProperty2.default)(esql_lexer, "ID_PATTERN", 137);
(0, _defineProperty2.default)(esql_lexer, "PROJECT_LINE_COMMENT", 138);
(0, _defineProperty2.default)(esql_lexer, "PROJECT_MULTILINE_COMMENT", 139);
(0, _defineProperty2.default)(esql_lexer, "PROJECT_WS", 140);
(0, _defineProperty2.default)(esql_lexer, "AS", 141);
(0, _defineProperty2.default)(esql_lexer, "RENAME_LINE_COMMENT", 142);
(0, _defineProperty2.default)(esql_lexer, "RENAME_MULTILINE_COMMENT", 143);
(0, _defineProperty2.default)(esql_lexer, "RENAME_WS", 144);
(0, _defineProperty2.default)(esql_lexer, "SET_LINE_COMMENT", 145);
(0, _defineProperty2.default)(esql_lexer, "SET_MULTILINE_COMMENT", 146);
(0, _defineProperty2.default)(esql_lexer, "SET_WS", 147);
(0, _defineProperty2.default)(esql_lexer, "INFO", 148);
(0, _defineProperty2.default)(esql_lexer, "SHOW_LINE_COMMENT", 149);
(0, _defineProperty2.default)(esql_lexer, "SHOW_MULTILINE_COMMENT", 150);
(0, _defineProperty2.default)(esql_lexer, "SHOW_WS", 151);
(0, _defineProperty2.default)(esql_lexer, "EOF", _antlr.Token.EOF);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT_MODE", 1);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_MODE", 2);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_FIELD_MODE", 3);
(0, _defineProperty2.default)(esql_lexer, "EXPLAIN_MODE", 4);
(0, _defineProperty2.default)(esql_lexer, "EXPRESSION_MODE", 5);
(0, _defineProperty2.default)(esql_lexer, "FROM_MODE", 6);
(0, _defineProperty2.default)(esql_lexer, "FORK_MODE", 7);
(0, _defineProperty2.default)(esql_lexer, "FUSE_MODE", 8);
(0, _defineProperty2.default)(esql_lexer, "INLINE_MODE", 9);
(0, _defineProperty2.default)(esql_lexer, "JOIN_MODE", 10);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_MODE", 11);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_FIELD_MODE", 12);
(0, _defineProperty2.default)(esql_lexer, "MVEXPAND_MODE", 13);
(0, _defineProperty2.default)(esql_lexer, "PROJECT_MODE", 14);
(0, _defineProperty2.default)(esql_lexer, "RENAME_MODE", 15);
(0, _defineProperty2.default)(esql_lexer, "SET_MODE", 16);
(0, _defineProperty2.default)(esql_lexer, "SHOW_MODE", 17);
(0, _defineProperty2.default)(esql_lexer, "channelNames", ["DEFAULT_TOKEN_CHANNEL", "HIDDEN"]);
(0, _defineProperty2.default)(esql_lexer, "literalNames", [null, null, null, null, "'change_point'", "'enrich'", null, "'completion'", "'dissect'", "'eval'", "'grok'", "'limit'", "'rerank'", "'row'", "'sample'", "'sort'", null, "'where'", "'from'", "'ts'", "'fork'", "'fuse'", "'inline'", "'inlinestats'", "'lookup'", null, null, null, null, "'mv_expand'", "'drop'", "'keep'", null, "'rename'", "'set'", "'show'", null, null, null, null, null, null, null, null, null, null, null, null, null, null, "'|'", null, null, null, "'and'", "'asc'", "'='", "'by'", "'::'", "':'", "';'", "','", "'desc'", "'.'", "'false'", "'first'", "'in'", "'is'", "'last'", "'like'", "'not'", "'null'", "'nulls'", "'on'", "'or'", "'?'", "'rlike'", "'true'", "'with'", "'=='", "'=~'", "'!='", "'<'", "'<='", "'>'", "'>='", "'+'", "'-'", "'*'", "'/'", "'%'", "'{'", "'}'", "'??'", null, null, null, "']'", null, "')'", null, null, null, null, null, "'metadata'", null, null, null, null, null, null, null, "'group'", "'score'", "'key'", null, null, null, null, null, null, null, "'join'", "'USING'", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "'as'", null, null, null, null, null, null, "'info'"]);
(0, _defineProperty2.default)(esql_lexer, "symbolicNames", [null, "LINE_COMMENT", "MULTILINE_COMMENT", "WS", "CHANGE_POINT", "ENRICH", "DEV_EXPLAIN", "COMPLETION", "DISSECT", "EVAL", "GROK", "LIMIT", "RERANK", "ROW", "SAMPLE", "SORT", "STATS", "WHERE", "FROM", "TS", "FORK", "FUSE", "INLINE", "INLINESTATS", "JOIN_LOOKUP", "DEV_JOIN_FULL", "DEV_JOIN_LEFT", "DEV_JOIN_RIGHT", "DEV_LOOKUP", "MV_EXPAND", "DROP", "KEEP", "DEV_INSIST", "RENAME", "SET", "SHOW", "UNKNOWN_CMD", "CHANGE_POINT_LINE_COMMENT", "CHANGE_POINT_MULTILINE_COMMENT", "CHANGE_POINT_WS", "ENRICH_POLICY_NAME", "ENRICH_LINE_COMMENT", "ENRICH_MULTILINE_COMMENT", "ENRICH_WS", "ENRICH_FIELD_LINE_COMMENT", "ENRICH_FIELD_MULTILINE_COMMENT", "ENRICH_FIELD_WS", "EXPLAIN_WS", "EXPLAIN_LINE_COMMENT", "EXPLAIN_MULTILINE_COMMENT", "PIPE", "QUOTED_STRING", "INTEGER_LITERAL", "DECIMAL_LITERAL", "AND", "ASC", "ASSIGN", "BY", "CAST_OP", "COLON", "SEMICOLON", "COMMA", "DESC", "DOT", "FALSE", "FIRST", "IN", "IS", "LAST", "LIKE", "NOT", "NULL", "NULLS", "ON", "OR", "PARAM", "RLIKE", "TRUE", "WITH", "EQ", "CIEQ", "NEQ", "LT", "LTE", "GT", "GTE", "PLUS", "MINUS", "ASTERISK", "SLASH", "PERCENT", "LEFT_BRACES", "RIGHT_BRACES", "DOUBLE_PARAMS", "NAMED_OR_POSITIONAL_PARAM", "NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "OPENING_BRACKET", "CLOSING_BRACKET", "LP", "RP", "UNQUOTED_IDENTIFIER", "QUOTED_IDENTIFIER", "EXPR_LINE_COMMENT", "EXPR_MULTILINE_COMMENT", "EXPR_WS", "METADATA", "UNQUOTED_SOURCE", "FROM_LINE_COMMENT", "FROM_MULTILINE_COMMENT", "FROM_WS", "FORK_WS", "FORK_LINE_COMMENT", "FORK_MULTILINE_COMMENT", "GROUP", "SCORE", "KEY", "FUSE_LINE_COMMENT", "FUSE_MULTILINE_COMMENT", "FUSE_WS", "INLINE_STATS", "INLINE_LINE_COMMENT", "INLINE_MULTILINE_COMMENT", "INLINE_WS", "JOIN", "USING", "JOIN_LINE_COMMENT", "JOIN_MULTILINE_COMMENT", "JOIN_WS", "LOOKUP_LINE_COMMENT", "LOOKUP_MULTILINE_COMMENT", "LOOKUP_WS", "LOOKUP_FIELD_LINE_COMMENT", "LOOKUP_FIELD_MULTILINE_COMMENT", "LOOKUP_FIELD_WS", "MVEXPAND_LINE_COMMENT", "MVEXPAND_MULTILINE_COMMENT", "MVEXPAND_WS", "ID_PATTERN", "PROJECT_LINE_COMMENT", "PROJECT_MULTILINE_COMMENT", "PROJECT_WS", "AS", "RENAME_LINE_COMMENT", "RENAME_MULTILINE_COMMENT", "RENAME_WS", "SET_LINE_COMMENT", "SET_MULTILINE_COMMENT", "SET_WS", "INFO", "SHOW_LINE_COMMENT", "SHOW_MULTILINE_COMMENT", "SHOW_WS"]);
(0, _defineProperty2.default)(esql_lexer, "modeNames", ["DEFAULT_MODE", "CHANGE_POINT_MODE", "ENRICH_MODE", "ENRICH_FIELD_MODE", "EXPLAIN_MODE", "EXPRESSION_MODE", "FROM_MODE", "FORK_MODE", "FUSE_MODE", "INLINE_MODE", "JOIN_MODE", "LOOKUP_MODE", "LOOKUP_FIELD_MODE", "MVEXPAND_MODE", "PROJECT_MODE", "RENAME_MODE", "SET_MODE", "SHOW_MODE"]);
(0, _defineProperty2.default)(esql_lexer, "ruleNames", ["LINE_COMMENT", "MULTILINE_COMMENT", "WS", "CHANGE_POINT", "ENRICH", "DEV_EXPLAIN", "COMPLETION", "DISSECT", "EVAL", "GROK", "LIMIT", "RERANK", "ROW", "SAMPLE", "SORT", "STATS", "WHERE", "FROM", "TS", "FORK", "FUSE", "INLINE", "INLINESTATS", "JOIN_LOOKUP", "DEV_JOIN_FULL", "DEV_JOIN_LEFT", "DEV_JOIN_RIGHT", "DEV_LOOKUP", "MV_EXPAND", "DROP", "KEEP", "DEV_INSIST", "RENAME", "SET", "SHOW", "UNKNOWN_CMD", "CHANGE_POINT_PIPE", "CHANGE_POINT_RP", "CHANGE_POINT_ON", "CHANGE_POINT_AS", "CHANGE_POINT_DOT", "CHANGE_POINT_COMMA", "CHANGE_POINT_OPENING_BRACKET", "CHANGE_POINT_CLOSING_BRACKET", "CHANGE_POINT_QUOTED_IDENTIFIER", "CHANGE_POINT_UNQUOTED_IDENTIFIER", "CHANGE_POINT_LINE_COMMENT", "CHANGE_POINT_MULTILINE_COMMENT", "CHANGE_POINT_WS", "ENRICH_PIPE", "ENRICH_RP", "ENRICH_ON", "ENRICH_WITH", "ENRICH_POLICY_NAME_BODY", "ENRICH_POLICY_NAME", "ENRICH_MODE_UNQUOTED_VALUE", "ENRICH_QUOTED_POLICY_NAME", "ENRICH_LINE_COMMENT", "ENRICH_MULTILINE_COMMENT", "ENRICH_WS", "ENRICH_FIELD_PIPE", "ENRICH_FIELD_RP", "ENRICH_FIELD_OPENING_BRACKET", "ENRICH_FIELD_CLOSING_BRACKET", "ENRICH_FIELD_ASSIGN", "ENRICH_FIELD_COMMA", "ENRICH_FIELD_DOT", "ENRICH_FIELD_WITH", "ENRICH_FIELD_ID_PATTERN", "ENRICH_FIELD_QUOTED_IDENTIFIER", "ENRICH_FIELD_PARAM", "ENRICH_FIELD_NAMED_OR_POSITIONAL_PARAM", "ENRICH_FIELD_DOUBLE_PARAMS", "ENRICH_FIELD_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "ENRICH_FIELD_LINE_COMMENT", "ENRICH_FIELD_MULTILINE_COMMENT", "ENRICH_FIELD_WS", "EXPLAIN_LP", "EXPLAIN_PIPE", "EXPLAIN_WS", "EXPLAIN_LINE_COMMENT", "EXPLAIN_MULTILINE_COMMENT", "PIPE", "DIGIT", "LETTER", "ESCAPE_SEQUENCE", "UNESCAPED_CHARS", "EXPONENT", "ASPERAND", "BACKQUOTE", "BACKQUOTE_BLOCK", "UNDERSCORE", "UNQUOTED_ID_BODY", "QUOTED_STRING", "INTEGER_LITERAL", "DECIMAL_LITERAL", "AND", "ASC", "ASSIGN", "BY", "CAST_OP", "COLON", "SEMICOLON", "COMMA", "DESC", "DOT", "FALSE", "FIRST", "IN", "IS", "LAST", "LIKE", "NOT", "NULL", "NULLS", "ON", "OR", "PARAM", "RLIKE", "TRUE", "WITH", "EQ", "CIEQ", "NEQ", "LT", "LTE", "GT", "GTE", "PLUS", "MINUS", "ASTERISK", "SLASH", "PERCENT", "LEFT_BRACES", "RIGHT_BRACES", "DOUBLE_PARAMS", "NESTED_WHERE", "NAMED_OR_POSITIONAL_PARAM", "NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "OPENING_BRACKET", "CLOSING_BRACKET", "LP", "RP", "UNQUOTED_IDENTIFIER", "QUOTED_ID", "QUOTED_IDENTIFIER", "EXPR_LINE_COMMENT", "EXPR_MULTILINE_COMMENT", "EXPR_WS", "FROM_PIPE", "FROM_COLON", "FROM_SELECTOR", "FROM_COMMA", "FROM_ASSIGN", "METADATA", "FROM_RP", "UNQUOTED_SOURCE_PART", "UNQUOTED_SOURCE", "FROM_UNQUOTED_SOURCE", "FROM_QUOTED_SOURCE", "FROM_LINE_COMMENT", "FROM_MULTILINE_COMMENT", "FROM_WS", "FORK_LP", "FORK_RP", "FORK_PIPE", "FORK_WS", "FORK_LINE_COMMENT", "FORK_MULTILINE_COMMENT", "FUSE_PIPE", "FUSE_RP", "GROUP", "SCORE", "KEY", "FUSE_WITH", "FUSE_COMMA", "FUSE_DOT", "FUSE_PARAM", "FUSE_NAMED_OR_POSITIONAL_PARAM", "FUSE_DOUBLE_PARAMS", "FUSE_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "FUSE_BY", "FUSE_QUOTED_IDENTIFIER", "FUSE_UNQUOTED_IDENTIFIER", "FUSE_LINE_COMMENT", "FUSE_MULTILINE_COMMENT", "FUSE_WS", "INLINE_STATS", "INLINE_LINE_COMMENT", "INLINE_MULTILINE_COMMENT", "INLINE_WS", "JOIN_PIPE", "JOIN", "JOIN_AS", "JOIN_ON", "USING", "JOIN_UNQUOTED_SOURCE", "JOIN_QUOTED_SOURCE", "JOIN_COLON", "JOIN_LINE_COMMENT", "JOIN_MULTILINE_COMMENT", "JOIN_WS", "LOOKUP_PIPE", "LOOKUP_RP", "LOOKUP_COLON", "LOOKUP_COMMA", "LOOKUP_DOT", "LOOKUP_ON", "LOOKUP_UNQUOTED_SOURCE", "LOOKUP_QUOTED_SOURCE", "LOOKUP_LINE_COMMENT", "LOOKUP_MULTILINE_COMMENT", "LOOKUP_WS", "LOOKUP_FIELD_PIPE", "LOOK_FIELD_RP", "LOOKUP_FIELD_COMMA", "LOOKUP_FIELD_DOT", "LOOKUP_FIELD_ID_PATTERN", "LOOKUP_FIELD_LINE_COMMENT", "LOOKUP_FIELD_MULTILINE_COMMENT", "LOOKUP_FIELD_WS", "MVEXPAND_PIPE", "MVEXPAND_RP", "MV_EXPAND_OPENING_BRACKET", "MV_EXPAND_CLOSING_BRACKET", "MVEXPAND_DOT", "MVEXPAND_PARAM", "MVEXPAND_NAMED_OR_POSITIONAL_PARAM", "MVEXPAND_DOUBLE_PARAMS", "MVEXPAND_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "MVEXPAND_QUOTED_IDENTIFIER", "MVEXPAND_UNQUOTED_IDENTIFIER", "MVEXPAND_LINE_COMMENT", "MVEXPAND_MULTILINE_COMMENT", "MVEXPAND_WS", "PROJECT_PIPE", "PROJECT_RP", "PROJECT_DOT", "PROJECT_OPENING_BRACKET", "PROJECT_CLOSING_BRACKET", "PROJECT_COMMA", "PROJECT_PARAM", "PROJECT_NAMED_OR_POSITIONAL_PARAM", "PROJECT_DOUBLE_PARAMS", "PROJECT_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "UNQUOTED_ID_BODY_WITH_PATTERN", "UNQUOTED_ID_PATTERN", "ID_PATTERN", "PROJECT_LINE_COMMENT", "PROJECT_MULTILINE_COMMENT", "PROJECT_WS", "RENAME_PIPE", "RENAME_RP", "RENAME_OPENING_BRACKET", "RENAME_CLOSING_BRACKET", "RENAME_ASSIGN", "RENAME_COMMA", "RENAME_DOT", "RENAME_PARAM", "RENAME_NAMED_OR_POSITIONAL_PARAM", "RENAME_DOUBLE_PARAMS", "RENAME_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "AS", "RENAME_ID_PATTERN", "RENAME_LINE_COMMENT", "RENAME_MULTILINE_COMMENT", "RENAME_WS", "SET_TRUE", "SET_FALSE", "SET_NULL", "SET_SEMICOLON", "SET_ASSIGN", "SET_QUOTED_STRING", "SET_UNQUOTED_IDENTIFIER", "SET_QUOTED_IDENTIFIER", "SET_DECIMAL_LITERAL", "SET_INTEGER_LITERAL", "SET_COMMA", "SET_DOT", "SET_PARAM", "SET_NAMED_OR_POSITIONAL_PARAM", "SET_DOUBLE_PARAMS", "SET_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "SET_OPENING_BRACKET", "SET_CLOSING_BRACKET", "SET_ID_PATTERN", "SET_LINE_COMMENT", "SET_MULTILINE_COMMENT", "SET_WS", "SHOW_PIPE", "INFO", "SHOW_LINE_COMMENT", "SHOW_MULTILINE_COMMENT", "SHOW_WS"]);
(0, _defineProperty2.default)(esql_lexer, "_serializedATN", [4, 0, 151, 2150, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 2, 0, 7, 0, 2, 1, 7, 1, 2, 2, 7, 2, 2, 3, 7, 3, 2, 4, 7, 4, 2, 5, 7, 5, 2, 6, 7, 6, 2, 7, 7, 7, 2, 8, 7, 8, 2, 9, 7, 9, 2, 10, 7, 10, 2, 11, 7, 11, 2, 12, 7, 12, 2, 13, 7, 13, 2, 14, 7, 14, 2, 15, 7, 15, 2, 16, 7, 16, 2, 17, 7, 17, 2, 18, 7, 18, 2, 19, 7, 19, 2, 20, 7, 20, 2, 21, 7, 21, 2, 22, 7, 22, 2, 23, 7, 23, 2, 24, 7, 24, 2, 25, 7, 25, 2, 26, 7, 26, 2, 27, 7, 27, 2, 28, 7, 28, 2, 29, 7, 29, 2, 30, 7, 30, 2, 31, 7, 31, 2, 32, 7, 32, 2, 33, 7, 33, 2, 34, 7, 34, 2, 35, 7, 35, 2, 36, 7, 36, 2, 37, 7, 37, 2, 38, 7, 38, 2, 39, 7, 39, 2, 40, 7, 40, 2, 41, 7, 41, 2, 42, 7, 42, 2, 43, 7, 43, 2, 44, 7, 44, 2, 45, 7, 45, 2, 46, 7, 46, 2, 47, 7, 47, 2, 48, 7, 48, 2, 49, 7, 49, 2, 50, 7, 50, 2, 51, 7, 51, 2, 52, 7, 52, 2, 53, 7, 53, 2, 54, 7, 54, 2, 55, 7, 55, 2, 56, 7, 56, 2, 57, 7, 57, 2, 58, 7, 58, 2, 59, 7, 59, 2, 60, 7, 60, 2, 61, 7, 61, 2, 62, 7, 62, 2, 63, 7, 63, 2, 64, 7, 64, 2, 65, 7, 65, 2, 66, 7, 66, 2, 67, 7, 67, 2, 68, 7, 68, 2, 69, 7, 69, 2, 70, 7, 70, 2, 71, 7, 71, 2, 72, 7, 72, 2, 73, 7, 73, 2, 74, 7, 74, 2, 75, 7, 75, 2, 76, 7, 76, 2, 77, 7, 77, 2, 78, 7, 78, 2, 79, 7, 79, 2, 80, 7, 80, 2, 81, 7, 81, 2, 82, 7, 82, 2, 83, 7, 83, 2, 84, 7, 84, 2, 85, 7, 85, 2, 86, 7, 86, 2, 87, 7, 87, 2, 88, 7, 88, 2, 89, 7, 89, 2, 90, 7, 90, 2, 91, 7, 91, 2, 92, 7, 92, 2, 93, 7, 93, 2, 94, 7, 94, 2, 95, 7, 95, 2, 96, 7, 96, 2, 97, 7, 97, 2, 98, 7, 98, 2, 99, 7, 99, 2, 100, 7, 100, 2, 101, 7, 101, 2, 102, 7, 102, 2, 103, 7, 103, 2, 104, 7, 104, 2, 105, 7, 105, 2, 106, 7, 106, 2, 107, 7, 107, 2, 108, 7, 108, 2, 109, 7, 109, 2, 110, 7, 110, 2, 111, 7, 111, 2, 112, 7, 112, 2, 113, 7, 113, 2, 114, 7, 114, 2, 115, 7, 115, 2, 116, 7, 116, 2, 117, 7, 117, 2, 118, 7, 118, 2, 119, 7, 119, 2, 120, 7, 120, 2, 121, 7, 121, 2, 122, 7, 122, 2, 123, 7, 123, 2, 124, 7, 124, 2, 125, 7, 125, 2, 126, 7, 126, 2, 127, 7, 127, 2, 128, 7, 128, 2, 129, 7, 129, 2, 130, 7, 130, 2, 131, 7, 131, 2, 132, 7, 132, 2, 133, 7, 133, 2, 134, 7, 134, 2, 135, 7, 135, 2, 136, 7, 136, 2, 137, 7, 137, 2, 138, 7, 138, 2, 139, 7, 139, 2, 140, 7, 140, 2, 141, 7, 141, 2, 142, 7, 142, 2, 143, 7, 143, 2, 144, 7, 144, 2, 145, 7, 145, 2, 146, 7, 146, 2, 147, 7, 147, 2, 148, 7, 148, 2, 149, 7, 149, 2, 150, 7, 150, 2, 151, 7, 151, 2, 152, 7, 152, 2, 153, 7, 153, 2, 154, 7, 154, 2, 155, 7, 155, 2, 156, 7, 156, 2, 157, 7, 157, 2, 158, 7, 158, 2, 159, 7, 159, 2, 160, 7, 160, 2, 161, 7, 161, 2, 162, 7, 162, 2, 163, 7, 163, 2, 164, 7, 164, 2, 165, 7, 165, 2, 166, 7, 166, 2, 167, 7, 167, 2, 168, 7, 168, 2, 169, 7, 169, 2, 170, 7, 170, 2, 171, 7, 171, 2, 172, 7, 172, 2, 173, 7, 173, 2, 174, 7, 174, 2, 175, 7, 175, 2, 176, 7, 176, 2, 177, 7, 177, 2, 178, 7, 178, 2, 179, 7, 179, 2, 180, 7, 180, 2, 181, 7, 181, 2, 182, 7, 182, 2, 183, 7, 183, 2, 184, 7, 184, 2, 185, 7, 185, 2, 186, 7, 186, 2, 187, 7, 187, 2, 188, 7, 188, 2, 189, 7, 189, 2, 190, 7, 190, 2, 191, 7, 191, 2, 192, 7, 192, 2, 193, 7, 193, 2, 194, 7, 194, 2, 195, 7, 195, 2, 196, 7, 196, 2, 197, 7, 197, 2, 198, 7, 198, 2, 199, 7, 199, 2, 200, 7, 200, 2, 201, 7, 201, 2, 202, 7, 202, 2, 203, 7, 203, 2, 204, 7, 204, 2, 205, 7, 205, 2, 206, 7, 206, 2, 207, 7, 207, 2, 208, 7, 208, 2, 209, 7, 209, 2, 210, 7, 210, 2, 211, 7, 211, 2, 212, 7, 212, 2, 213, 7, 213, 2, 214, 7, 214, 2, 215, 7, 215, 2, 216, 7, 216, 2, 217, 7, 217, 2, 218, 7, 218, 2, 219, 7, 219, 2, 220, 7, 220, 2, 221, 7, 221, 2, 222, 7, 222, 2, 223, 7, 223, 2, 224, 7, 224, 2, 225, 7, 225, 2, 226, 7, 226, 2, 227, 7, 227, 2, 228, 7, 228, 2, 229, 7, 229, 2, 230, 7, 230, 2, 231, 7, 231, 2, 232, 7, 232, 2, 233, 7, 233, 2, 234, 7, 234, 2, 235, 7, 235, 2, 236, 7, 236, 2, 237, 7, 237, 2, 238, 7, 238, 2, 239, 7, 239, 2, 240, 7, 240, 2, 241, 7, 241, 2, 242, 7, 242, 2, 243, 7, 243, 2, 244, 7, 244, 2, 245, 7, 245, 2, 246, 7, 246, 2, 247, 7, 247, 2, 248, 7, 248, 2, 249, 7, 249, 2, 250, 7, 250, 2, 251, 7, 251, 2, 252, 7, 252, 2, 253, 7, 253, 2, 254, 7, 254, 2, 255, 7, 255, 2, 256, 7, 256, 2, 257, 7, 257, 2, 258, 7, 258, 2, 259, 7, 259, 2, 260, 7, 260, 2, 261, 7, 261, 2, 262, 7, 262, 2, 263, 7, 263, 2, 264, 7, 264, 2, 265, 7, 265, 2, 266, 7, 266, 2, 267, 7, 267, 2, 268, 7, 268, 2, 269, 7, 269, 2, 270, 7, 270, 2, 271, 7, 271, 2, 272, 7, 272, 2, 273, 7, 273, 2, 274, 7, 274, 2, 275, 7, 275, 2, 276, 7, 276, 2, 277, 7, 277, 2, 278, 7, 278, 2, 279, 7, 279, 2, 280, 7, 280, 2, 281, 7, 281, 2, 282, 7, 282, 2, 283, 7, 283, 2, 284, 7, 284, 2, 285, 7, 285, 2, 286, 7, 286, 2, 287, 7, 287, 2, 288, 7, 288, 2, 289, 7, 289, 2, 290, 7, 290, 2, 291, 7, 291, 2, 292, 7, 292, 2, 293, 7, 293, 1, 0, 1, 0, 1, 0, 1, 0, 5, 0, 611, 8, 0, 10, 0, 12, 0, 614, 9, 0, 1, 0, 3, 0, 617, 8, 0, 1, 0, 3, 0, 620, 8, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 629, 8, 1, 10, 1, 12, 1, 632, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 2, 640, 8, 2, 11, 2, 12, 2, 641, 1, 2, 1, 2, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 8, 1, 8, 1, 8, 1, 8, 1, 8, 1, 8, 1, 8, 1, 9, 1, 9, 1, 9, 1, 9, 1, 9, 1, 9, 1, 9, 1, 10, 1, 10, 1, 10, 1, 10, 1, 10, 1, 10, 1, 10, 1, 10, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 12, 1, 12, 1, 12, 1, 12, 1, 12, 1, 12, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 14, 1, 14, 1, 14, 1, 14, 1, 14, 1, 14, 1, 14, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 16, 1, 16, 1, 16, 1, 16, 1, 16, 1, 16, 1, 16, 1, 16, 1, 17, 1, 17, 1, 17, 1, 17, 1, 17, 1, 17, 1, 17, 1, 18, 1, 18, 1, 18, 1, 18, 1, 18, 1, 19, 1, 19, 1, 19, 1, 19, 1, 19, 1, 19, 1, 19, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 24, 1, 24, 1, 24, 1, 24, 1, 24, 1, 24, 1, 24, 1, 24, 1, 25, 1, 25, 1, 25, 1, 25, 1, 25, 1, 25, 1, 25, 1, 25, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 29, 1, 29, 1, 29, 1, 29, 1, 29, 1, 29, 1, 29, 1, 30, 1, 30, 1, 30, 1, 30, 1, 30, 1, 30, 1, 30, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 34, 1, 34, 1, 34, 1, 34, 1, 34, 1, 34, 1, 34, 1, 35, 4, 35, 929, 8, 35, 11, 35, 12, 35, 930, 1, 35, 1, 35, 1, 36, 1, 36, 1, 36, 1, 36, 1, 36, 1, 37, 1, 37, 1, 37, 1, 37, 1, 37, 1, 37, 1, 38, 1, 38, 1, 38, 1, 38, 1, 39, 1, 39, 1, 39, 1, 39, 1, 40, 1, 40, 1, 40, 1, 40, 1, 41, 1, 41, 1, 41, 1, 41, 1, 42, 1, 42, 1, 42, 1, 42, 1, 43, 1, 43, 1, 43, 1, 43, 1, 44, 1, 44, 1, 44, 1, 44, 1, 45, 1, 45, 1, 45, 1, 45, 1, 46, 1, 46, 1, 46, 1, 46, 1, 47, 1, 47, 1, 47, 1, 47, 1, 48, 1, 48, 1, 48, 1, 48, 1, 49, 1, 49, 1, 49, 1, 49, 1, 49, 1, 50, 1, 50, 1, 50, 1, 50, 1, 50, 1, 50, 1, 51, 1, 51, 1, 51, 1, 51, 1, 51, 1, 52, 1, 52, 1, 52, 1, 52, 1, 52, 1, 53, 1, 53, 1, 54, 4, 54, 1014, 8, 54, 11, 54, 12, 54, 1015, 1, 54, 1, 54, 3, 54, 1020, 8, 54, 1, 54, 4, 54, 1023, 8, 54, 11, 54, 12, 54, 1024, 1, 55, 1, 55, 1, 55, 1, 55, 1, 56, 1, 56, 1, 56, 1, 56, 1, 57, 1, 57, 1, 57, 1, 57, 1, 58, 1, 58, 1, 58, 1, 58, 1, 59, 1, 59, 1, 59, 1, 59, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 61, 1, 61, 1, 61, 1, 61, 1, 61, 1, 61, 1, 61, 1, 62, 1, 62, 1, 62, 1, 62, 1, 63, 1, 63, 1, 63, 1, 63, 1, 64, 1, 64, 1, 64, 1, 64, 1, 65, 1, 65, 1, 65, 1, 65, 1, 66, 1, 66, 1, 66, 1, 66, 1, 67, 1, 67, 1, 67, 1, 67, 1, 68, 1, 68, 1, 68, 1, 68, 1, 69, 1, 69, 1, 69, 1, 69, 1, 70, 1, 70, 1, 70, 1, 70, 1, 71, 1, 71, 1, 71, 1, 71, 1, 72, 1, 72, 1, 72, 1, 72, 1, 73, 1, 73, 1, 73, 1, 73, 1, 74, 1, 74, 1, 74, 1, 74, 1, 75, 1, 75, 1, 75, 1, 75, 1, 76, 1, 76, 1, 76, 1, 76, 1, 77, 1, 77, 1, 77, 1, 77, 1, 77, 1, 78, 1, 78, 1, 78, 1, 78, 1, 78, 1, 79, 1, 79, 1, 79, 1, 79, 1, 80, 1, 80, 1, 80, 1, 80, 1, 81, 1, 81, 1, 81, 1, 81, 1, 82, 1, 82, 1, 82, 1, 82, 1, 83, 1, 83, 1, 84, 1, 84, 1, 85, 1, 85, 1, 85, 1, 86, 1, 86, 1, 87, 1, 87, 3, 87, 1157, 8, 87, 1, 87, 4, 87, 1160, 8, 87, 11, 87, 12, 87, 1161, 1, 88, 1, 88, 1, 89, 1, 89, 1, 90, 1, 90, 1, 90, 3, 90, 1171, 8, 90, 1, 91, 1, 91, 1, 92, 1, 92, 1, 92, 3, 92, 1178, 8, 92, 1, 93, 1, 93, 1, 93, 5, 93, 1183, 8, 93, 10, 93, 12, 93, 1186, 9, 93, 1, 93, 1, 93, 1, 93, 1, 93, 1, 93, 1, 93, 5, 93, 1194, 8, 93, 10, 93, 12, 93, 1197, 9, 93, 1, 93, 1, 93, 1, 93, 1, 93, 1, 93, 3, 93, 1204, 8, 93, 1, 93, 3, 93, 1207, 8, 93, 3, 93, 1209, 8, 93, 1, 94, 4, 94, 1212, 8, 94, 11, 94, 12, 94, 1213, 1, 95, 4, 95, 1217, 8, 95, 11, 95, 12, 95, 1218, 1, 95, 1, 95, 5, 95, 1223, 8, 95, 10, 95, 12, 95, 1226, 9, 95, 1, 95, 1, 95, 4, 95, 1230, 8, 95, 11, 95, 12, 95, 1231, 1, 95, 4, 95, 1235, 8, 95, 11, 95, 12, 95, 1236, 1, 95, 1, 95, 5, 95, 1241, 8, 95, 10, 95, 12, 95, 1244, 9, 95, 3, 95, 1246, 8, 95, 1, 95, 1, 95, 1, 95, 1, 95, 4, 95, 1252, 8, 95, 11, 95, 12, 95, 1253, 1, 95, 1, 95, 3, 95, 1258, 8, 95, 1, 96, 1, 96, 1, 96, 1, 96, 1, 97, 1, 97, 1, 97, 1, 97, 1, 98, 1, 98, 1, 99, 1, 99, 1, 99, 1, 100, 1, 100, 1, 100, 1, 101, 1, 101, 1, 102, 1, 102, 1, 103, 1, 103, 1, 104, 1, 104, 1, 104, 1, 104, 1, 104, 1, 105, 1, 105, 1, 106, 1, 106, 1, 106, 1, 106, 1, 106, 1, 106, 1, 107, 1, 107, 1, 107, 1, 107, 1, 107, 1, 107, 1, 108, 1, 108, 1, 108, 1, 109, 1, 109, 1, 109, 1, 110, 1, 110, 1, 110, 1, 110, 1, 110, 1, 111, 1, 111, 1, 111, 1, 111, 1, 111, 1, 112, 1, 112, 1, 112, 1, 112, 1, 113, 1, 113, 1, 113, 1, 113, 1, 113, 1, 114, 1, 114, 1, 114, 1, 114, 1, 114, 1, 114, 1, 115, 1, 115, 1, 115, 1, 116, 1, 116, 1, 116, 1, 117, 1, 117, 1, 118, 1, 118, 1, 118, 1, 118, 1, 118, 1, 118, 1, 119, 1, 119, 1, 119, 1, 119, 1, 119, 1, 120, 1, 120, 1, 120, 1, 120, 1, 120, 1, 121, 1, 121, 1, 121, 1, 122, 1, 122, 1, 122, 1, 123, 1, 123, 1, 123, 1, 124, 1, 124, 1, 125, 1, 125, 1, 125, 1, 126, 1, 126, 1, 127, 1, 127, 1, 127, 1, 128, 1, 128, 1, 129, 1, 129, 1, 130, 1, 130, 1, 131, 1, 131, 1, 132, 1, 132, 1, 133, 1, 133, 1, 134, 1, 134, 1, 135, 1, 135, 1, 135, 1, 136, 1, 136, 1, 136, 1, 136, 1, 137, 1, 137, 1, 137, 3, 137, 1399, 8, 137, 1, 137, 5, 137, 1402, 8, 137, 10, 137, 12, 137, 1405, 9, 137, 1, 137, 1, 137, 4, 137, 1409, 8, 137, 11, 137, 12, 137, 1410, 3, 137, 1413, 8, 137, 1, 138, 1, 138, 1, 138, 3, 138, 1418, 8, 138, 1, 138, 5, 138, 1421, 8, 138, 10, 138, 12, 138, 1424, 9, 138, 1, 138, 1, 138, 4, 138, 1428, 8, 138, 11, 138, 12, 138, 1429, 3, 138, 1432, 8, 138, 1, 139, 1, 139, 1, 139, 1, 139, 1, 139, 1, 140, 1, 140, 1, 140, 1, 140, 1, 140, 1, 141, 1, 141, 1, 141, 1, 141, 1, 141, 1, 142, 1, 142, 1, 142, 1, 142, 1, 142, 1, 143, 1, 143, 5, 143, 1456, 8, 143, 10, 143, 12, 143, 1459, 9, 143, 1, 143, 1, 143, 3, 143, 1463, 8, 143, 1, 143, 4, 143, 1466, 8, 143, 11, 143, 12, 143, 1467, 3, 143, 1470, 8, 143, 1, 144, 1, 144, 4, 144, 1474, 8, 144, 11, 144, 12, 144, 1475, 1, 144, 1, 144, 1, 145, 1, 145, 1, 146, 1, 146, 1, 146, 1, 146, 1, 147, 1, 147, 1, 147, 1, 147, 1, 148, 1, 148, 1, 148, 1, 148, 1, 149, 1, 149, 1, 149, 1, 149, 1, 149, 1, 150, 1, 150, 1, 150, 1, 150, 1, 151, 1, 151, 1, 151, 1, 151, 1, 152, 1, 152, 1, 152, 1, 152, 1, 153, 1, 153, 1, 153, 1, 153, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 155, 1, 155, 1, 155, 1, 155, 1, 155, 1, 156, 1, 156, 1, 156, 3, 156, 1532, 8, 156, 1, 157, 4, 157, 1535, 8, 157, 11, 157, 12, 157, 1536, 1, 158, 1, 158, 1, 158, 1, 158, 1, 159, 1, 159, 1, 159, 1, 159, 1, 160, 1, 160, 1, 160, 1, 160, 1, 161, 1, 161, 1, 161, 1, 161, 1, 162, 1, 162, 1, 162, 1, 162, 1, 163, 1, 163, 1, 163, 1, 163, 1, 163, 1, 164, 1, 164, 1, 164, 1, 164, 1, 164, 1, 164, 1, 165, 1, 165, 1, 165, 1, 165, 1, 165, 1, 166, 1, 166, 1, 166, 1, 166, 1, 167, 1, 167, 1, 167, 1, 167, 1, 168, 1, 168, 1, 168, 1, 168, 1, 169, 1, 169, 1, 169, 1, 169, 1, 169, 1, 170, 1, 170, 1, 170, 1, 170, 1, 170, 1, 170, 1, 171, 1, 171, 1, 171, 1, 171, 1, 171, 1, 171, 1, 172, 1, 172, 1, 172, 1, 172, 1, 172, 1, 172, 1, 173, 1, 173, 1, 173, 1, 173, 1, 174, 1, 174, 1, 174, 1, 174, 1, 174, 1, 174, 1, 175, 1, 175, 1, 175, 1, 175, 1, 176, 1, 176, 1, 176, 1, 176, 1, 177, 1, 177, 1, 177, 1, 177, 1, 178, 1, 178, 1, 178, 1, 178, 1, 179, 1, 179, 1, 179, 1, 179, 1, 180, 1, 180, 1, 180, 1, 180, 1, 181, 1, 181, 1, 181, 1, 181, 1, 182, 1, 182, 1, 182, 1, 182, 1, 183, 1, 183, 1, 183, 1, 183, 1, 184, 1, 184, 1, 184, 1, 184, 1, 185, 1, 185, 1, 185, 1, 185, 1, 186, 1, 186, 1, 186, 1, 186, 1, 187, 1, 187, 1, 187, 1, 187, 1, 187, 1, 187, 1, 187, 1, 187, 1, 187, 1, 188, 1, 188, 1, 188, 1, 188, 1, 189, 1, 189, 1, 189, 1, 189, 1, 190, 1, 190, 1, 190, 1, 190, 1, 191, 1, 191, 1, 191, 1, 191, 1, 191, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 193, 1, 193, 1, 193, 1, 193, 1, 194, 1, 194, 1, 194, 1, 194, 1, 194, 1, 194, 1, 195, 1, 195, 1, 195, 1, 195, 1, 195, 1, 195, 1, 195, 1, 195, 1, 195, 1, 196, 1, 196, 1, 196, 1, 196, 1, 197, 1, 197, 1, 197, 1, 197, 1, 198, 1, 198, 1, 198, 1, 198, 1, 199, 1, 199, 1, 199, 1, 199, 1, 200, 1, 200, 1, 200, 1, 200, 1, 201, 1, 201, 1, 201, 1, 201, 1, 202, 1, 202, 1, 202, 1, 202, 1, 202, 1, 203, 1, 203, 1, 203, 1, 203, 1, 203, 1, 203, 1, 204, 1, 204, 1, 204, 1, 204, 1, 205, 1, 205, 1, 205, 1, 205, 1, 206, 1, 206, 1, 206, 1, 206, 1, 207, 1, 207, 1, 207, 1, 207, 1, 207, 1, 208, 1, 208, 1, 208, 1, 208, 1, 209, 1, 209, 1, 209, 1, 209, 1, 210, 1, 210, 1, 210, 1, 210, 1, 211, 1, 211, 1, 211, 1, 211, 1, 212, 1, 212, 1, 212, 1, 212, 1, 213, 1, 213, 1, 213, 1, 213, 1, 213, 1, 213, 1, 214, 1, 214, 1, 214, 1, 214, 1, 214, 1, 214, 1, 214, 1, 215, 1, 215, 1, 215, 1, 215, 1, 216, 1, 216, 1, 216, 1, 216, 1, 217, 1, 217, 1, 217, 1, 217, 1, 218, 1, 218, 1, 218, 1, 218, 1, 219, 1, 219, 1, 219, 1, 219, 1, 220, 1, 220, 1, 220, 1, 220, 1, 221, 1, 221, 1, 221, 1, 221, 1, 221, 1, 222, 1, 222, 1, 222, 1, 222, 1, 222, 1, 222, 1, 223, 1, 223, 1, 223, 1, 223, 1, 224, 1, 224, 1, 224, 1, 224, 1, 225, 1, 225, 1, 225, 1, 225, 1, 226, 1, 226, 1, 226, 1, 226, 1, 227, 1, 227, 1, 227, 1, 227, 1, 228, 1, 228, 1, 228, 1, 228, 1, 229, 1, 229, 1, 229, 1, 229, 1, 230, 1, 230, 1, 230, 1, 230, 1, 231, 1, 231, 1, 231, 1, 231, 1, 232, 1, 232, 1, 232, 1, 232, 1, 233, 1, 233, 1, 233, 1, 233, 1, 234, 1, 234, 1, 234, 1, 234, 1, 235, 1, 235, 1, 235, 1, 235, 1, 235, 1, 236, 1, 236, 1, 236, 1, 236, 1, 236, 1, 236, 1, 237, 1, 237, 1, 237, 1, 237, 1, 238, 1, 238, 1, 238, 1, 238, 1, 239, 1, 239, 1, 239, 1, 239, 1, 240, 1, 240, 1, 240, 1, 240, 1, 241, 1, 241, 1, 241, 1, 241, 1, 242, 1, 242, 1, 242, 1, 242, 1, 243, 1, 243, 1, 243, 1, 243, 1, 244, 1, 244, 1, 244, 1, 244, 1, 245, 1, 245, 1, 245, 1, 245, 3, 245, 1933, 8, 245, 1, 246, 1, 246, 3, 246, 1937, 8, 246, 1, 246, 5, 246, 1940, 8, 246, 10, 246, 12, 246, 1943, 9, 246, 1, 246, 1, 246, 3, 246, 1947, 8, 246, 1, 246, 4, 246, 1950, 8, 246, 11, 246, 12, 246, 1951, 3, 246, 1954, 8, 246, 1, 247, 1, 247, 4, 247, 1958, 8, 247, 11, 247, 12, 247, 1959, 1, 248, 1, 248, 1, 248, 1, 248, 1, 249, 1, 249, 1, 249, 1, 249, 1, 250, 1, 250, 1, 250, 1, 250, 1, 251, 1, 251, 1, 251, 1, 251, 1, 251, 1, 252, 1, 252, 1, 252, 1, 252, 1, 252, 1, 252, 1, 253, 1, 253, 1, 253, 1, 253, 1, 254, 1, 254, 1, 254, 1, 254, 1, 255, 1, 255, 1, 255, 1, 255, 1, 256, 1, 256, 1, 256, 1, 256, 1, 257, 1, 257, 1, 257, 1, 257, 1, 258, 1, 258, 1, 258, 1, 258, 1, 259, 1, 259, 1, 259, 1, 259, 1, 260, 1, 260, 1, 260, 1, 260, 1, 261, 1, 261, 1, 261, 1, 261, 1, 262, 1, 262, 1, 262, 1, 263, 1, 263, 1, 263, 1, 263, 1, 264, 1, 264, 1, 264, 1, 264, 1, 265, 1, 265, 1, 265, 1, 265, 1, 266, 1, 266, 1, 266, 1, 266, 1, 267, 1, 267, 1, 267, 1, 267, 1, 268, 1, 268, 1, 268, 1, 268, 1, 269, 1, 269, 1, 269, 1, 269, 1, 270, 1, 270, 1, 270, 1, 270, 1, 270, 1, 271, 1, 271, 1, 271, 1, 271, 1, 272, 1, 272, 1, 272, 1, 272, 1, 273, 1, 273, 1, 273, 1, 273, 1, 274, 1, 274, 1, 274, 1, 274, 1, 275, 1, 275, 1, 275, 1, 275, 1, 276, 1, 276, 1, 276, 1, 276, 1, 277, 1, 277, 1, 277, 1, 277, 1, 278, 1, 278, 1, 278, 1, 278, 1, 279, 1, 279, 1, 279, 1, 279, 1, 280, 1, 280, 1, 280, 1, 280, 1, 281, 1, 281, 1, 281, 1, 281, 1, 282, 1, 282, 1, 282, 1, 282, 1, 283, 1, 283, 1, 283, 1, 283, 1, 284, 1, 284, 1, 284, 1, 284, 1, 285, 1, 285, 1, 285, 1, 285, 1, 286, 1, 286, 1, 286, 1, 286, 1, 287, 1, 287, 1, 287, 1, 287, 1, 288, 1, 288, 1, 288, 1, 288, 1, 289, 1, 289, 1, 289, 1, 289, 1, 289, 1, 290, 1, 290, 1, 290, 1, 290, 1, 290, 1, 291, 1, 291, 1, 291, 1, 291, 1, 292, 1, 292, 1, 292, 1, 292, 1, 293, 1, 293, 1, 293, 1, 293, 2, 630, 1195, 0, 294, 18, 1, 20, 2, 22, 3, 24, 4, 26, 5, 28, 6, 30, 7, 32, 8, 34, 9, 36, 10, 38, 11, 40, 12, 42, 13, 44, 14, 46, 15, 48, 16, 50, 17, 52, 18, 54, 19, 56, 20, 58, 21, 60, 22, 62, 23, 64, 24, 66, 25, 68, 26, 70, 27, 72, 28, 74, 29, 76, 30, 78, 31, 80, 32, 82, 33, 84, 34, 86, 35, 88, 36, 90, 0, 92, 0, 94, 0, 96, 0, 98, 0, 100, 0, 102, 0, 104, 0, 106, 0, 108, 0, 110, 37, 112, 38, 114, 39, 116, 0, 118, 0, 120, 0, 122, 0, 124, 0, 126, 40, 128, 0, 130, 0, 132, 41, 134, 42, 136, 43, 138, 0, 140, 0, 142, 0, 144, 0, 146, 0, 148, 0, 150, 0, 152, 0, 154, 0, 156, 0, 158, 0, 160, 0, 162, 0, 164, 0, 166, 44, 168, 45, 170, 46, 172, 0, 174, 0, 176, 47, 178, 48, 180, 49, 182, 50, 184, 0, 186, 0, 188, 0, 190, 0, 192, 0, 194, 0, 196, 0, 198, 0, 200, 0, 202, 0, 204, 51, 206, 52, 208, 53, 210, 54, 212, 55, 214, 56, 216, 57, 218, 58, 220, 59, 222, 60, 224, 61, 226, 62, 228, 63, 230, 64, 232, 65, 234, 66, 236, 67, 238, 68, 240, 69, 242, 70, 244, 71, 246, 72, 248, 73, 250, 74, 252, 75, 254, 76, 256, 77, 258, 78, 260, 79, 262, 80, 264, 81, 266, 82, 268, 83, 270, 84, 272, 85, 274, 86, 276, 87, 278, 88, 280, 89, 282, 90, 284, 91, 286, 92, 288, 93, 290, 0, 292, 94, 294, 95, 296, 96, 298, 97, 300, 98, 302, 99, 304, 100, 306, 0, 308, 101, 310, 102, 312, 103, 314, 104, 316, 0, 318, 0, 320, 0, 322, 0, 324, 0, 326, 105, 328, 0, 330, 0, 332, 106, 334, 0, 336, 0, 338, 107, 340, 108, 342, 109, 344, 0, 346, 0, 348, 0, 350, 110, 352, 111, 354, 112, 356, 0, 358, 0, 360, 113, 362, 114, 364, 115, 366, 0, 368, 0, 370, 0, 372, 0, 374, 0, 376, 0, 378, 0, 380, 0, 382, 0, 384, 0, 386, 116, 388, 117, 390, 118, 392, 119, 394, 120, 396, 121, 398, 122, 400, 0, 402, 123, 404, 0, 406, 0, 408, 124, 410, 0, 412, 0, 414, 0, 416, 125, 418, 126, 420, 127, 422, 0, 424, 0, 426, 0, 428, 0, 430, 0, 432, 0, 434, 0, 436, 0, 438, 128, 440, 129, 442, 130, 444, 0, 446, 0, 448, 0, 450, 0, 452, 0, 454, 131, 456, 132, 458, 133, 460, 0, 462, 0, 464, 0, 466, 0, 468, 0, 470, 0, 472, 0, 474, 0, 476, 0, 478, 0, 480, 0, 482, 134, 484, 135, 486, 136, 488, 0, 490, 0, 492, 0, 494, 0, 496, 0, 498, 0, 500, 0, 502, 0, 504, 0, 506, 0, 508, 0, 510, 0, 512, 137, 514, 138, 516, 139, 518, 140, 520, 0, 522, 0, 524, 0, 526, 0, 528, 0, 530, 0, 532, 0, 534, 0, 536, 0, 538, 0, 540, 0, 542, 141, 544, 0, 546, 142, 548, 143, 550, 144, 552, 0, 554, 0, 556, 0, 558, 0, 560, 0, 562, 0, 564, 0, 566, 0, 568, 0, 570, 0, 572, 0, 574, 0, 576, 0, 578, 0, 580, 0, 582, 0, 584, 0, 586, 0, 588, 0, 590, 145, 592, 146, 594, 147, 596, 0, 598, 148, 600, 149, 602, 150, 604, 151, 18, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 2, 0, 10, 10, 13, 13, 3, 0, 9, 10, 13, 13, 32, 32, 2, 0, 67, 67, 99, 99, 2, 0, 72, 72, 104, 104, 2, 0, 65, 65, 97, 97, 2, 0, 78, 78, 110, 110, 2, 0, 71, 71, 103, 103, 2, 0, 69, 69, 101, 101, 2, 0, 80, 80, 112, 112, 2, 0, 79, 79, 111, 111, 2, 0, 73, 73, 105, 105, 2, 0, 84, 84, 116, 116, 2, 0, 82, 82, 114, 114, 2, 0, 88, 88, 120, 120, 2, 0, 76, 76, 108, 108, 2, 0, 77, 77, 109, 109, 2, 0, 68, 68, 100, 100, 2, 0, 83, 83, 115, 115, 2, 0, 86, 86, 118, 118, 2, 0, 75, 75, 107, 107, 2, 0, 87, 87, 119, 119, 2, 0, 70, 70, 102, 102, 2, 0, 85, 85, 117, 117, 6, 0, 9, 10, 13, 13, 32, 32, 47, 47, 91, 91, 93, 93, 12, 0, 9, 10, 13, 13, 32, 32, 34, 35, 40, 41, 44, 44, 47, 47, 58, 58, 60, 60, 62, 63, 92, 92, 124, 124, 1, 0, 48, 57, 2, 0, 65, 90, 97, 122, 8, 0, 34, 34, 78, 78, 82, 82, 84, 84, 92, 92, 110, 110, 114, 114, 116, 116, 4, 0, 10, 10, 13, 13, 34, 34, 92, 92, 2, 0, 43, 43, 45, 45, 1, 0, 96, 96, 2, 0, 66, 66, 98, 98, 2, 0, 89, 89, 121, 121, 12, 0, 9, 10, 13, 13, 32, 32, 34, 34, 40, 41, 44, 44, 47, 47, 58, 58, 61, 61, 91, 91, 93, 93, 124, 124, 2, 0, 42, 42, 47, 47, 2, 0, 74, 74, 106, 106, 2174, 0, 18, 1, 0, 0, 0, 0, 20, 1, 0, 0, 0, 0, 22, 1, 0, 0, 0, 0, 24, 1, 0, 0, 0, 0, 26, 1, 0, 0, 0, 0, 28, 1, 0, 0, 0, 0, 30, 1, 0, 0, 0, 0, 32, 1, 0, 0, 0, 0, 34, 1, 0, 0, 0, 0, 36, 1, 0, 0, 0, 0, 38, 1, 0, 0, 0, 0, 40, 1, 0, 0, 0, 0, 42, 1, 0, 0, 0, 0, 44, 1, 0, 0, 0, 0, 46, 1, 0, 0, 0, 0, 48, 1, 0, 0, 0, 0, 50, 1, 0, 0, 0, 0, 52, 1, 0, 0, 0, 0, 54, 1, 0, 0, 0, 0, 56, 1, 0, 0, 0, 0, 58, 1, 0, 0, 0, 0, 60, 1, 0, 0, 0, 0, 62, 1, 0, 0, 0, 0, 64, 1, 0, 0, 0, 0, 66, 1, 0, 0, 0, 0, 68, 1, 0, 0, 0, 0, 70, 1, 0, 0, 0, 0, 72, 1, 0, 0, 0, 0, 74, 1, 0, 0, 0, 0, 76, 1, 0, 0, 0, 0, 78, 1, 0, 0, 0, 0, 80, 1, 0, 0, 0, 0, 82, 1, 0, 0, 0, 0, 84, 1, 0, 0, 0, 0, 86, 1, 0, 0, 0, 0, 88, 1, 0, 0, 0, 1, 90, 1, 0, 0, 0, 1, 92, 1, 0, 0, 0, 1, 94, 1, 0, 0, 0, 1, 96, 1, 0, 0, 0, 1, 98, 1, 0, 0, 0, 1, 100, 1, 0, 0, 0, 1, 102, 1, 0, 0, 0, 1, 104, 1, 0, 0, 0, 1, 106, 1, 0, 0, 0, 1, 108, 1, 0, 0, 0, 1, 110, 1, 0, 0, 0, 1, 112, 1, 0, 0, 0, 1, 114, 1, 0, 0, 0, 2, 116, 1, 0, 0, 0, 2, 118, 1, 0, 0, 0, 2, 120, 1, 0, 0, 0, 2, 122, 1, 0, 0, 0, 2, 126, 1, 0, 0, 0, 2, 128, 1, 0, 0, 0, 2, 130, 1, 0, 0, 0, 2, 132, 1, 0, 0, 0, 2, 134, 1, 0, 0, 0, 2, 136, 1, 0, 0, 0, 3, 138, 1, 0, 0, 0, 3, 140, 1, 0, 0, 0, 3, 142, 1, 0, 0, 0, 3, 144, 1, 0, 0, 0, 3, 146, 1, 0, 0, 0, 3, 148, 1, 0, 0, 0, 3, 150, 1, 0, 0, 0, 3, 152, 1, 0, 0, 0, 3, 154, 1, 0, 0, 0, 3, 156, 1, 0, 0, 0, 3, 158, 1, 0, 0, 0, 3, 160, 1, 0, 0, 0, 3, 162, 1, 0, 0, 0, 3, 164, 1, 0, 0, 0, 3, 166, 1, 0, 0, 0, 3, 168, 1, 0, 0, 0, 3, 170, 1, 0, 0, 0, 4, 172, 1, 0, 0, 0, 4, 174, 1, 0, 0, 0, 4, 176, 1, 0, 0, 0, 4, 178, 1, 0, 0, 0, 4, 180, 1, 0, 0, 0, 5, 182, 1, 0, 0, 0, 5, 204, 1, 0, 0, 0, 5, 206, 1, 0, 0, 0, 5, 208, 1, 0, 0, 0, 5, 210, 1, 0, 0, 0, 5, 212, 1, 0, 0, 0, 5, 214, 1, 0, 0, 0, 5, 216, 1, 0, 0, 0, 5, 218, 1, 0, 0, 0, 5, 220, 1, 0, 0, 0, 5, 222, 1, 0, 0, 0, 5, 224, 1, 0, 0, 0, 5, 226, 1, 0, 0, 0, 5, 228, 1, 0, 0, 0, 5, 230, 1, 0, 0, 0, 5, 232, 1, 0, 0, 0, 5, 234, 1, 0, 0, 0, 5, 236, 1, 0, 0, 0, 5, 238, 1, 0, 0, 0, 5, 240, 1, 0, 0, 0, 5, 242, 1, 0, 0, 0, 5, 244, 1, 0, 0, 0, 5, 246, 1, 0, 0, 0, 5, 248, 1, 0, 0, 0, 5, 250, 1, 0, 0, 0, 5, 252, 1, 0, 0, 0, 5, 254, 1, 0, 0, 0, 5, 256, 1, 0, 0, 0, 5, 258, 1, 0, 0, 0, 5, 260, 1, 0, 0, 0, 5, 262, 1, 0, 0, 0, 5, 264, 1, 0, 0, 0, 5, 266, 1, 0, 0, 0, 5, 268, 1, 0, 0, 0, 5, 270, 1, 0, 0, 0, 5, 272, 1, 0, 0, 0, 5, 274, 1, 0, 0, 0, 5, 276, 1, 0, 0, 0, 5, 278, 1, 0, 0, 0, 5, 280, 1, 0, 0, 0, 5, 282, 1, 0, 0, 0, 5, 284, 1, 0, 0, 0, 5, 286, 1, 0, 0, 0, 5, 288, 1, 0, 0, 0, 5, 290, 1, 0, 0, 0, 5, 292, 1, 0, 0, 0, 5, 294, 1, 0, 0, 0, 5, 296, 1, 0, 0, 0, 5, 298, 1, 0, 0, 0, 5, 300, 1, 0, 0, 0, 5, 302, 1, 0, 0, 0, 5, 304, 1, 0, 0, 0, 5, 308, 1, 0, 0, 0, 5, 310, 1, 0, 0, 0, 5, 312, 1, 0, 0, 0, 5, 314, 1, 0, 0, 0, 6, 316, 1, 0, 0, 0, 6, 318, 1, 0, 0, 0, 6, 320, 1, 0, 0, 0, 6, 322, 1, 0, 0, 0, 6, 324, 1, 0, 0, 0, 6, 326, 1, 0, 0, 0, 6, 328, 1, 0, 0, 0, 6, 332, 1, 0, 0, 0, 6, 334, 1, 0, 0, 0, 6, 336, 1, 0, 0, 0, 6, 338, 1, 0, 0, 0, 6, 340, 1, 0, 0, 0, 6, 342, 1, 0, 0, 0, 7, 344, 1, 0, 0, 0, 7, 346, 1, 0, 0, 0, 7, 348, 1, 0, 0, 0, 7, 350, 1, 0, 0, 0, 7, 352, 1, 0, 0, 0, 7, 354, 1, 0, 0, 0, 8, 356, 1, 0, 0, 0, 8, 358, 1, 0, 0, 0, 8, 360, 1, 0, 0, 0, 8, 362, 1, 0, 0, 0, 8, 364, 1, 0, 0, 0, 8, 366, 1, 0, 0, 0, 8, 368, 1, 0, 0, 0, 8, 370, 1, 0, 0, 0, 8, 372, 1, 0, 0, 0, 8, 374, 1, 0, 0, 0, 8, 376, 1, 0, 0, 0, 8, 378, 1, 0, 0, 0, 8, 380, 1, 0, 0, 0, 8, 382, 1, 0, 0, 0, 8, 384, 1, 0, 0, 0, 8, 386, 1, 0, 0, 0, 8, 388, 1, 0, 0, 0, 8, 390, 1, 0, 0, 0, 9, 392, 1, 0, 0, 0, 9, 394, 1, 0, 0, 0, 9, 396, 1, 0, 0, 0, 9, 398, 1, 0, 0, 0, 10, 400, 1, 0, 0, 0, 10, 402, 1, 0, 0, 0, 10, 404, 1, 0, 0, 0, 10, 406, 1, 0, 0, 0, 10, 408, 1, 0, 0, 0, 10, 410, 1, 0, 0, 0, 10, 412, 1, 0, 0, 0, 10, 414, 1, 0, 0, 0, 10, 416, 1, 0, 0, 0, 10, 418, 1, 0, 0, 0, 10, 420, 1, 0, 0, 0, 11, 422, 1, 0, 0, 0, 11, 424, 1, 0, 0, 0, 11, 426, 1, 0, 0, 0, 11, 428, 1, 0, 0, 0, 11, 430, 1, 0, 0, 0, 11, 432, 1, 0, 0, 0, 11, 434, 1, 0, 0, 0, 11, 436, 1, 0, 0, 0, 11, 438, 1, 0, 0, 0, 11, 440, 1, 0, 0, 0, 11, 442, 1, 0, 0, 0, 12, 444, 1, 0, 0, 0, 12, 446, 1, 0, 0, 0, 12, 448, 1, 0, 0, 0, 12, 450, 1, 0, 0, 0, 12, 452, 1, 0, 0, 0, 12, 454, 1, 0, 0, 0, 12, 456, 1, 0, 0, 0, 12, 458, 1, 0, 0, 0, 13, 460, 1, 0, 0, 0, 13, 462, 1, 0, 0, 0, 13, 464, 1, 0, 0, 0, 13, 466, 1, 0, 0, 0, 13, 468, 1, 0, 0, 0, 13, 470, 1, 0, 0, 0, 13, 472, 1, 0, 0, 0, 13, 474, 1, 0, 0, 0, 13, 476, 1, 0, 0, 0, 13, 478, 1, 0, 0, 0, 13, 480, 1, 0, 0, 0, 13, 482, 1, 0, 0, 0, 13, 484, 1, 0, 0, 0, 13, 486, 1, 0, 0, 0, 14, 488, 1, 0, 0, 0, 14, 490, 1, 0, 0, 0, 14, 492, 1, 0, 0, 0, 14, 494, 1, 0, 0, 0, 14, 496, 1, 0, 0, 0, 14, 498, 1, 0, 0, 0, 14, 500, 1, 0, 0, 0, 14, 502, 1, 0, 0, 0, 14, 504, 1, 0, 0, 0, 14, 506, 1, 0, 0, 0, 14, 512, 1, 0, 0, 0, 14, 514, 1, 0, 0, 0, 14, 516, 1, 0, 0, 0, 14, 518, 1, 0, 0, 0, 15, 520, 1, 0, 0, 0, 15, 522, 1, 0, 0, 0, 15, 524, 1, 0, 0, 0, 15, 526, 1, 0, 0, 0, 15, 528, 1, 0, 0, 0, 15, 530, 1, 0, 0, 0, 15, 532, 1, 0, 0, 0, 15, 534, 1, 0, 0, 0, 15, 536, 1, 0, 0, 0, 15, 538, 1, 0, 0, 0, 15, 540, 1, 0, 0, 0, 15, 542, 1, 0, 0, 0, 15, 544, 1, 0, 0, 0, 15, 546, 1, 0, 0, 0, 15, 548, 1, 0, 0, 0, 15, 550, 1, 0, 0, 0, 16, 552, 1, 0, 0, 0, 16, 554, 1, 0, 0, 0, 16, 556, 1, 0, 0, 0, 16, 558, 1, 0, 0, 0, 16, 560, 1, 0, 0, 0, 16, 562, 1, 0, 0, 0, 16, 564, 1, 0, 0, 0, 16, 566, 1, 0, 0, 0, 16, 568, 1, 0, 0, 0, 16, 570, 1, 0, 0, 0, 16, 572, 1, 0, 0, 0, 16, 574, 1, 0, 0, 0, 16, 576, 1, 0, 0, 0, 16, 578, 1, 0, 0, 0, 16, 580, 1, 0, 0, 0, 16, 582, 1, 0, 0, 0, 16, 584, 1, 0, 0, 0, 16, 586, 1, 0, 0, 0, 16, 588, 1, 0, 0, 0, 16, 590, 1, 0, 0, 0, 16, 592, 1, 0, 0, 0, 16, 594, 1, 0, 0, 0, 17, 596, 1, 0, 0, 0, 17, 598, 1, 0, 0, 0, 17, 600, 1, 0, 0, 0, 17, 602, 1, 0, 0, 0, 17, 604, 1, 0, 0, 0, 18, 606, 1, 0, 0, 0, 20, 623, 1, 0, 0, 0, 22, 639, 1, 0, 0, 0, 24, 645, 1, 0, 0, 0, 26, 660, 1, 0, 0, 0, 28, 669, 1, 0, 0, 0, 30, 680, 1, 0, 0, 0, 32, 693, 1, 0, 0, 0, 34, 703, 1, 0, 0, 0, 36, 710, 1, 0, 0, 0, 38, 717, 1, 0, 0, 0, 40, 725, 1, 0, 0, 0, 42, 734, 1, 0, 0, 0, 44, 740, 1, 0, 0, 0, 46, 749, 1, 0, 0, 0, 48, 756, 1, 0, 0, 0, 50, 764, 1, 0, 0, 0, 52, 772, 1, 0, 0, 0, 54, 779, 1, 0, 0, 0, 56, 784, 1, 0, 0, 0, 58, 791, 1, 0, 0, 0, 60, 798, 1, 0, 0, 0, 62, 807, 1, 0, 0, 0, 64, 821, 1, 0, 0, 0, 66, 830, 1, 0, 0, 0, 68, 838, 1, 0, 0, 0, 70, 846, 1, 0, 0, 0, 72, 855, 1, 0, 0, 0, 74, 867, 1, 0, 0, 0, 76, 879, 1, 0, 0, 0, 78, 886, 1, 0, 0, 0, 80, 893, 1, 0, 0, 0, 82, 905, 1, 0, 0, 0, 84, 914, 1, 0, 0, 0, 86, 920, 1, 0, 0, 0, 88, 928, 1, 0, 0, 0, 90, 934, 1, 0, 0, 0, 92, 939, 1, 0, 0, 0, 94, 945, 1, 0, 0, 0, 96, 949, 1, 0, 0, 0, 98, 953, 1, 0, 0, 0, 100, 957, 1, 0, 0, 0, 102, 961, 1, 0, 0, 0, 104, 965, 1, 0, 0, 0, 106, 969, 1, 0, 0, 0, 108, 973, 1, 0, 0, 0, 110, 977, 1, 0, 0, 0, 112, 981, 1, 0, 0, 0, 114, 985, 1, 0, 0, 0, 116, 989, 1, 0, 0, 0, 118, 994, 1, 0, 0, 0, 120, 1000, 1, 0, 0, 0, 122, 1005, 1, 0, 0, 0, 124, 1010, 1, 0, 0, 0, 126, 1019, 1, 0, 0, 0, 128, 1026, 1, 0, 0, 0, 130, 1030, 1, 0, 0, 0, 132, 1034, 1, 0, 0, 0, 134, 1038, 1, 0, 0, 0, 136, 1042, 1, 0, 0, 0, 138, 1046, 1, 0, 0, 0, 140, 1052, 1, 0, 0, 0, 142, 1059, 1, 0, 0, 0, 144, 1063, 1, 0, 0, 0, 146, 1067, 1, 0, 0, 0, 148, 1071, 1, 0, 0, 0, 150, 1075, 1, 0, 0, 0, 152, 1079, 1, 0, 0, 0, 154, 1083, 1, 0, 0, 0, 156, 1087, 1, 0, 0, 0, 158, 1091, 1, 0, 0, 0, 160, 1095, 1, 0, 0, 0, 162, 1099, 1, 0, 0, 0, 164, 1103, 1, 0, 0, 0, 166, 1107, 1, 0, 0, 0, 168, 1111, 1, 0, 0, 0, 170, 1115, 1, 0, 0, 0, 172, 1119, 1, 0, 0, 0, 174, 1124, 1, 0, 0, 0, 176, 1129, 1, 0, 0, 0, 178, 1133, 1, 0, 0, 0, 180, 1137, 1, 0, 0, 0, 182, 1141, 1, 0, 0, 0, 184, 1145, 1, 0, 0, 0, 186, 1147, 1, 0, 0, 0, 188, 1149, 1, 0, 0, 0, 190, 1152, 1, 0, 0, 0, 192, 1154, 1, 0, 0, 0, 194, 1163, 1, 0, 0, 0, 196, 1165, 1, 0, 0, 0, 198, 1170, 1, 0, 0, 0, 200, 1172, 1, 0, 0, 0, 202, 1177, 1, 0, 0, 0, 204, 1208, 1, 0, 0, 0, 206, 1211, 1, 0, 0, 0, 208, 1257, 1, 0, 0, 0, 210, 1259, 1, 0, 0, 0, 212, 1263, 1, 0, 0, 0, 214, 1267, 1, 0, 0, 0, 216, 1269, 1, 0, 0, 0, 218, 1272, 1, 0, 0, 0, 220, 1275, 1, 0, 0, 0, 222, 1277, 1, 0, 0, 0, 224, 1279, 1, 0, 0, 0, 226, 1281, 1, 0, 0, 0, 228, 1286, 1, 0, 0, 0, 230, 1288, 1, 0, 0, 0, 232, 1294, 1, 0, 0, 0, 234, 1300, 1, 0, 0, 0, 236, 1303, 1, 0, 0, 0, 238, 1306, 1, 0, 0, 0, 240, 1311, 1, 0, 0, 0, 242, 1316, 1, 0, 0, 0, 244, 1320, 1, 0, 0, 0, 246, 1325, 1, 0, 0, 0, 248, 1331, 1, 0, 0, 0, 250, 1334, 1, 0, 0, 0, 252, 1337, 1, 0, 0, 0, 254, 1339, 1, 0, 0, 0, 256, 1345, 1, 0, 0, 0, 258, 1350, 1, 0, 0, 0, 260, 1355, 1, 0, 0, 0, 262, 1358, 1, 0, 0, 0, 264, 1361, 1, 0, 0, 0, 266, 1364, 1, 0, 0, 0, 268, 1366, 1, 0, 0, 0, 270, 1369, 1, 0, 0, 0, 272, 1371, 1, 0, 0, 0, 274, 1374, 1, 0, 0, 0, 276, 1376, 1, 0, 0, 0, 278, 1378, 1, 0, 0, 0, 280, 1380, 1, 0, 0, 0, 282, 1382, 1, 0, 0, 0, 284, 1384, 1, 0, 0, 0, 286, 1386, 1, 0, 0, 0, 288, 1388, 1, 0, 0, 0, 290, 1391, 1, 0, 0, 0, 292, 1412, 1, 0, 0, 0, 294, 1431, 1, 0, 0, 0, 296, 1433, 1, 0, 0, 0, 298, 1438, 1, 0, 0, 0, 300, 1443, 1, 0, 0, 0, 302, 1448, 1, 0, 0, 0, 304, 1469, 1, 0, 0, 0, 306, 1471, 1, 0, 0, 0, 308, 1479, 1, 0, 0, 0, 310, 1481, 1, 0, 0, 0, 312, 1485, 1, 0, 0, 0, 314, 1489, 1, 0, 0, 0, 316, 1493, 1, 0, 0, 0, 318, 1498, 1, 0, 0, 0, 320, 1502, 1, 0, 0, 0, 322, 1506, 1, 0, 0, 0, 324, 1510, 1, 0, 0, 0, 326, 1514, 1, 0, 0, 0, 328, 1523, 1, 0, 0, 0, 330, 1531, 1, 0, 0, 0, 332, 1534, 1, 0, 0, 0, 334, 1538, 1, 0, 0, 0, 336, 1542, 1, 0, 0, 0, 338, 1546, 1, 0, 0, 0, 340, 1550, 1, 0, 0, 0, 342, 1554, 1, 0, 0, 0, 344, 1558, 1, 0, 0, 0, 346, 1563, 1, 0, 0, 0, 348, 1569, 1, 0, 0, 0, 350, 1574, 1, 0, 0, 0, 352, 1578, 1, 0, 0, 0, 354, 1582, 1, 0, 0, 0, 356, 1586, 1, 0, 0, 0, 358, 1591, 1, 0, 0, 0, 360, 1597, 1, 0, 0, 0, 362, 1603, 1, 0, 0, 0, 364, 1609, 1, 0, 0, 0, 366, 1613, 1, 0, 0, 0, 368, 1619, 1, 0, 0, 0, 370, 1623, 1, 0, 0, 0, 372, 1627, 1, 0, 0, 0, 374, 1631, 1, 0, 0, 0, 376, 1635, 1, 0, 0, 0, 378, 1639, 1, 0, 0, 0, 380, 1643, 1, 0, 0, 0, 382, 1647, 1, 0, 0, 0, 384, 1651, 1, 0, 0, 0, 386, 1655, 1, 0, 0, 0, 388, 1659, 1, 0, 0, 0, 390, 1663, 1, 0, 0, 0, 392, 1667, 1, 0, 0, 0, 394, 1676, 1, 0, 0, 0, 396, 1680, 1, 0, 0, 0, 398, 1684, 1, 0, 0, 0, 400, 1688, 1, 0, 0, 0, 402, 1693, 1, 0, 0, 0, 404, 1698, 1, 0, 0, 0, 406, 1702, 1, 0, 0, 0, 408, 1708, 1, 0, 0, 0, 410, 1717, 1, 0, 0, 0, 412, 1721, 1, 0, 0, 0, 414, 1725, 1, 0, 0, 0, 416, 1729, 1, 0, 0, 0, 418, 1733, 1, 0, 0, 0, 420, 1737, 1, 0, 0, 0, 422, 1741, 1, 0, 0, 0, 424, 1746, 1, 0, 0, 0, 426, 1752, 1, 0, 0, 0, 428, 1756, 1, 0, 0, 0, 430, 1760, 1, 0, 0, 0, 432, 1764, 1, 0, 0, 0, 434, 1769, 1, 0, 0, 0, 436, 1773, 1, 0, 0, 0, 438, 1777, 1, 0, 0, 0, 440, 1781, 1, 0, 0, 0, 442, 1785, 1, 0, 0, 0, 444, 1789, 1, 0, 0, 0, 446, 1795, 1, 0, 0, 0, 448, 1802, 1, 0, 0, 0, 450, 1806, 1, 0, 0, 0, 452, 1810, 1, 0, 0, 0, 454, 1814, 1, 0, 0, 0, 456, 1818, 1, 0, 0, 0, 458, 1822, 1, 0, 0, 0, 460, 1826, 1, 0, 0, 0, 462, 1831, 1, 0, 0, 0, 464, 1837, 1, 0, 0, 0, 466, 1841, 1, 0, 0, 0, 468, 1845, 1, 0, 0, 0, 470, 1849, 1, 0, 0, 0, 472, 1853, 1, 0, 0, 0, 474, 1857, 1, 0, 0, 0, 476, 1861, 1, 0, 0, 0, 478, 1865, 1, 0, 0, 0, 480, 1869, 1, 0, 0, 0, 482, 1873, 1, 0, 0, 0, 484, 1877, 1, 0, 0, 0, 486, 1881, 1, 0, 0, 0, 488, 1885, 1, 0, 0, 0, 490, 1890, 1, 0, 0, 0, 492, 1896, 1, 0, 0, 0, 494, 1900, 1, 0, 0, 0, 496, 1904, 1, 0, 0, 0, 498, 1908, 1, 0, 0, 0, 500, 1912, 1, 0, 0, 0, 502, 1916, 1, 0, 0, 0, 504, 1920, 1, 0, 0, 0, 506, 1924, 1, 0, 0, 0, 508, 1932, 1, 0, 0, 0, 510, 1953, 1, 0, 0, 0, 512, 1957, 1, 0, 0, 0, 514, 1961, 1, 0, 0, 0, 516, 1965, 1, 0, 0, 0, 518, 1969, 1, 0, 0, 0, 520, 1973, 1, 0, 0, 0, 522, 1978, 1, 0, 0, 0, 524, 1984, 1, 0, 0, 0, 526, 1988, 1, 0, 0, 0, 528, 1992, 1, 0, 0, 0, 530, 1996, 1, 0, 0, 0, 532, 2000, 1, 0, 0, 0, 534, 2004, 1, 0, 0, 0, 536, 2008, 1, 0, 0, 0, 538, 2012, 1, 0, 0, 0, 540, 2016, 1, 0, 0, 0, 542, 2020, 1, 0, 0, 0, 544, 2023, 1, 0, 0, 0, 546, 2027, 1, 0, 0, 0, 548, 2031, 1, 0, 0, 0, 550, 2035, 1, 0, 0, 0, 552, 2039, 1, 0, 0, 0, 554, 2043, 1, 0, 0, 0, 556, 2047, 1, 0, 0, 0, 558, 2051, 1, 0, 0, 0, 560, 2056, 1, 0, 0, 0, 562, 2060, 1, 0, 0, 0, 564, 2064, 1, 0, 0, 0, 566, 2068, 1, 0, 0, 0, 568, 2072, 1, 0, 0, 0, 570, 2076, 1, 0, 0, 0, 572, 2080, 1, 0, 0, 0, 574, 2084, 1, 0, 0, 0, 576, 2088, 1, 0, 0, 0, 578, 2092, 1, 0, 0, 0, 580, 2096, 1, 0, 0, 0, 582, 2100, 1, 0, 0, 0, 584, 2104, 1, 0, 0, 0, 586, 2108, 1, 0, 0, 0, 588, 2112, 1, 0, 0, 0, 590, 2116, 1, 0, 0, 0, 592, 2120, 1, 0, 0, 0, 594, 2124, 1, 0, 0, 0, 596, 2128, 1, 0, 0, 0, 598, 2133, 1, 0, 0, 0, 600, 2138, 1, 0, 0, 0, 602, 2142, 1, 0, 0, 0, 604, 2146, 1, 0, 0, 0, 606, 607, 5, 47, 0, 0, 607, 608, 5, 47, 0, 0, 608, 612, 1, 0, 0, 0, 609, 611, 8, 0, 0, 0, 610, 609, 1, 0, 0, 0, 611, 614, 1, 0, 0, 0, 612, 610, 1, 0, 0, 0, 612, 613, 1, 0, 0, 0, 613, 616, 1, 0, 0, 0, 614, 612, 1, 0, 0, 0, 615, 617, 5, 13, 0, 0, 616, 615, 1, 0, 0, 0, 616, 617, 1, 0, 0, 0, 617, 619, 1, 0, 0, 0, 618, 620, 5, 10, 0, 0, 619, 618, 1, 0, 0, 0, 619, 620, 1, 0, 0, 0, 620, 621, 1, 0, 0, 0, 621, 622, 6, 0, 0, 0, 622, 19, 1, 0, 0, 0, 623, 624, 5, 47, 0, 0, 624, 625, 5, 42, 0, 0, 625, 630, 1, 0, 0, 0, 626, 629, 3, 20, 1, 0, 627, 629, 9, 0, 0, 0, 628, 626, 1, 0, 0, 0, 628, 627, 1, 0, 0, 0, 629, 632, 1, 0, 0, 0, 630, 631, 1, 0, 0, 0, 630, 628, 1, 0, 0, 0, 631, 633, 1, 0, 0, 0, 632, 630, 1, 0, 0, 0, 633, 634, 5, 42, 0, 0, 634, 635, 5, 47, 0, 0, 635, 636, 1, 0, 0, 0, 636, 637, 6, 1, 0, 0, 637, 21, 1, 0, 0, 0, 638, 640, 7, 1, 0, 0, 639, 638, 1, 0, 0, 0, 640, 641, 1, 0, 0, 0, 641, 639, 1, 0, 0, 0, 641, 642, 1, 0, 0, 0, 642, 643, 1, 0, 0, 0, 643, 644, 6, 2, 0, 0, 644, 23, 1, 0, 0, 0, 645, 646, 7, 2, 0, 0, 646, 647, 7, 3, 0, 0, 647, 648, 7, 4, 0, 0, 648, 649, 7, 5, 0, 0, 649, 650, 7, 6, 0, 0, 650, 651, 7, 7, 0, 0, 651, 652, 5, 95, 0, 0, 652, 653, 7, 8, 0, 0, 653, 654, 7, 9, 0, 0, 654, 655, 7, 10, 0, 0, 655, 656, 7, 5, 0, 0, 656, 657, 7, 11, 0, 0, 657, 658, 1, 0, 0, 0, 658, 659, 6, 3, 1, 0, 659, 25, 1, 0, 0, 0, 660, 661, 7, 7, 0, 0, 661, 662, 7, 5, 0, 0, 662, 663, 7, 12, 0, 0, 663, 664, 7, 10, 0, 0, 664, 665, 7, 2, 0, 0, 665, 666, 7, 3, 0, 0, 666, 667, 1, 0, 0, 0, 667, 668, 6, 4, 2, 0, 668, 27, 1, 0, 0, 0, 669, 670, 4, 5, 0, 0, 670, 671, 7, 7, 0, 0, 671, 672, 7, 13, 0, 0, 672, 673, 7, 8, 0, 0, 673, 674, 7, 14, 0, 0, 674, 675, 7, 4, 0, 0, 675, 676, 7, 10, 0, 0, 676, 677, 7, 5, 0, 0, 677, 678, 1, 0, 0, 0, 678, 679, 6, 5, 3, 0, 679, 29, 1, 0, 0, 0, 680, 681, 7, 2, 0, 0, 681, 682, 7, 9, 0, 0, 682, 683, 7, 15, 0, 0, 683, 684, 7, 8, 0, 0, 684, 685, 7, 14, 0, 0, 685, 686, 7, 7, 0, 0, 686, 687, 7, 11, 0, 0, 687, 688, 7, 10, 0, 0, 688, 689, 7, 9, 0, 0, 689, 690, 7, 5, 0, 0, 690, 691, 1, 0, 0, 0, 691, 692, 6, 6, 4, 0, 692, 31, 1, 0, 0, 0, 693, 694, 7, 16, 0, 0, 694, 695, 7, 10, 0, 0, 695, 696, 7, 17, 0, 0, 696, 697, 7, 17, 0, 0, 697, 698, 7, 7, 0, 0, 698, 699, 7, 2, 0, 0, 699, 700, 7, 11, 0, 0, 700, 701, 1, 0, 0, 0, 701, 702, 6, 7, 4, 0, 702, 33, 1, 0, 0, 0, 703, 704, 7, 7, 0, 0, 704, 705, 7, 18, 0, 0, 705, 706, 7, 4, 0, 0, 706, 707, 7, 14, 0, 0, 707, 708, 1, 0, 0, 0, 708, 709, 6, 8, 4, 0, 709, 35, 1, 0, 0, 0, 710, 711, 7, 6, 0, 0, 711, 712, 7, 12, 0, 0, 712, 713, 7, 9, 0, 0, 713, 714, 7, 19, 0, 0, 714, 715, 1, 0, 0, 0, 715, 716, 6, 9, 4, 0, 716, 37, 1, 0, 0, 0, 717, 718, 7, 14, 0, 0, 718, 719, 7, 10, 0, 0, 719, 720, 7, 15, 0, 0, 720, 721, 7, 10, 0, 0, 721, 722, 7, 11, 0, 0, 722, 723, 1, 0, 0, 0, 723, 724, 6, 10, 4, 0, 724, 39, 1, 0, 0, 0, 725, 726, 7, 12, 0, 0, 726, 727, 7, 7, 0, 0, 727, 728, 7, 12, 0, 0, 728, 729, 7, 4, 0, 0, 729, 730, 7, 5, 0, 0, 730, 731, 7, 19, 0, 0, 731, 732, 1, 0, 0, 0, 732, 733, 6, 11, 4, 0, 733, 41, 1, 0, 0, 0, 734, 735, 7, 12, 0, 0, 735, 736, 7, 9, 0, 0, 736, 737, 7, 20, 0, 0, 737, 738, 1, 0, 0, 0, 738, 739, 6, 12, 4, 0, 739, 43, 1, 0, 0, 0, 740, 741, 7, 17, 0, 0, 741, 742, 7, 4, 0, 0, 742, 743, 7, 15, 0, 0, 743, 744, 7, 8, 0, 0, 744, 745, 7, 14, 0, 0, 745, 746, 7, 7, 0, 0, 746, 747, 1, 0, 0, 0, 747, 748, 6, 13, 4, 0, 748, 45, 1, 0, 0, 0, 749, 750, 7, 17, 0, 0, 750, 751, 7, 9, 0, 0, 751, 752, 7, 12, 0, 0, 752, 753, 7, 11, 0, 0, 753, 754, 1, 0, 0, 0, 754, 755, 6, 14, 4, 0, 755, 47, 1, 0, 0, 0, 756, 757, 7, 17, 0, 0, 757, 758, 7, 11, 0, 0, 758, 759, 7, 4, 0, 0, 759, 760, 7, 11, 0, 0, 760, 761, 7, 17, 0, 0, 761, 762, 1, 0, 0, 0, 762, 763, 6, 15, 4, 0, 763, 49, 1, 0, 0, 0, 764, 765, 7, 20, 0, 0, 765, 766, 7, 3, 0, 0, 766, 767, 7, 7, 0, 0, 767, 768, 7, 12, 0, 0, 768, 769, 7, 7, 0, 0, 769, 770, 1, 0, 0, 0, 770, 771, 6, 16, 4, 0, 771, 51, 1, 0, 0, 0, 772, 773, 7, 21, 0, 0, 773, 774, 7, 12, 0, 0, 774, 775, 7, 9, 0, 0, 775, 776, 7, 15, 0, 0, 776, 777, 1, 0, 0, 0, 777, 778, 6, 17, 5, 0, 778, 53, 1, 0, 0, 0, 779, 780, 7, 11, 0, 0, 780, 781, 7, 17, 0, 0, 781, 782, 1, 0, 0, 0, 782, 783, 6, 18, 5, 0, 783, 55, 1, 0, 0, 0, 784, 785, 7, 21, 0, 0, 785, 786, 7, 9, 0, 0, 786, 787, 7, 12, 0, 0, 787, 788, 7, 19, 0, 0, 788, 789, 1, 0, 0, 0, 789, 790, 6, 19, 6, 0, 790, 57, 1, 0, 0, 0, 791, 792, 7, 21, 0, 0, 792, 793, 7, 22, 0, 0, 793, 794, 7, 17, 0, 0, 794, 795, 7, 7, 0, 0, 795, 796, 1, 0, 0, 0, 796, 797, 6, 20, 7, 0, 797, 59, 1, 0, 0, 0, 798, 799, 7, 10, 0, 0, 799, 800, 7, 5, 0, 0, 800, 801, 7, 14, 0, 0, 801, 802, 7, 10, 0, 0, 802, 803, 7, 5, 0, 0, 803, 804, 7, 7, 0, 0, 804, 805, 1, 0, 0, 0, 805, 806, 6, 21, 8, 0, 806, 61, 1, 0, 0, 0, 807, 808, 7, 10, 0, 0, 808, 809, 7, 5, 0, 0, 809, 810, 7, 14, 0, 0, 810, 811, 7, 10, 0, 0, 811, 812, 7, 5, 0, 0, 812, 813, 7, 7, 0, 0, 813, 814, 7, 17, 0, 0, 814, 815, 7, 11, 0, 0, 815, 816, 7, 4, 0, 0, 816, 817, 7, 11, 0, 0, 817, 818, 7, 17, 0, 0, 818, 819, 1, 0, 0, 0, 819, 820, 6, 22, 4, 0, 820, 63, 1, 0, 0, 0, 821, 822, 7, 14, 0, 0, 822, 823, 7, 9, 0, 0, 823, 824, 7, 9, 0, 0, 824, 825, 7, 19, 0, 0, 825, 826, 7, 22, 0, 0, 826, 827, 7, 8, 0, 0, 827, 828, 1, 0, 0, 0, 828, 829, 6, 23, 9, 0, 829, 65, 1, 0, 0, 0, 830, 831, 4, 24, 1, 0, 831, 832, 7, 21, 0, 0, 832, 833, 7, 22, 0, 0, 833, 834, 7, 14, 0, 0, 834, 835, 7, 14, 0, 0, 835, 836, 1, 0, 0, 0, 836, 837, 6, 24, 9, 0, 837, 67, 1, 0, 0, 0, 838, 839, 4, 25, 2, 0, 839, 840, 7, 14, 0, 0, 840, 841, 7, 7, 0, 0, 841, 842, 7, 21, 0, 0, 842, 843, 7, 11, 0, 0, 843, 844, 1, 0, 0, 0, 844, 845, 6, 25, 9, 0, 845, 69, 1, 0, 0, 0, 846, 847, 4, 26, 3, 0, 847, 848, 7, 12, 0, 0, 848, 849, 7, 10, 0, 0, 849, 850, 7, 6, 0, 0, 850, 851, 7, 3, 0, 0, 851, 852, 7, 11, 0, 0, 852, 853, 1, 0, 0, 0, 853, 854, 6, 26, 9, 0, 854, 71, 1, 0, 0, 0, 855, 856, 4, 27, 4, 0, 856, 857, 7, 14, 0, 0, 857, 858, 7, 9, 0, 0, 858, 859, 7, 9, 0, 0, 859, 860, 7, 19, 0, 0, 860, 861, 7, 22, 0, 0, 861, 862, 7, 8, 0, 0, 862, 863, 5, 95, 0, 0, 863, 864, 5, 128020, 0, 0, 864, 865, 1, 0, 0, 0, 865, 866, 6, 27, 10, 0, 866, 73, 1, 0, 0, 0, 867, 868, 7, 15, 0, 0, 868, 869, 7, 18, 0, 0, 869, 870, 5, 95, 0, 0, 870, 871, 7, 7, 0, 0, 871, 872, 7, 13, 0, 0, 872, 873, 7, 8, 0, 0, 873, 874, 7, 4, 0, 0, 874, 875, 7, 5, 0, 0, 875, 876, 7, 16, 0, 0, 876, 877, 1, 0, 0, 0, 877, 878, 6, 28, 11, 0, 878, 75, 1, 0, 0, 0, 879, 880, 7, 16, 0, 0, 880, 881, 7, 12, 0, 0, 881, 882, 7, 9, 0, 0, 882, 883, 7, 8, 0, 0, 883, 884, 1, 0, 0, 0, 884, 885, 6, 29, 12, 0, 885, 77, 1, 0, 0, 0, 886, 887, 7, 19, 0, 0, 887, 888, 7, 7, 0, 0, 888, 889, 7, 7, 0, 0, 889, 890, 7, 8, 0, 0, 890, 891, 1, 0, 0, 0, 891, 892, 6, 30, 12, 0, 892, 79, 1, 0, 0, 0, 893, 894, 4, 31, 5, 0, 894, 895, 7, 10, 0, 0, 895, 896, 7, 5, 0, 0, 896, 897, 7, 17, 0, 0, 897, 898, 7, 10, 0, 0, 898, 899, 7, 17, 0, 0, 899, 900, 7, 11, 0, 0, 900, 901, 5, 95, 0, 0, 901, 902, 5, 128020, 0, 0, 902, 903, 1, 0, 0, 0, 903, 904, 6, 31, 12, 0, 904, 81, 1, 0, 0, 0, 905, 906, 7, 12, 0, 0, 906, 907, 7, 7, 0, 0, 907, 908, 7, 5, 0, 0, 908, 909, 7, 4, 0, 0, 909, 910, 7, 15, 0, 0, 910, 911, 7, 7, 0, 0, 911, 912, 1, 0, 0, 0, 912, 913, 6, 32, 13, 0, 913, 83, 1, 0, 0, 0, 914, 915, 7, 17, 0, 0, 915, 916, 7, 7, 0, 0, 916, 917, 7, 11, 0, 0, 917, 918, 1, 0, 0, 0, 918, 919, 6, 33, 14, 0, 919, 85, 1, 0, 0, 0, 920, 921, 7, 17, 0, 0, 921, 922, 7, 3, 0, 0, 922, 923, 7, 9, 0, 0, 923, 924, 7, 20, 0, 0, 924, 925, 1, 0, 0, 0, 925, 926, 6, 34, 15, 0, 926, 87, 1, 0, 0, 0, 927, 929, 8, 23, 0, 0, 928, 927, 1, 0, 0, 0, 929, 930, 1, 0, 0, 0, 930, 928, 1, 0, 0, 0, 930, 931, 1, 0, 0, 0, 931, 932, 1, 0, 0, 0, 932, 933, 6, 35, 4, 0, 933, 89, 1, 0, 0, 0, 934, 935, 3, 182, 82, 0, 935, 936, 1, 0, 0, 0, 936, 937, 6, 36, 16, 0, 937, 938, 6, 36, 17, 0, 938, 91, 1, 0, 0, 0, 939, 940, 3, 302, 142, 0, 940, 941, 1, 0, 0, 0, 941, 942, 6, 37, 18, 0, 942, 943, 6, 37, 17, 0, 943, 944, 6, 37, 17, 0, 944, 93, 1, 0, 0, 0, 945, 946, 3, 248, 115, 0, 946, 947, 1, 0, 0, 0, 947, 948, 6, 38, 19, 0, 948, 95, 1, 0, 0, 0, 949, 950, 3, 542, 262, 0, 950, 951, 1, 0, 0, 0, 951, 952, 6, 39, 20, 0, 952, 97, 1, 0, 0, 0, 953, 954, 3, 228, 105, 0, 954, 955, 1, 0, 0, 0, 955, 956, 6, 40, 21, 0, 956, 99, 1, 0, 0, 0, 957, 958, 3, 224, 103, 0, 958, 959, 1, 0, 0, 0, 959, 960, 6, 41, 22, 0, 960, 101, 1, 0, 0, 0, 961, 962, 3, 296, 139, 0, 962, 963, 1, 0, 0, 0, 963, 964, 6, 42, 23, 0, 964, 103, 1, 0, 0, 0, 965, 966, 3, 298, 140, 0, 966, 967, 1, 0, 0, 0, 967, 968, 6, 43, 24, 0, 968, 105, 1, 0, 0, 0, 969, 970, 3, 308, 145, 0, 970, 971, 1, 0, 0, 0, 971, 972, 6, 44, 25, 0, 972, 107, 1, 0, 0, 0, 973, 974, 3, 304, 143, 0, 974, 975, 1, 0, 0, 0, 975, 976, 6, 45, 26, 0, 976, 109, 1, 0, 0, 0, 977, 978, 3, 18, 0, 0, 978, 979, 1, 0, 0, 0, 979, 980, 6, 46, 0, 0, 980, 111, 1, 0, 0, 0, 981, 982, 3, 20, 1, 0, 982, 983, 1, 0, 0, 0, 983, 984, 6, 47, 0, 0, 984, 113, 1, 0, 0, 0, 985, 986, 3, 22, 2, 0, 986, 987, 1, 0, 0, 0, 987, 988, 6, 48, 0, 0, 988, 115, 1, 0, 0, 0, 989, 990, 3, 182, 82, 0, 990, 991, 1, 0, 0, 0, 991, 992, 6, 49, 16, 0, 992, 993, 6, 49, 17, 0, 993, 117, 1, 0, 0, 0, 994, 995, 3, 302, 142, 0, 995, 996, 1, 0, 0, 0, 996, 997, 6, 50, 18, 0, 997, 998, 6, 50, 17, 0, 998, 999, 6, 50, 17, 0, 999, 119, 1, 0, 0, 0, 1000, 1001, 3, 248, 115, 0, 1001, 1002, 1, 0, 0, 0, 1002, 1003, 6, 51, 19, 0, 1003, 1004, 6, 51, 27, 0, 1004, 121, 1, 0, 0, 0, 1005, 1006, 3, 258, 120, 0, 1006, 1007, 1, 0, 0, 0, 1007, 1008, 6, 52, 28, 0, 1008, 1009, 6, 52, 27, 0, 1009, 123, 1, 0, 0, 0, 1010, 1011, 8, 24, 0, 0, 1011, 125, 1, 0, 0, 0, 1012, 1014, 3, 124, 53, 0, 1013, 1012, 1, 0, 0, 0, 1014, 1015, 1, 0, 0, 0, 1015, 1013, 1, 0, 0, 0, 1015, 1016, 1, 0, 0, 0, 1016, 1017, 1, 0, 0, 0, 1017, 1018, 3, 220, 101, 0, 1018, 1020, 1, 0, 0, 0, 1019, 1013, 1, 0, 0, 0, 1019, 1020, 1, 0, 0, 0, 1020, 1022, 1, 0, 0, 0, 1021, 1023, 3, 124, 53, 0, 1022, 1021, 1, 0, 0, 0, 1023, 1024, 1, 0, 0, 0, 1024, 1022, 1, 0, 0, 0, 1024, 1025, 1, 0, 0, 0, 1025, 127, 1, 0, 0, 0, 1026, 1027, 3, 126, 54, 0, 1027, 1028, 1, 0, 0, 0, 1028, 1029, 6, 55, 29, 0, 1029, 129, 1, 0, 0, 0, 1030, 1031, 3, 204, 93, 0, 1031, 1032, 1, 0, 0, 0, 1032, 1033, 6, 56, 30, 0, 1033, 131, 1, 0, 0, 0, 1034, 1035, 3, 18, 0, 0, 1035, 1036, 1, 0, 0, 0, 1036, 1037, 6, 57, 0, 0, 1037, 133, 1, 0, 0, 0, 1038, 1039, 3, 20, 1, 0, 1039, 1040, 1, 0, 0, 0, 1040, 1041, 6, 58, 0, 0, 1041, 135, 1, 0, 0, 0, 1042, 1043, 3, 22, 2, 0, 1043, 1044, 1, 0, 0, 0, 1044, 1045, 6, 59, 0, 0, 1045, 137, 1, 0, 0, 0, 1046, 1047, 3, 182, 82, 0, 1047, 1048, 1, 0, 0, 0, 1048, 1049, 6, 60, 16, 0, 1049, 1050, 6, 60, 17, 0, 1050, 1051, 6, 60, 17, 0, 1051, 139, 1, 0, 0, 0, 1052, 1053, 3, 302, 142, 0, 1053, 1054, 1, 0, 0, 0, 1054, 1055, 6, 61, 18, 0, 1055, 1056, 6, 61, 17, 0, 1056, 1057, 6, 61, 17, 0, 1057, 1058, 6, 61, 17, 0, 1058, 141, 1, 0, 0, 0, 1059, 1060, 3, 296, 139, 0, 1060, 1061, 1, 0, 0, 0, 1061, 1062, 6, 62, 23, 0, 1062, 143, 1, 0, 0, 0, 1063, 1064, 3, 298, 140, 0, 1064, 1065, 1, 0, 0, 0, 1065, 1066, 6, 63, 24, 0, 1066, 145, 1, 0, 0, 0, 1067, 1068, 3, 214, 98, 0, 1068, 1069, 1, 0, 0, 0, 1069, 1070, 6, 64, 31, 0, 1070, 147, 1, 0, 0, 0, 1071, 1072, 3, 224, 103, 0, 1072, 1073, 1, 0, 0, 0, 1073, 1074, 6, 65, 22, 0, 1074, 149, 1, 0, 0, 0, 1075, 1076, 3, 228, 105, 0, 1076, 1077, 1, 0, 0, 0, 1077, 1078, 6, 66, 21, 0, 1078, 151, 1, 0, 0, 0, 1079, 1080, 3, 258, 120, 0, 1080, 1081, 1, 0, 0, 0, 1081, 1082, 6, 67, 28, 0, 1082, 153, 1, 0, 0, 0, 1083, 1084, 3, 512, 247, 0, 1084, 1085, 1, 0, 0, 0, 1085, 1086, 6, 68, 32, 0, 1086, 155, 1, 0, 0, 0, 1087, 1088, 3, 308, 145, 0, 1088, 1089, 1, 0, 0, 0, 1089, 1090, 6, 69, 25, 0, 1090, 157, 1, 0, 0, 0, 1091, 1092, 3, 252, 117, 0, 1092, 1093, 1, 0, 0, 0, 1093, 1094, 6, 70, 33, 0, 1094, 159, 1, 0, 0, 0, 1095, 1096, 3, 292, 137, 0, 1096, 1097, 1, 0, 0, 0, 1097, 1098, 6, 71, 34, 0, 1098, 161, 1, 0, 0, 0, 1099, 1100, 3, 288, 135, 0, 1100, 1101, 1, 0, 0, 0, 1101, 1102, 6, 72, 35, 0, 1102, 163, 1, 0, 0, 0, 1103, 1104, 3, 294, 138, 0, 1104, 1105, 1, 0, 0, 0, 1105, 1106, 6, 73, 36, 0, 1106, 165, 1, 0, 0, 0, 1107, 1108, 3, 18, 0, 0, 1108, 1109, 1, 0, 0, 0, 1109, 1110, 6, 74, 0, 0, 1110, 167, 1, 0, 0, 0, 1111, 1112, 3, 20, 1, 0, 1112, 1113, 1, 0, 0, 0, 1113, 1114, 6, 75, 0, 0, 1114, 169, 1, 0, 0, 0, 1115, 1116, 3, 22, 2, 0, 1116, 1117, 1, 0, 0, 0, 1117, 1118, 6, 76, 0, 0, 1118, 171, 1, 0, 0, 0, 1119, 1120, 3, 300, 141, 0, 1120, 1121, 1, 0, 0, 0, 1121, 1122, 6, 77, 37, 0, 1122, 1123, 6, 77, 38, 0, 1123, 173, 1, 0, 0, 0, 1124, 1125, 3, 182, 82, 0, 1125, 1126, 1, 0, 0, 0, 1126, 1127, 6, 78, 16, 0, 1127, 1128, 6, 78, 17, 0, 1128, 175, 1, 0, 0, 0, 1129, 1130, 3, 22, 2, 0, 1130, 1131, 1, 0, 0, 0, 1131, 1132, 6, 79, 0, 0, 1132, 177, 1, 0, 0, 0, 1133, 1134, 3, 18, 0, 0, 1134, 1135, 1, 0, 0, 0, 1135, 1136, 6, 80, 0, 0, 1136, 179, 1, 0, 0, 0, 1137, 1138, 3, 20, 1, 0, 1138, 1139, 1, 0, 0, 0, 1139, 1140, 6, 81, 0, 0, 1140, 181, 1, 0, 0, 0, 1141, 1142, 5, 124, 0, 0, 1142, 1143, 1, 0, 0, 0, 1143, 1144, 6, 82, 17, 0, 1144, 183, 1, 0, 0, 0, 1145, 1146, 7, 25, 0, 0, 1146, 185, 1, 0, 0, 0, 1147, 1148, 7, 26, 0, 0, 1148, 187, 1, 0, 0, 0, 1149, 1150, 5, 92, 0, 0, 1150, 1151, 7, 27, 0, 0, 1151, 189, 1, 0, 0, 0, 1152, 1153, 8, 28, 0, 0, 1153, 191, 1, 0, 0, 0, 1154, 1156, 7, 7, 0, 0, 1155, 1157, 7, 29, 0, 0, 1156, 1155, 1, 0, 0, 0, 1156, 1157, 1, 0, 0, 0, 1157, 1159, 1, 0, 0, 0, 1158, 1160, 3, 184, 83, 0, 1159, 1158, 1, 0, 0, 0, 1160, 1161, 1, 0, 0, 0, 1161, 1159, 1, 0, 0, 0, 1161, 1162, 1, 0, 0, 0, 1162, 193, 1, 0, 0, 0, 1163, 1164, 5, 64, 0, 0, 1164, 195, 1, 0, 0, 0, 1165, 1166, 5, 96, 0, 0, 1166, 197, 1, 0, 0, 0, 1167, 1171, 8, 30, 0, 0, 1168, 1169, 5, 96, 0, 0, 1169, 1171, 5, 96, 0, 0, 1170, 1167, 1, 0, 0, 0, 1170, 1168, 1, 0, 0, 0, 1171, 199, 1, 0, 0, 0, 1172, 1173, 5, 95, 0, 0, 1173, 201, 1, 0, 0, 0, 1174, 1178, 3, 186, 84, 0, 1175, 1178, 3, 184, 83, 0, 1176, 1178, 3, 200, 91, 0, 1177, 1174, 1, 0, 0, 0, 1177, 1175, 1, 0, 0, 0, 1177, 1176, 1, 0, 0, 0, 1178, 203, 1, 0, 0, 0, 1179, 1184, 5, 34, 0, 0, 1180, 1183, 3, 188, 85, 0, 1181, 1183, 3, 190, 86, 0, 1182, 1180, 1, 0, 0, 0, 1182, 1181, 1, 0, 0, 0, 1183, 1186, 1, 0, 0, 0, 1184, 1182, 1, 0, 0, 0, 1184, 1185, 1, 0, 0, 0, 1185, 1187, 1, 0, 0, 0, 1186, 1184, 1, 0, 0, 0, 1187, 1209, 5, 34, 0, 0, 1188, 1189, 5, 34, 0, 0, 1189, 1190, 5, 34, 0, 0, 1190, 1191, 5, 34, 0, 0, 1191, 1195, 1, 0, 0, 0, 1192, 1194, 8, 0, 0, 0, 1193, 1192, 1, 0, 0, 0, 1194, 1197, 1, 0, 0, 0, 1195, 1196, 1, 0, 0, 0, 1195, 1193, 1, 0, 0, 0, 1196, 1198, 1, 0, 0, 0, 1197, 1195, 1, 0, 0, 0, 1198, 1199, 5, 34, 0, 0, 1199, 1200, 5, 34, 0, 0, 1200, 1201, 5, 34, 0, 0, 1201, 1203, 1, 0, 0, 0, 1202, 1204, 5, 34, 0, 0, 1203, 1202, 1, 0, 0, 0, 1203, 1204, 1, 0, 0, 0, 1204, 1206, 1, 0, 0, 0, 1205, 1207, 5, 34, 0, 0, 1206, 1205, 1, 0, 0, 0, 1206, 1207, 1, 0, 0, 0, 1207, 1209, 1, 0, 0, 0, 1208, 1179, 1, 0, 0, 0, 1208, 1188, 1, 0, 0, 0, 1209, 205, 1, 0, 0, 0, 1210, 1212, 3, 184, 83, 0, 1211, 1210, 1, 0, 0, 0, 1212, 1213, 1, 0, 0, 0, 1213, 1211, 1, 0, 0, 0, 1213, 1214, 1, 0, 0, 0, 1214, 207, 1, 0, 0, 0, 1215, 1217, 3, 184, 83, 0, 1216, 1215, 1, 0, 0, 0, 1217, 1218, 1, 0, 0, 0, 1218, 1216, 1, 0, 0, 0, 1218, 1219, 1, 0, 0, 0, 1219, 1220, 1, 0, 0, 0, 1220, 1224, 3, 228, 105, 0, 1221, 1223, 3, 184, 83, 0, 1222, 1221, 1, 0, 0, 0, 1223, 1226, 1, 0, 0, 0, 1224, 1222, 1, 0, 0, 0, 1224, 1225, 1, 0, 0, 0, 1225, 1258, 1, 0, 0, 0, 1226, 1224, 1, 0, 0, 0, 1227, 1229, 3, 228, 105, 0, 1228, 1230, 3, 184, 83, 0, 1229, 1228, 1, 0, 0, 0, 1230, 1231, 1, 0, 0, 0, 1231, 1229, 1, 0, 0, 0, 1231, 1232, 1, 0, 0, 0, 1232, 1258, 1, 0, 0, 0, 1233, 1235, 3, 184, 83, 0, 1234, 1233, 1, 0, 0, 0, 1235, 1236, 1, 0, 0, 0, 1236, 1234, 1, 0, 0, 0, 1236, 1237, 1, 0, 0, 0, 1237, 1245, 1, 0, 0, 0, 1238, 1242, 3, 228, 105, 0, 1239, 1241, 3, 184, 83, 0, 1240, 1239, 1, 0, 0, 0, 1241, 1244, 1, 0, 0, 0, 1242, 1240, 1, 0, 0, 0, 1242, 1243, 1, 0, 0, 0, 1243, 1246, 1, 0, 0, 0, 1244, 1242, 1, 0, 0, 0, 1245, 1238, 1, 0, 0, 0, 1245, 1246, 1, 0, 0, 0, 1246, 1247, 1, 0, 0, 0, 1247, 1248, 3, 192, 87, 0, 1248, 1258, 1, 0, 0, 0, 1249, 1251, 3, 228, 105, 0, 1250, 1252, 3, 184, 83, 0, 1251, 1250, 1, 0, 0, 0, 1252, 1253, 1, 0, 0, 0, 1253, 1251, 1, 0, 0, 0, 1253, 1254, 1, 0, 0, 0, 1254, 1255, 1, 0, 0, 0, 1255, 1256, 3, 192, 87, 0, 1256, 1258, 1, 0, 0, 0, 1257, 1216, 1, 0, 0, 0, 1257, 1227, 1, 0, 0, 0, 1257, 1234, 1, 0, 0, 0, 1257, 1249, 1, 0, 0, 0, 1258, 209, 1, 0, 0, 0, 1259, 1260, 7, 4, 0, 0, 1260, 1261, 7, 5, 0, 0, 1261, 1262, 7, 16, 0, 0, 1262, 211, 1, 0, 0, 0, 1263, 1264, 7, 4, 0, 0, 1264, 1265, 7, 17, 0, 0, 1265, 1266, 7, 2, 0, 0, 1266, 213, 1, 0, 0, 0, 1267, 1268, 5, 61, 0, 0, 1268, 215, 1, 0, 0, 0, 1269, 1270, 7, 31, 0, 0, 1270, 1271, 7, 32, 0, 0, 1271, 217, 1, 0, 0, 0, 1272, 1273, 5, 58, 0, 0, 1273, 1274, 5, 58, 0, 0, 1274, 219, 1, 0, 0, 0, 1275, 1276, 5, 58, 0, 0, 1276, 221, 1, 0, 0, 0, 1277, 1278, 5, 59, 0, 0, 1278, 223, 1, 0, 0, 0, 1279, 1280, 5, 44, 0, 0, 1280, 225, 1, 0, 0, 0, 1281, 1282, 7, 16, 0, 0, 1282, 1283, 7, 7, 0, 0, 1283, 1284, 7, 17, 0, 0, 1284, 1285, 7, 2, 0, 0, 1285, 227, 1, 0, 0, 0, 1286, 1287, 5, 46, 0, 0, 1287, 229, 1, 0, 0, 0, 1288, 1289, 7, 21, 0, 0, 1289, 1290, 7, 4, 0, 0, 1290, 1291, 7, 14, 0, 0, 1291, 1292, 7, 17, 0, 0, 1292, 1293, 7, 7, 0, 0, 1293, 231, 1, 0, 0, 0, 1294, 1295, 7, 21, 0, 0, 1295, 1296, 7, 10, 0, 0, 1296, 1297, 7, 12, 0, 0, 1297, 1298, 7, 17, 0, 0, 1298, 1299, 7, 11, 0, 0, 1299, 233, 1, 0, 0, 0, 1300, 1301, 7, 10, 0, 0, 1301, 1302, 7, 5, 0, 0, 1302, 235, 1, 0, 0, 0, 1303, 1304, 7, 10, 0, 0, 1304, 1305, 7, 17, 0, 0, 1305, 237, 1, 0, 0, 0, 1306, 1307, 7, 14, 0, 0, 1307, 1308, 7, 4, 0, 0, 1308, 1309, 7, 17, 0, 0, 1309, 1310, 7, 11, 0, 0, 1310, 239, 1, 0, 0, 0, 1311, 1312, 7, 14, 0, 0, 1312, 1313, 7, 10, 0, 0, 1313, 1314, 7, 19, 0, 0, 1314, 1315, 7, 7, 0, 0, 1315, 241, 1, 0, 0, 0, 1316, 1317, 7, 5, 0, 0, 1317, 1318, 7, 9, 0, 0, 1318, 1319, 7, 11, 0, 0, 1319, 243, 1, 0, 0, 0, 1320, 1321, 7, 5, 0, 0, 1321, 1322, 7, 22, 0, 0, 1322, 1323, 7, 14, 0, 0, 1323, 1324, 7, 14, 0, 0, 1324, 245, 1, 0, 0, 0, 1325, 1326, 7, 5, 0, 0, 1326, 1327, 7, 22, 0, 0, 1327, 1328, 7, 14, 0, 0, 1328, 1329, 7, 14, 0, 0, 1329, 1330, 7, 17, 0, 0, 1330, 247, 1, 0, 0, 0, 1331, 1332, 7, 9, 0, 0, 1332, 1333, 7, 5, 0, 0, 1333, 249, 1, 0, 0, 0, 1334, 1335, 7, 9, 0, 0, 1335, 1336, 7, 12, 0, 0, 1336, 251, 1, 0, 0, 0, 1337, 1338, 5, 63, 0, 0, 1338, 253, 1, 0, 0, 0, 1339, 1340, 7, 12, 0, 0, 1340, 1341, 7, 14, 0, 0, 1341, 1342, 7, 10, 0, 0, 1342, 1343, 7, 19, 0, 0, 1343, 1344, 7, 7, 0, 0, 1344, 255, 1, 0, 0, 0, 1345, 1346, 7, 11, 0, 0, 1346, 1347, 7, 12, 0, 0, 1347, 1348, 7, 22, 0, 0, 1348, 1349, 7, 7, 0, 0, 1349, 257, 1, 0, 0, 0, 1350, 1351, 7, 20, 0, 0, 1351, 1352, 7, 10, 0, 0, 1352, 1353, 7, 11, 0, 0, 1353, 1354, 7, 3, 0, 0, 1354, 259, 1, 0, 0, 0, 1355, 1356, 5, 61, 0, 0, 1356, 1357, 5, 61, 0, 0, 1357, 261, 1, 0, 0, 0, 1358, 1359, 5, 61, 0, 0, 1359, 1360, 5, 126, 0, 0, 1360, 263, 1, 0, 0, 0, 1361, 1362, 5, 33, 0, 0, 1362, 1363, 5, 61, 0, 0, 1363, 265, 1, 0, 0, 0, 1364, 1365, 5, 60, 0, 0, 1365, 267, 1, 0, 0, 0, 1366, 1367, 5, 60, 0, 0, 1367, 1368, 5, 61, 0, 0, 1368, 269, 1, 0, 0, 0, 1369, 1370, 5, 62, 0, 0, 1370, 271, 1, 0, 0, 0, 1371, 1372, 5, 62, 0, 0, 1372, 1373, 5, 61, 0, 0, 1373, 273, 1, 0, 0, 0, 1374, 1375, 5, 43, 0, 0, 1375, 275, 1, 0, 0, 0, 1376, 1377, 5, 45, 0, 0, 1377, 277, 1, 0, 0, 0, 1378, 1379, 5, 42, 0, 0, 1379, 279, 1, 0, 0, 0, 1380, 1381, 5, 47, 0, 0, 1381, 281, 1, 0, 0, 0, 1382, 1383, 5, 37, 0, 0, 1383, 283, 1, 0, 0, 0, 1384, 1385, 5, 123, 0, 0, 1385, 285, 1, 0, 0, 0, 1386, 1387, 5, 125, 0, 0, 1387, 287, 1, 0, 0, 0, 1388, 1389, 5, 63, 0, 0, 1389, 1390, 5, 63, 0, 0, 1390, 289, 1, 0, 0, 0, 1391, 1392, 3, 50, 16, 0, 1392, 1393, 1, 0, 0, 0, 1393, 1394, 6, 136, 39, 0, 1394, 291, 1, 0, 0, 0, 1395, 1398, 3, 252, 117, 0, 1396, 1399, 3, 186, 84, 0, 1397, 1399, 3, 200, 91, 0, 1398, 1396, 1, 0, 0, 0, 1398, 1397, 1, 0, 0, 0, 1399, 1403, 1, 0, 0, 0, 1400, 1402, 3, 202, 92, 0, 1401, 1400, 1, 0, 0, 0, 1402, 1405, 1, 0, 0, 0, 1403, 1401, 1, 0, 0, 0, 1403, 1404, 1, 0, 0, 0, 1404, 1413, 1, 0, 0, 0, 1405, 1403, 1, 0, 0, 0, 1406, 1408, 3, 252, 117, 0, 1407, 1409, 3, 184, 83, 0, 1408, 1407, 1, 0, 0, 0, 1409, 1410, 1, 0, 0, 0, 1410, 1408, 1, 0, 0, 0, 1410, 1411, 1, 0, 0, 0, 1411, 1413, 1, 0, 0, 0, 1412, 1395, 1, 0, 0, 0, 1412, 1406, 1, 0, 0, 0, 1413, 293, 1, 0, 0, 0, 1414, 1417, 3, 288, 135, 0, 1415, 1418, 3, 186, 84, 0, 1416, 1418, 3, 200, 91, 0, 1417, 1415, 1, 0, 0, 0, 1417, 1416, 1, 0, 0, 0, 1418, 1422, 1, 0, 0, 0, 1419, 1421, 3, 202, 92, 0, 1420, 1419, 1, 0, 0, 0, 1421, 1424, 1, 0, 0, 0, 1422, 1420, 1, 0, 0, 0, 1422, 1423, 1, 0, 0, 0, 1423, 1432, 1, 0, 0, 0, 1424, 1422, 1, 0, 0, 0, 1425, 1427, 3, 288, 135, 0, 1426, 1428, 3, 184, 83, 0, 1427, 1426, 1, 0, 0, 0, 1428, 1429, 1, 0, 0, 0, 1429, 1427, 1, 0, 0, 0, 1429, 1430, 1, 0, 0, 0, 1430, 1432, 1, 0, 0, 0, 1431, 1414, 1, 0, 0, 0, 1431, 1425, 1, 0, 0, 0, 1432, 295, 1, 0, 0, 0, 1433, 1434, 5, 91, 0, 0, 1434, 1435, 1, 0, 0, 0, 1435, 1436, 6, 139, 4, 0, 1436, 1437, 6, 139, 4, 0, 1437, 297, 1, 0, 0, 0, 1438, 1439, 5, 93, 0, 0, 1439, 1440, 1, 0, 0, 0, 1440, 1441, 6, 140, 17, 0, 1441, 1442, 6, 140, 17, 0, 1442, 299, 1, 0, 0, 0, 1443, 1444, 5, 40, 0, 0, 1444, 1445, 1, 0, 0, 0, 1445, 1446, 6, 141, 4, 0, 1446, 1447, 6, 141, 4, 0, 1447, 301, 1, 0, 0, 0, 1448, 1449, 5, 41, 0, 0, 1449, 1450, 1, 0, 0, 0, 1450, 1451, 6, 142, 17, 0, 1451, 1452, 6, 142, 17, 0, 1452, 303, 1, 0, 0, 0, 1453, 1457, 3, 186, 84, 0, 1454, 1456, 3, 202, 92, 0, 1455, 1454, 1, 0, 0, 0, 1456, 1459, 1, 0, 0, 0, 1457, 1455, 1, 0, 0, 0, 1457, 1458, 1, 0, 0, 0, 1458, 1470, 1, 0, 0, 0, 1459, 1457, 1, 0, 0, 0, 1460, 1463, 3, 200, 91, 0, 1461, 1463, 3, 194, 88, 0, 1462, 1460, 1, 0, 0, 0, 1462, 1461, 1, 0, 0, 0, 1463, 1465, 1, 0, 0, 0, 1464, 1466, 3, 202, 92, 0, 1465, 1464, 1, 0, 0, 0, 1466, 1467, 1, 0, 0, 0, 1467, 1465, 1, 0, 0, 0, 1467, 1468, 1, 0, 0, 0, 1468, 1470, 1, 0, 0, 0, 1469, 1453, 1, 0, 0, 0, 1469, 1462, 1, 0, 0, 0, 1470, 305, 1, 0, 0, 0, 1471, 1473, 3, 196, 89, 0, 1472, 1474, 3, 198, 90, 0, 1473, 1472, 1, 0, 0, 0, 1474, 1475, 1, 0, 0, 0, 1475, 1473, 1, 0, 0, 0, 1475, 1476, 1, 0, 0, 0, 1476, 1477, 1, 0, 0, 0, 1477, 1478, 3, 196, 89, 0, 1478, 307, 1, 0, 0, 0, 1479, 1480, 3, 306, 144, 0, 1480, 309, 1, 0, 0, 0, 1481, 1482, 3, 18, 0, 0, 1482, 1483, 1, 0, 0, 0, 1483, 1484, 6, 146, 0, 0, 1484, 311, 1, 0, 0, 0, 1485, 1486, 3, 20, 1, 0, 1486, 1487, 1, 0, 0, 0, 1487, 1488, 6, 147, 0, 0, 1488, 313, 1, 0, 0, 0, 1489, 1490, 3, 22, 2, 0, 1490, 1491, 1, 0, 0, 0, 1491, 1492, 6, 148, 0, 0, 1492, 315, 1, 0, 0, 0, 1493, 1494, 3, 182, 82, 0, 1494, 1495, 1, 0, 0, 0, 1495, 1496, 6, 149, 16, 0, 1496, 1497, 6, 149, 17, 0, 1497, 317, 1, 0, 0, 0, 1498, 1499, 3, 220, 101, 0, 1499, 1500, 1, 0, 0, 0, 1500, 1501, 6, 150, 40, 0, 1501, 319, 1, 0, 0, 0, 1502, 1503, 3, 218, 100, 0, 1503, 1504, 1, 0, 0, 0, 1504, 1505, 6, 151, 41, 0, 1505, 321, 1, 0, 0, 0, 1506, 1507, 3, 224, 103, 0, 1507, 1508, 1, 0, 0, 0, 1508, 1509, 6, 152, 22, 0, 1509, 323, 1, 0, 0, 0, 1510, 1511, 3, 214, 98, 0, 1511, 1512, 1, 0, 0, 0, 1512, 1513, 6, 153, 31, 0, 1513, 325, 1, 0, 0, 0, 1514, 1515, 7, 15, 0, 0, 1515, 1516, 7, 7, 0, 0, 1516, 1517, 7, 11, 0, 0, 1517, 1518, 7, 4, 0, 0, 1518, 1519, 7, 16, 0, 0, 1519, 1520, 7, 4, 0, 0, 1520, 1521, 7, 11, 0, 0, 1521, 1522, 7, 4, 0, 0, 1522, 327, 1, 0, 0, 0, 1523, 1524, 3, 302, 142, 0, 1524, 1525, 1, 0, 0, 0, 1525, 1526, 6, 155, 18, 0, 1526, 1527, 6, 155, 17, 0, 1527, 329, 1, 0, 0, 0, 1528, 1532, 8, 33, 0, 0, 1529, 1530, 5, 47, 0, 0, 1530, 1532, 8, 34, 0, 0, 1531, 1528, 1, 0, 0, 0, 1531, 1529, 1, 0, 0, 0, 1532, 331, 1, 0, 0, 0, 1533, 1535, 3, 330, 156, 0, 1534, 1533, 1, 0, 0, 0, 1535, 1536, 1, 0, 0, 0, 1536, 1534, 1, 0, 0, 0, 1536, 1537, 1, 0, 0, 0, 1537, 333, 1, 0, 0, 0, 1538, 1539, 3, 332, 157, 0, 1539, 1540, 1, 0, 0, 0, 1540, 1541, 6, 158, 42, 0, 1541, 335, 1, 0, 0, 0, 1542, 1543, 3, 204, 93, 0, 1543, 1544, 1, 0, 0, 0, 1544, 1545, 6, 159, 30, 0, 1545, 337, 1, 0, 0, 0, 1546, 1547, 3, 18, 0, 0, 1547, 1548, 1, 0, 0, 0, 1548, 1549, 6, 160, 0, 0, 1549, 339, 1, 0, 0, 0, 1550, 1551, 3, 20, 1, 0, 1551, 1552, 1, 0, 0, 0, 1552, 1553, 6, 161, 0, 0, 1553, 341, 1, 0, 0, 0, 1554, 1555, 3, 22, 2, 0, 1555, 1556, 1, 0, 0, 0, 1556, 1557, 6, 162, 0, 0, 1557, 343, 1, 0, 0, 0, 1558, 1559, 3, 300, 141, 0, 1559, 1560, 1, 0, 0, 0, 1560, 1561, 6, 163, 37, 0, 1561, 1562, 6, 163, 38, 0, 1562, 345, 1, 0, 0, 0, 1563, 1564, 3, 302, 142, 0, 1564, 1565, 1, 0, 0, 0, 1565, 1566, 6, 164, 18, 0, 1566, 1567, 6, 164, 17, 0, 1567, 1568, 6, 164, 17, 0, 1568, 347, 1, 0, 0, 0, 1569, 1570, 3, 182, 82, 0, 1570, 1571, 1, 0, 0, 0, 1571, 1572, 6, 165, 16, 0, 1572, 1573, 6, 165, 17, 0, 1573, 349, 1, 0, 0, 0, 1574, 1575, 3, 22, 2, 0, 1575, 1576, 1, 0, 0, 0, 1576, 1577, 6, 166, 0, 0, 1577, 351, 1, 0, 0, 0, 1578, 1579, 3, 18, 0, 0, 1579, 1580, 1, 0, 0, 0, 1580, 1581, 6, 167, 0, 0, 1581, 353, 1, 0, 0, 0, 1582, 1583, 3, 20, 1, 0, 1583, 1584, 1, 0, 0, 0, 1584, 1585, 6, 168, 0, 0, 1585, 355, 1, 0, 0, 0, 1586, 1587, 3, 182, 82, 0, 1587, 1588, 1, 0, 0, 0, 1588, 1589, 6, 169, 16, 0, 1589, 1590, 6, 169, 17, 0, 1590, 357, 1, 0, 0, 0, 1591, 1592, 3, 302, 142, 0, 1592, 1593, 1, 0, 0, 0, 1593, 1594, 6, 170, 18, 0, 1594, 1595, 6, 170, 17, 0, 1595, 1596, 6, 170, 17, 0, 1596, 359, 1, 0, 0, 0, 1597, 1598, 7, 6, 0, 0, 1598, 1599, 7, 12, 0, 0, 1599, 1600, 7, 9, 0, 0, 1600, 1601, 7, 22, 0, 0, 1601, 1602, 7, 8, 0, 0, 1602, 361, 1, 0, 0, 0, 1603, 1604, 7, 17, 0, 0, 1604, 1605, 7, 2, 0, 0, 1605, 1606, 7, 9, 0, 0, 1606, 1607, 7, 12, 0, 0, 1607, 1608, 7, 7, 0, 0, 1608, 363, 1, 0, 0, 0, 1609, 1610, 7, 19, 0, 0, 1610, 1611, 7, 7, 0, 0, 1611, 1612, 7, 32, 0, 0, 1612, 365, 1, 0, 0, 0, 1613, 1614, 3, 258, 120, 0, 1614, 1615, 1, 0, 0, 0, 1615, 1616, 6, 174, 28, 0, 1616, 1617, 6, 174, 17, 0, 1617, 1618, 6, 174, 4, 0, 1618, 367, 1, 0, 0, 0, 1619, 1620, 3, 224, 103, 0, 1620, 1621, 1, 0, 0, 0, 1621, 1622, 6, 175, 22, 0, 1622, 369, 1, 0, 0, 0, 1623, 1624, 3, 228, 105, 0, 1624, 1625, 1, 0, 0, 0, 1625, 1626, 6, 176, 21, 0, 1626, 371, 1, 0, 0, 0, 1627, 1628, 3, 252, 117, 0, 1628, 1629, 1, 0, 0, 0, 1629, 1630, 6, 177, 33, 0, 1630, 373, 1, 0, 0, 0, 1631, 1632, 3, 292, 137, 0, 1632, 1633, 1, 0, 0, 0, 1633, 1634, 6, 178, 34, 0, 1634, 375, 1, 0, 0, 0, 1635, 1636, 3, 288, 135, 0, 1636, 1637, 1, 0, 0, 0, 1637, 1638, 6, 179, 35, 0, 1638, 377, 1, 0, 0, 0, 1639, 1640, 3, 294, 138, 0, 1640, 1641, 1, 0, 0, 0, 1641, 1642, 6, 180, 36, 0, 1642, 379, 1, 0, 0, 0, 1643, 1644, 3, 216, 99, 0, 1644, 1645, 1, 0, 0, 0, 1645, 1646, 6, 181, 43, 0, 1646, 381, 1, 0, 0, 0, 1647, 1648, 3, 308, 145, 0, 1648, 1649, 1, 0, 0, 0, 1649, 1650, 6, 182, 25, 0, 1650, 383, 1, 0, 0, 0, 1651, 1652, 3, 304, 143, 0, 1652, 1653, 1, 0, 0, 0, 1653, 1654, 6, 183, 26, 0, 1654, 385, 1, 0, 0, 0, 1655, 1656, 3, 18, 0, 0, 1656, 1657, 1, 0, 0, 0, 1657, 1658, 6, 184, 0, 0, 1658, 387, 1, 0, 0, 0, 1659, 1660, 3, 20, 1, 0, 1660, 1661, 1, 0, 0, 0, 1661, 1662, 6, 185, 0, 0, 1662, 389, 1, 0, 0, 0, 1663, 1664, 3, 22, 2, 0, 1664, 1665, 1, 0, 0, 0, 1665, 1666, 6, 186, 0, 0, 1666, 391, 1, 0, 0, 0, 1667, 1668, 7, 17, 0, 0, 1668, 1669, 7, 11, 0, 0, 1669, 1670, 7, 4, 0, 0, 1670, 1671, 7, 11, 0, 0, 1671, 1672, 7, 17, 0, 0, 1672, 1673, 1, 0, 0, 0, 1673, 1674, 6, 187, 17, 0, 1674, 1675, 6, 187, 4, 0, 1675, 393, 1, 0, 0, 0, 1676, 1677, 3, 18, 0, 0, 1677, 1678, 1, 0, 0, 0, 1678, 1679, 6, 188, 0, 0, 1679, 395, 1, 0, 0, 0, 1680, 1681, 3, 20, 1, 0, 1681, 1682, 1, 0, 0, 0, 1682, 1683, 6, 189, 0, 0, 1683, 397, 1, 0, 0, 0, 1684, 1685, 3, 22, 2, 0, 1685, 1686, 1, 0, 0, 0, 1686, 1687, 6, 190, 0, 0, 1687, 399, 1, 0, 0, 0, 1688, 1689, 3, 182, 82, 0, 1689, 1690, 1, 0, 0, 0, 1690, 1691, 6, 191, 16, 0, 1691, 1692, 6, 191, 17, 0, 1692, 401, 1, 0, 0, 0, 1693, 1694, 7, 35, 0, 0, 1694, 1695, 7, 9, 0, 0, 1695, 1696, 7, 10, 0, 0, 1696, 1697, 7, 5, 0, 0, 1697, 403, 1, 0, 0, 0, 1698, 1699, 3, 542, 262, 0, 1699, 1700, 1, 0, 0, 0, 1700, 1701, 6, 193, 20, 0, 1701, 405, 1, 0, 0, 0, 1702, 1703, 3, 248, 115, 0, 1703, 1704, 1, 0, 0, 0, 1704, 1705, 6, 194, 19, 0, 1705, 1706, 6, 194, 17, 0, 1706, 1707, 6, 194, 4, 0, 1707, 407, 1, 0, 0, 0, 1708, 1709, 7, 22, 0, 0, 1709, 1710, 7, 17, 0, 0, 1710, 1711, 7, 10, 0, 0, 1711, 1712, 7, 5, 0, 0, 1712, 1713, 7, 6, 0, 0, 1713, 1714, 1, 0, 0, 0, 1714, 1715, 6, 195, 17, 0, 1715, 1716, 6, 195, 4, 0, 1716, 409, 1, 0, 0, 0, 1717, 1718, 3, 332, 157, 0, 1718, 1719, 1, 0, 0, 0, 1719, 1720, 6, 196, 42, 0, 1720, 411, 1, 0, 0, 0, 1721, 1722, 3, 204, 93, 0, 1722, 1723, 1, 0, 0, 0, 1723, 1724, 6, 197, 30, 0, 1724, 413, 1, 0, 0, 0, 1725, 1726, 3, 220, 101, 0, 1726, 1727, 1, 0, 0, 0, 1727, 1728, 6, 198, 40, 0, 1728, 415, 1, 0, 0, 0, 1729, 1730, 3, 18, 0, 0, 1730, 1731, 1, 0, 0, 0, 1731, 1732, 6, 199, 0, 0, 1732, 417, 1, 0, 0, 0, 1733, 1734, 3, 20, 1, 0, 1734, 1735, 1, 0, 0, 0, 1735, 1736, 6, 200, 0, 0, 1736, 419, 1, 0, 0, 0, 1737, 1738, 3, 22, 2, 0, 1738, 1739, 1, 0, 0, 0, 1739, 1740, 6, 201, 0, 0, 1740, 421, 1, 0, 0, 0, 1741, 1742, 3, 182, 82, 0, 1742, 1743, 1, 0, 0, 0, 1743, 1744, 6, 202, 16, 0, 1744, 1745, 6, 202, 17, 0, 1745, 423, 1, 0, 0, 0, 1746, 1747, 3, 302, 142, 0, 1747, 1748, 1, 0, 0, 0, 1748, 1749, 6, 203, 18, 0, 1749, 1750, 6, 203, 17, 0, 1750, 1751, 6, 203, 17, 0, 1751, 425, 1, 0, 0, 0, 1752, 1753, 3, 220, 101, 0, 1753, 1754, 1, 0, 0, 0, 1754, 1755, 6, 204, 40, 0, 1755, 427, 1, 0, 0, 0, 1756, 1757, 3, 224, 103, 0, 1757, 1758, 1, 0, 0, 0, 1758, 1759, 6, 205, 22, 0, 1759, 429, 1, 0, 0, 0, 1760, 1761, 3, 228, 105, 0, 1761, 1762, 1, 0, 0, 0, 1762, 1763, 6, 206, 21, 0, 1763, 431, 1, 0, 0, 0, 1764, 1765, 3, 248, 115, 0, 1765, 1766, 1, 0, 0, 0, 1766, 1767, 6, 207, 19, 0, 1767, 1768, 6, 207, 44, 0, 1768, 433, 1, 0, 0, 0, 1769, 1770, 3, 332, 157, 0, 1770, 1771, 1, 0, 0, 0, 1771, 1772, 6, 208, 42, 0, 1772, 435, 1, 0, 0, 0, 1773, 1774, 3, 204, 93, 0, 1774, 1775, 1, 0, 0, 0, 1775, 1776, 6, 209, 30, 0, 1776, 437, 1, 0, 0, 0, 1777, 1778, 3, 18, 0, 0, 1778, 1779, 1, 0, 0, 0, 1779, 1780, 6, 210, 0, 0, 1780, 439, 1, 0, 0, 0, 1781, 1782, 3, 20, 1, 0, 1782, 1783, 1, 0, 0, 0, 1783, 1784, 6, 211, 0, 0, 1784, 441, 1, 0, 0, 0, 1785, 1786, 3, 22, 2, 0, 1786, 1787, 1, 0, 0, 0, 1787, 1788, 6, 212, 0, 0, 1788, 443, 1, 0, 0, 0, 1789, 1790, 3, 182, 82, 0, 1790, 1791, 1, 0, 0, 0, 1791, 1792, 6, 213, 16, 0, 1792, 1793, 6, 213, 17, 0, 1793, 1794, 6, 213, 17, 0, 1794, 445, 1, 0, 0, 0, 1795, 1796, 3, 302, 142, 0, 1796, 1797, 1, 0, 0, 0, 1797, 1798, 6, 214, 18, 0, 1798, 1799, 6, 214, 17, 0, 1799, 1800, 6, 214, 17, 0, 1800, 1801, 6, 214, 17, 0, 1801, 447, 1, 0, 0, 0, 1802, 1803, 3, 224, 103, 0, 1803, 1804, 1, 0, 0, 0, 1804, 1805, 6, 215, 22, 0, 1805, 449, 1, 0, 0, 0, 1806, 1807, 3, 228, 105, 0, 1807, 1808, 1, 0, 0, 0, 1808, 1809, 6, 216, 21, 0, 1809, 451, 1, 0, 0, 0, 1810, 1811, 3, 512, 247, 0, 1811, 1812, 1, 0, 0, 0, 1812, 1813, 6, 217, 32, 0, 1813, 453, 1, 0, 0, 0, 1814, 1815, 3, 18, 0, 0, 1815, 1816, 1, 0, 0, 0, 1816, 1817, 6, 218, 0, 0, 1817, 455, 1, 0, 0, 0, 1818, 1819, 3, 20, 1, 0, 1819, 1820, 1, 0, 0, 0, 1820, 1821, 6, 219, 0, 0, 1821, 457, 1, 0, 0, 0, 1822, 1823, 3, 22, 2, 0, 1823, 1824, 1, 0, 0, 0, 1824, 1825, 6, 220, 0, 0, 1825, 459, 1, 0, 0, 0, 1826, 1827, 3, 182, 82, 0, 1827, 1828, 1, 0, 0, 0, 1828, 1829, 6, 221, 16, 0, 1829, 1830, 6, 221, 17, 0, 1830, 461, 1, 0, 0, 0, 1831, 1832, 3, 302, 142, 0, 1832, 1833, 1, 0, 0, 0, 1833, 1834, 6, 222, 18, 0, 1834, 1835, 6, 222, 17, 0, 1835, 1836, 6, 222, 17, 0, 1836, 463, 1, 0, 0, 0, 1837, 1838, 3, 296, 139, 0, 1838, 1839, 1, 0, 0, 0, 1839, 1840, 6, 223, 23, 0, 1840, 465, 1, 0, 0, 0, 1841, 1842, 3, 298, 140, 0, 1842, 1843, 1, 0, 0, 0, 1843, 1844, 6, 224, 24, 0, 1844, 467, 1, 0, 0, 0, 1845, 1846, 3, 228, 105, 0, 1846, 1847, 1, 0, 0, 0, 1847, 1848, 6, 225, 21, 0, 1848, 469, 1, 0, 0, 0, 1849, 1850, 3, 252, 117, 0, 1850, 1851, 1, 0, 0, 0, 1851, 1852, 6, 226, 33, 0, 1852, 471, 1, 0, 0, 0, 1853, 1854, 3, 292, 137, 0, 1854, 1855, 1, 0, 0, 0, 1855, 1856, 6, 227, 34, 0, 1856, 473, 1, 0, 0, 0, 1857, 1858, 3, 288, 135, 0, 1858, 1859, 1, 0, 0, 0, 1859, 1860, 6, 228, 35, 0, 1860, 475, 1, 0, 0, 0, 1861, 1862, 3, 294, 138, 0, 1862, 1863, 1, 0, 0, 0, 1863, 1864, 6, 229, 36, 0, 1864, 477, 1, 0, 0, 0, 1865, 1866, 3, 308, 145, 0, 1866, 1867, 1, 0, 0, 0, 1867, 1868, 6, 230, 25, 0, 1868, 479, 1, 0, 0, 0, 1869, 1870, 3, 304, 143, 0, 1870, 1871, 1, 0, 0, 0, 1871, 1872, 6, 231, 26, 0, 1872, 481, 1, 0, 0, 0, 1873, 1874, 3, 18, 0, 0, 1874, 1875, 1, 0, 0, 0, 1875, 1876, 6, 232, 0, 0, 1876, 483, 1, 0, 0, 0, 1877, 1878, 3, 20, 1, 0, 1878, 1879, 1, 0, 0, 0, 1879, 1880, 6, 233, 0, 0, 1880, 485, 1, 0, 0, 0, 1881, 1882, 3, 22, 2, 0, 1882, 1883, 1, 0, 0, 0, 1883, 1884, 6, 234, 0, 0, 1884, 487, 1, 0, 0, 0, 1885, 1886, 3, 182, 82, 0, 1886, 1887, 1, 0, 0, 0, 1887, 1888, 6, 235, 16, 0, 1888, 1889, 6, 235, 17, 0, 1889, 489, 1, 0, 0, 0, 1890, 1891, 3, 302, 142, 0, 1891, 1892, 1, 0, 0, 0, 1892, 1893, 6, 236, 18, 0, 1893, 1894, 6, 236, 17, 0, 1894, 1895, 6, 236, 17, 0, 1895, 491, 1, 0, 0, 0, 1896, 1897, 3, 228, 105, 0, 1897, 1898, 1, 0, 0, 0, 1898, 1899, 6, 237, 21, 0, 1899, 493, 1, 0, 0, 0, 1900, 1901, 3, 296, 139, 0, 1901, 1902, 1, 0, 0, 0, 1902, 1903, 6, 238, 23, 0, 1903, 495, 1, 0, 0, 0, 1904, 1905, 3, 298, 140, 0, 1905, 1906, 1, 0, 0, 0, 1906, 1907, 6, 239, 24, 0, 1907, 497, 1, 0, 0, 0, 1908, 1909, 3, 224, 103, 0, 1909, 1910, 1, 0, 0, 0, 1910, 1911, 6, 240, 22, 0, 1911, 499, 1, 0, 0, 0, 1912, 1913, 3, 252, 117, 0, 1913, 1914, 1, 0, 0, 0, 1914, 1915, 6, 241, 33, 0, 1915, 501, 1, 0, 0, 0, 1916, 1917, 3, 292, 137, 0, 1917, 1918, 1, 0, 0, 0, 1918, 1919, 6, 242, 34, 0, 1919, 503, 1, 0, 0, 0, 1920, 1921, 3, 288, 135, 0, 1921, 1922, 1, 0, 0, 0, 1922, 1923, 6, 243, 35, 0, 1923, 505, 1, 0, 0, 0, 1924, 1925, 3, 294, 138, 0, 1925, 1926, 1, 0, 0, 0, 1926, 1927, 6, 244, 36, 0, 1927, 507, 1, 0, 0, 0, 1928, 1933, 3, 186, 84, 0, 1929, 1933, 3, 184, 83, 0, 1930, 1933, 3, 200, 91, 0, 1931, 1933, 3, 278, 130, 0, 1932, 1928, 1, 0, 0, 0, 1932, 1929, 1, 0, 0, 0, 1932, 1930, 1, 0, 0, 0, 1932, 1931, 1, 0, 0, 0, 1933, 509, 1, 0, 0, 0, 1934, 1937, 3, 186, 84, 0, 1935, 1937, 3, 278, 130, 0, 1936, 1934, 1, 0, 0, 0, 1936, 1935, 1, 0, 0, 0, 1937, 1941, 1, 0, 0, 0, 1938, 1940, 3, 508, 245, 0, 1939, 1938, 1, 0, 0, 0, 1940, 1943, 1, 0, 0, 0, 1941, 1939, 1, 0, 0, 0, 1941, 1942, 1, 0, 0, 0, 1942, 1954, 1, 0, 0, 0, 1943, 1941, 1, 0, 0, 0, 1944, 1947, 3, 200, 91, 0, 1945, 1947, 3, 194, 88, 0, 1946, 1944, 1, 0, 0, 0, 1946, 1945, 1, 0, 0, 0, 1947, 1949, 1, 0, 0, 0, 1948, 1950, 3, 508, 245, 0, 1949, 1948, 1, 0, 0, 0, 1950, 1951, 1, 0, 0, 0, 1951, 1949, 1, 0, 0, 0, 1951, 1952, 1, 0, 0, 0, 1952, 1954, 1, 0, 0, 0, 1953, 1936, 1, 0, 0, 0, 1953, 1946, 1, 0, 0, 0, 1954, 511, 1, 0, 0, 0, 1955, 1958, 3, 510, 246, 0, 1956, 1958, 3, 306, 144, 0, 1957, 1955, 1, 0, 0, 0, 1957, 1956, 1, 0, 0, 0, 1958, 1959, 1, 0, 0, 0, 1959, 1957, 1, 0, 0, 0, 1959, 1960, 1, 0, 0, 0, 1960, 513, 1, 0, 0, 0, 1961, 1962, 3, 18, 0, 0, 1962, 1963, 1, 0, 0, 0, 1963, 1964, 6, 248, 0, 0, 1964, 515, 1, 0, 0, 0, 1965, 1966, 3, 20, 1, 0, 1966, 1967, 1, 0, 0, 0, 1967, 1968, 6, 249, 0, 0, 1968, 517, 1, 0, 0, 0, 1969, 1970, 3, 22, 2, 0, 1970, 1971, 1, 0, 0, 0, 1971, 1972, 6, 250, 0, 0, 1972, 519, 1, 0, 0, 0, 1973, 1974, 3, 182, 82, 0, 1974, 1975, 1, 0, 0, 0, 1975, 1976, 6, 251, 16, 0, 1976, 1977, 6, 251, 17, 0, 1977, 521, 1, 0, 0, 0, 1978, 1979, 3, 302, 142, 0, 1979, 1980, 1, 0, 0, 0, 1980, 1981, 6, 252, 18, 0, 1981, 1982, 6, 252, 17, 0, 1982, 1983, 6, 252, 17, 0, 1983, 523, 1, 0, 0, 0, 1984, 1985, 3, 296, 139, 0, 1985, 1986, 1, 0, 0, 0, 1986, 1987, 6, 253, 23, 0, 1987, 525, 1, 0, 0, 0, 1988, 1989, 3, 298, 140, 0, 1989, 1990, 1, 0, 0, 0, 1990, 1991, 6, 254, 24, 0, 1991, 527, 1, 0, 0, 0, 1992, 1993, 3, 214, 98, 0, 1993, 1994, 1, 0, 0, 0, 1994, 1995, 6, 255, 31, 0, 1995, 529, 1, 0, 0, 0, 1996, 1997, 3, 224, 103, 0, 1997, 1998, 1, 0, 0, 0, 1998, 1999, 6, 256, 22, 0, 1999, 531, 1, 0, 0, 0, 2000, 2001, 3, 228, 105, 0, 2001, 2002, 1, 0, 0, 0, 2002, 2003, 6, 257, 21, 0, 2003, 533, 1, 0, 0, 0, 2004, 2005, 3, 252, 117, 0, 2005, 2006, 1, 0, 0, 0, 2006, 2007, 6, 258, 33, 0, 2007, 535, 1, 0, 0, 0, 2008, 2009, 3, 292, 137, 0, 2009, 2010, 1, 0, 0, 0, 2010, 2011, 6, 259, 34, 0, 2011, 537, 1, 0, 0, 0, 2012, 2013, 3, 288, 135, 0, 2013, 2014, 1, 0, 0, 0, 2014, 2015, 6, 260, 35, 0, 2015, 539, 1, 0, 0, 0, 2016, 2017, 3, 294, 138, 0, 2017, 2018, 1, 0, 0, 0, 2018, 2019, 6, 261, 36, 0, 2019, 541, 1, 0, 0, 0, 2020, 2021, 7, 4, 0, 0, 2021, 2022, 7, 17, 0, 0, 2022, 543, 1, 0, 0, 0, 2023, 2024, 3, 512, 247, 0, 2024, 2025, 1, 0, 0, 0, 2025, 2026, 6, 263, 32, 0, 2026, 545, 1, 0, 0, 0, 2027, 2028, 3, 18, 0, 0, 2028, 2029, 1, 0, 0, 0, 2029, 2030, 6, 264, 0, 0, 2030, 547, 1, 0, 0, 0, 2031, 2032, 3, 20, 1, 0, 2032, 2033, 1, 0, 0, 0, 2033, 2034, 6, 265, 0, 0, 2034, 549, 1, 0, 0, 0, 2035, 2036, 3, 22, 2, 0, 2036, 2037, 1, 0, 0, 0, 2037, 2038, 6, 266, 0, 0, 2038, 551, 1, 0, 0, 0, 2039, 2040, 3, 256, 119, 0, 2040, 2041, 1, 0, 0, 0, 2041, 2042, 6, 267, 45, 0, 2042, 553, 1, 0, 0, 0, 2043, 2044, 3, 230, 106, 0, 2044, 2045, 1, 0, 0, 0, 2045, 2046, 6, 268, 46, 0, 2046, 555, 1, 0, 0, 0, 2047, 2048, 3, 244, 113, 0, 2048, 2049, 1, 0, 0, 0, 2049, 2050, 6, 269, 47, 0, 2050, 557, 1, 0, 0, 0, 2051, 2052, 3, 222, 102, 0, 2052, 2053, 1, 0, 0, 0, 2053, 2054, 6, 270, 48, 0, 2054, 2055, 6, 270, 17, 0, 2055, 559, 1, 0, 0, 0, 2056, 2057, 3, 214, 98, 0, 2057, 2058, 1, 0, 0, 0, 2058, 2059, 6, 271, 31, 0, 2059, 561, 1, 0, 0, 0, 2060, 2061, 3, 204, 93, 0, 2061, 2062, 1, 0, 0, 0, 2062, 2063, 6, 272, 30, 0, 2063, 563, 1, 0, 0, 0, 2064, 2065, 3, 304, 143, 0, 2065, 2066, 1, 0, 0, 0, 2066, 2067, 6, 273, 26, 0, 2067, 565, 1, 0, 0, 0, 2068, 2069, 3, 308, 145, 0, 2069, 2070, 1, 0, 0, 0, 2070, 2071, 6, 274, 25, 0, 2071, 567, 1, 0, 0, 0, 2072, 2073, 3, 208, 95, 0, 2073, 2074, 1, 0, 0, 0, 2074, 2075, 6, 275, 49, 0, 2075, 569, 1, 0, 0, 0, 2076, 2077, 3, 206, 94, 0, 2077, 2078, 1, 0, 0, 0, 2078, 2079, 6, 276, 50, 0, 2079, 571, 1, 0, 0, 0, 2080, 2081, 3, 224, 103, 0, 2081, 2082, 1, 0, 0, 0, 2082, 2083, 6, 277, 22, 0, 2083, 573, 1, 0, 0, 0, 2084, 2085, 3, 228, 105, 0, 2085, 2086, 1, 0, 0, 0, 2086, 2087, 6, 278, 21, 0, 2087, 575, 1, 0, 0, 0, 2088, 2089, 3, 252, 117, 0, 2089, 2090, 1, 0, 0, 0, 2090, 2091, 6, 279, 33, 0, 2091, 577, 1, 0, 0, 0, 2092, 2093, 3, 292, 137, 0, 2093, 2094, 1, 0, 0, 0, 2094, 2095, 6, 280, 34, 0, 2095, 579, 1, 0, 0, 0, 2096, 2097, 3, 288, 135, 0, 2097, 2098, 1, 0, 0, 0, 2098, 2099, 6, 281, 35, 0, 2099, 581, 1, 0, 0, 0, 2100, 2101, 3, 294, 138, 0, 2101, 2102, 1, 0, 0, 0, 2102, 2103, 6, 282, 36, 0, 2103, 583, 1, 0, 0, 0, 2104, 2105, 3, 296, 139, 0, 2105, 2106, 1, 0, 0, 0, 2106, 2107, 6, 283, 23, 0, 2107, 585, 1, 0, 0, 0, 2108, 2109, 3, 298, 140, 0, 2109, 2110, 1, 0, 0, 0, 2110, 2111, 6, 284, 24, 0, 2111, 587, 1, 0, 0, 0, 2112, 2113, 3, 512, 247, 0, 2113, 2114, 1, 0, 0, 0, 2114, 2115, 6, 285, 32, 0, 2115, 589, 1, 0, 0, 0, 2116, 2117, 3, 18, 0, 0, 2117, 2118, 1, 0, 0, 0, 2118, 2119, 6, 286, 0, 0, 2119, 591, 1, 0, 0, 0, 2120, 2121, 3, 20, 1, 0, 2121, 2122, 1, 0, 0, 0, 2122, 2123, 6, 287, 0, 0, 2123, 593, 1, 0, 0, 0, 2124, 2125, 3, 22, 2, 0, 2125, 2126, 1, 0, 0, 0, 2126, 2127, 6, 288, 0, 0, 2127, 595, 1, 0, 0, 0, 2128, 2129, 3, 182, 82, 0, 2129, 2130, 1, 0, 0, 0, 2130, 2131, 6, 289, 16, 0, 2131, 2132, 6, 289, 17, 0, 2132, 597, 1, 0, 0, 0, 2133, 2134, 7, 10, 0, 0, 2134, 2135, 7, 5, 0, 0, 2135, 2136, 7, 21, 0, 0, 2136, 2137, 7, 9, 0, 0, 2137, 599, 1, 0, 0, 0, 2138, 2139, 3, 18, 0, 0, 2139, 2140, 1, 0, 0, 0, 2140, 2141, 6, 291, 0, 0, 2141, 601, 1, 0, 0, 0, 2142, 2143, 3, 20, 1, 0, 2143, 2144, 1, 0, 0, 0, 2144, 2145, 6, 292, 0, 0, 2145, 603, 1, 0, 0, 0, 2146, 2147, 3, 22, 2, 0, 2147, 2148, 1, 0, 0, 0, 2148, 2149, 6, 293, 0, 0, 2149, 605, 1, 0, 0, 0, 70, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 612, 616, 619, 628, 630, 641, 930, 1015, 1019, 1024, 1156, 1161, 1170, 1177, 1182, 1184, 1195, 1203, 1206, 1208, 1213, 1218, 1224, 1231, 1236, 1242, 1245, 1253, 1257, 1398, 1403, 1410, 1412, 1417, 1422, 1429, 1431, 1457, 1462, 1467, 1469, 1475, 1531, 1536, 1932, 1936, 1941, 1946, 1951, 1953, 1957, 1959, 51, 0, 1, 0, 5, 1, 0, 5, 2, 0, 5, 4, 0, 5, 5, 0, 5, 6, 0, 5, 7, 0, 5, 8, 0, 5, 9, 0, 5, 10, 0, 5, 11, 0, 5, 13, 0, 5, 14, 0, 5, 15, 0, 5, 16, 0, 5, 17, 0, 7, 50, 0, 4, 0, 0, 7, 99, 0, 7, 73, 0, 7, 141, 0, 7, 63, 0, 7, 61, 0, 7, 96, 0, 7, 97, 0, 7, 101, 0, 7, 100, 0, 5, 3, 0, 7, 78, 0, 7, 40, 0, 7, 51, 0, 7, 56, 0, 7, 137, 0, 7, 75, 0, 7, 94, 0, 7, 93, 0, 7, 95, 0, 7, 98, 0, 5, 0, 0, 7, 17, 0, 7, 59, 0, 7, 58, 0, 7, 106, 0, 7, 57, 0, 5, 12, 0, 7, 77, 0, 7, 64, 0, 7, 71, 0, 7, 60, 0, 7, 53, 0, 7, 52, 0]);
(0, _defineProperty2.default)(esql_lexer, "__ATN", void 0);
(0, _defineProperty2.default)(esql_lexer, "DecisionsToDFA", _esql_lexer._ATN.decisionToState.map((ds, index) => new _antlr.DFA(ds, index)));
module.exports = exports.default;