"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityDefinitionUpdateSchema = exports.entityDefinitionSchema = void 0;
var _zod = require("@kbn/zod");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityDefinitionSchema = exports.entityDefinitionSchema = _zod.z.object({
  id: _zod.z.string().regex(/^[\w-]+$/),
  version: _common.semVerSchema,
  name: _zod.z.string(),
  description: _zod.z.optional(_zod.z.string()),
  type: _zod.z.string(),
  filter: _common.filterSchema,
  indexPatterns: _common.arrayOfStringsSchema,
  identityFields: _zod.z.array(_common.identityFieldsSchema),
  capabilities: _zod.z.optional(_zod.z.array(_common.capabilitySchema)),
  displayNameTemplate: _zod.z.string(),
  metadata: _zod.z.optional(_zod.z.array(_common.metadataSchema)),
  metrics: _zod.z.optional(_zod.z.array(_common.keyMetricSchema)),
  staticFields: _zod.z.optional(_zod.z.record(_zod.z.string(), _zod.z.string())),
  managed: _zod.z.optional(_zod.z.boolean()).default(false),
  latest: _zod.z.object({
    timestampField: _zod.z.string(),
    lookbackPeriod: _zod.z.optional(_common.durationSchema).default('24h'),
    settings: _zod.z.optional(_zod.z.object({
      syncField: _zod.z.optional(_zod.z.string()),
      syncDelay: _zod.z.optional(_common.durationSchema),
      frequency: _zod.z.optional(_common.durationSchema),
      timeout: _zod.z.optional(_common.durationSchema),
      docsPerSecond: _zod.z.optional(_zod.z.number()),
      maxPageSearchSize: _zod.z.optional(_zod.z.number())
    }))
  }),
  installStatus: _zod.z.optional(_zod.z.union([_zod.z.literal('installing'), _zod.z.literal('upgrading'), _zod.z.literal('installed'), _zod.z.literal('failed')])),
  installStartedAt: _zod.z.optional(_zod.z.string()),
  installedComponents: _zod.z.optional(_zod.z.array(_zod.z.object({
    type: _zod.z.union([_zod.z.literal('transform'), _zod.z.literal('ingest_pipeline'), _zod.z.literal('template'), _zod.z.literal('ilm_policy')]),
    id: _zod.z.string()
  })))
});
const entityDefinitionUpdateSchema = exports.entityDefinitionUpdateSchema = entityDefinitionSchema.omit({
  id: true,
  managed: true,
  installStatus: true,
  installStartedAt: true
}).partial().merge(_zod.z.object({
  latest: _zod.z.optional(entityDefinitionSchema.shape.latest.partial()),
  version: _common.semVerSchema
}));