"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomPipeline = exports.CreateCustomPipelineApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCustomPipeline = async ({
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/pipelines`;
  const result = await _http.HttpLogic.values.http.post(route);
  return result;
};
exports.createCustomPipeline = createCustomPipeline;
const CreateCustomPipelineApiLogic = exports.CreateCustomPipelineApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'create_custom_pipeline_api_logic'], createCustomPipeline, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.successToastCustom.title', {
    defaultMessage: 'Custom pipeline created'
  })
});