"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDefaultPipeline = exports.UpdateDefaultPipelineApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateDefaultPipeline = async pipeline => {
  const route = '/internal/enterprise_search/connectors/default_pipeline';
  await _http.HttpLogic.values.http.put(route, {
    body: JSON.stringify(pipeline)
  });
  return pipeline;
};
exports.updateDefaultPipeline = updateDefaultPipeline;
const UpdateDefaultPipelineApiLogic = exports.UpdateDefaultPipelineApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'update_default_pipeline_api_logic'], updateDefaultPipeline, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.defaultPipelines.successToast.title', {
    defaultMessage: 'Default pipeline successfully updated'
  })
});