"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGenerateOrEndEdge = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGenerateOrEndEdge = logger => {
  const edge = state => {
    logger === null || logger === void 0 ? void 0 : logger.debug(() => '---GENERATE OR END---');
    const {
      anonymizedDocuments
    } = state;
    const hasZeroDocs = !anonymizedDocuments.length;
    const decision = hasZeroDocs ? 'end' : 'generate';
    logger === null || logger === void 0 ? void 0 : logger.debug(() => `generatOrEndEdge evaluated the following (derived) state:\n${JSON.stringify({
      anonymizedDocuments: anonymizedDocuments.length,
      hasZeroDocs
    }, null, 2)}
\n---GENERATE OR END: ${decision}---`);
    return decision;
  };
  return edge;
};
exports.getGenerateOrEndEdge = getGenerateOrEndEdge;