"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEventsForInsightType = getEventsForInsightType;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _file_events = require("./file_events");
var _policy_response_failure_events = require("./policy_response_failure_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getEventsForInsightType(insightType, esClient, options) {
  switch (insightType) {
    case _elasticAssistantCommon.DefendInsightType.Enum.incompatible_antivirus:
      return (0, _file_events.getFileEvents)(esClient, options);
    case _elasticAssistantCommon.DefendInsightType.Enum.policy_response_failure:
      return (0, _policy_response_failure_events.getPolicyResponseFailureEvents)(esClient, options);
    default:
      throw new Error(`Unsupported insight type: ${insightType}`);
  }
}