"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Cursor = void 0;
exports.MessageText = MessageText;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _custom_codeblock_markdown_plugin = require("@kbn/elastic-assistant/impl/get_comments/custom_codeblock/custom_codeblock_markdown_plugin");
var _custom_code_block = require("@kbn/elastic-assistant/impl/get_comments/custom_codeblock/custom_code_block");
var _content_reference_parser = require("../content_reference/content_reference_parser");
var _content_reference_component_factory = require("../content_reference/components/content_reference_component_factory");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/stream/message_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ANIMATION_TIME = 1;
const Cursor = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cursorCss = (0, _react.css)`
    @keyframes blink {
      0% {
        opacity: 0;
      }
      50% {
        opacity: 1;
      }
      100% {
        opacity: 0;
      }
    }

    width: 10px;
    height: 16px;
    vertical-align: middle;
    display: inline-block;
    animation: blink ${ANIMATION_TIME}s infinite;
    background: ${euiTheme.colors.backgroundLightText};
  `;
  return /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "cursor",
    key: "cursor",
    css: cursorCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 10
    }
  });
};

// a weird combination of different whitespace chars to make sure it stays
// invisible even when we cannot properly parse the text while still being
// unique
exports.Cursor = Cursor;
const CURSOR = ` ᠎  `;
const loadingCursorPlugin = () => {
  const visitor = (node, parent) => {
    var _parent$children$inde;
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type !== 'text' && node.type !== 'inlineCode' && node.type !== 'code') {
      return;
    }
    const textNode = node;
    const indexOfCursor = textNode.value.indexOf(CURSOR);
    if (indexOfCursor === -1) {
      return;
    }
    textNode.value = textNode.value.replace(CURSOR, '');
    const indexOfNode = (_parent$children$inde = parent === null || parent === void 0 ? void 0 : parent.children.indexOf(textNode)) !== null && _parent$children$inde !== void 0 ? _parent$children$inde : 0;
    parent === null || parent === void 0 ? void 0 : parent.children.splice(indexOfNode + 1, 0, {
      type: 'cursor',
      value: CURSOR
    });
  };
  return tree => {
    visitor(tree);
  };
};
const getPluginDependencies = ({
  contentReferences,
  contentReferencesVisible,
  contentReferencesDisabled
}) => {
  const parsingPlugins = (0, _eui.getDefaultEuiMarkdownParsingPlugins)();
  const processingPlugins = (0, _eui.getDefaultEuiMarkdownProcessingPlugins)();
  const {
    components
  } = processingPlugins[1][1];
  processingPlugins[1][1].components = {
    ...components,
    contentReference: contentReferenceNode => {
      return /*#__PURE__*/_react2.default.createElement(_content_reference_component_factory.ContentReferenceComponentFactory, {
        contentReferencesVisible: contentReferencesVisible,
        contentReferenceNode: contentReferenceNode,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 9
        }
      });
    },
    cursor: Cursor,
    customCodeBlock: props => {
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_custom_code_block.CustomCodeBlock, {
        value: props.value,
        lang: props.lang,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 11
        }
      }));
    },
    table: props => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTable, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    })),
    th: props => {
      const {
        children,
        ...rest
      } = props;
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiTableHeaderCell, (0, _extends2.default)({}, rest, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 14
        }
      }), children);
    },
    tr: props => /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRow, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 20
      }
    })),
    td: props => {
      const {
        children,
        ...rest
      } = props;
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiTableRowCell, (0, _extends2.default)({
        truncateText: true
      }, rest, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 9
        }
      }), children);
    }
  };
  return {
    parsingPluginList: [loadingCursorPlugin, _custom_codeblock_markdown_plugin.customCodeBlockLanguagePlugin, ...parsingPlugins, ...(!contentReferencesDisabled ? [(0, _content_reference_parser.contentReferenceParser)({
      contentReferences
    })] : [])],
    processingPluginList: processingPlugins
  };
};
function MessageText({
  loading,
  content,
  contentReferences,
  contentReferencesVisible,
  contentReferencesDisabled,
  index,
  'data-test-subj': dataTestSubj
}) {
  const containerCss = (0, _react.css)`
    overflow-wrap: anywhere;
  `;
  const {
    parsingPluginList,
    processingPluginList
  } = (0, _react2.useMemo)(() => getPluginDependencies({
    contentReferences,
    contentReferencesVisible,
    contentReferencesDisabled
  }), [contentReferences, contentReferencesVisible, contentReferencesDisabled]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: containerCss,
    "data-test-subj": dataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiMarkdownFormat
  // used by augmentMessageCodeBlocks
  , {
    className: `message-${index}`,
    "data-test-subj": 'messageText',
    parsingPluginList: parsingPluginList,
    processingPluginList: processingPluginList,
    textSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }, `${content}${loading ? CURSOR : ''}`));
}