"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_ANONYMIZATION_FIELDS_URL = exports.POST_ACTIONS_CONNECTOR_EXECUTE = exports.INFERENCE_CHAT_MODEL_DISABLED_FEATURE_FLAG = exports.ELASTIC_USERS_SUGGEST_URL = exports.ELASTIC_AI_ASSISTANT_URL = exports.ELASTIC_AI_ASSISTANT_SECURITY_AI_PROMPTS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_SECURITY_AI_PROMPTS_URL = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_FIND = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BY_ID = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL = exports.ELASTIC_AI_ASSISTANT_INTERNAL_URL = exports.ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL = exports.ELASTIC_AI_ASSISTANT_EVALUATE_URL = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID_MESSAGES = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL = exports.ELASTIC_AI_ASSISTANT_CHECKPOINT_SAVER_ENABLED_FEATURE_FLAG = exports.ELASTIC_AI_ASSISTANT_CHAT_COMPLETE_URL = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL = exports.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_FIND = exports.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL = exports.DEFEND_INSIGHTS_ID = exports.DEFEND_INSIGHTS_BY_ID = exports.DEFEND_INSIGHTS = exports.ATTACK_DISCOVERY_SCHEDULES_FIND = exports.ATTACK_DISCOVERY_SCHEDULES_CONSUMER_ID = exports.ATTACK_DISCOVERY_SCHEDULES_BY_ID_ENABLE = exports.ATTACK_DISCOVERY_SCHEDULES_BY_ID_DISABLE = exports.ATTACK_DISCOVERY_SCHEDULES_BY_ID = exports.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID = exports.ATTACK_DISCOVERY_SCHEDULES = exports.ATTACK_DISCOVERY_PUBLIC_API_ENABLED_FEATURE_FLAG = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_FIND = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID_ENABLE = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID_DISABLE = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES = exports.ATTACK_DISCOVERY_INTERNAL_GENERATIONS_BY_ID_DISMISS = exports.ATTACK_DISCOVERY_INTERNAL_GENERATIONS_BY_ID = exports.ATTACK_DISCOVERY_INTERNAL_FIND = exports.ATTACK_DISCOVERY_INTERNAL_BULK = exports.ATTACK_DISCOVERY_INTERNAL = exports.ATTACK_DISCOVERY_GENERATIONS_INTERNAL = exports.ATTACK_DISCOVERY_GENERATIONS_BY_ID_DISMISS = exports.ATTACK_DISCOVERY_GENERATIONS_BY_ID = exports.ATTACK_DISCOVERY_GENERATIONS = exports.ATTACK_DISCOVERY_GENERATE = exports.ATTACK_DISCOVERY_FIND = exports.ATTACK_DISCOVERY_BULK = exports.ATTACK_DISCOVERY_ALERTS_COMMON_INDEX_PREFIX = exports.ATTACK_DISCOVERY_AD_HOC_RULE_TYPE_ID = exports.ATTACK_DISCOVERY_AD_HOC_RULE_ID = exports.ATTACK_DISCOVERY = exports.ASSISTANT_INTERRUPTS_ENABLED_FEATURE_FLAG = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ELASTIC_AI_ASSISTANT_URL = exports.ELASTIC_AI_ASSISTANT_URL = '/api/security_ai_assistant';
const ELASTIC_AI_ASSISTANT_INTERNAL_URL = exports.ELASTIC_AI_ASSISTANT_INTERNAL_URL = '/internal/elastic_assistant';
const UPDATE_ANONYMIZATION_FIELDS_URL = exports.UPDATE_ANONYMIZATION_FIELDS_URL = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/update_anonymization_fields`;
const POST_ACTIONS_CONNECTOR_EXECUTE = exports.POST_ACTIONS_CONNECTOR_EXECUTE = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/actions/connector/{connectorId}/_execute`;
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL = `${ELASTIC_AI_ASSISTANT_URL}/current_user/conversations`;
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID = `${ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL}/{id}`;
const ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL = exports.ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/current_user/conversations`;
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID_MESSAGES = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID_MESSAGES = `${ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL}/{id}/messages`;
const ELASTIC_AI_ASSISTANT_CHAT_COMPLETE_URL = exports.ELASTIC_AI_ASSISTANT_CHAT_COMPLETE_URL = `${ELASTIC_AI_ASSISTANT_URL}/chat/complete`;
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BULK_ACTION = `${ELASTIC_AI_ASSISTANT_INTERNAL_CONVERSATIONS_URL}/_bulk_action`;
const ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_FIND = `${ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL}/_find`;
const ELASTIC_AI_ASSISTANT_PROMPTS_URL = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL = `${ELASTIC_AI_ASSISTANT_URL}/prompts`;
const ELASTIC_AI_ASSISTANT_PROMPTS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL_BULK_ACTION = `${ELASTIC_AI_ASSISTANT_PROMPTS_URL}/_bulk_action`;
const ELASTIC_AI_ASSISTANT_PROMPTS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_PROMPTS_URL_FIND = `${ELASTIC_AI_ASSISTANT_PROMPTS_URL}/_find`;
const ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL = `${ELASTIC_AI_ASSISTANT_URL}/anonymization_fields`;
const ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_BULK_ACTION = `${ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL}/_bulk_action`;
const ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL_FIND = `${ELASTIC_AI_ASSISTANT_ANONYMIZATION_FIELDS_URL}/_find`;

// TODO: Update existing 'status' endpoint to take resource as query param as to not conflict with 'entries'
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_URL = `${ELASTIC_AI_ASSISTANT_URL}/knowledge_base/{resource?}`;
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL = `${ELASTIC_AI_ASSISTANT_URL}/knowledge_base/entries`;
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BY_ID = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BY_ID = `${ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL}/{id}`;
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_FIND = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_FIND = `${ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL}/_find`;
const ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_BULK_ACTION = `${ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL}/_bulk_action`;
const ELASTIC_AI_ASSISTANT_EVALUATE_URL = exports.ELASTIC_AI_ASSISTANT_EVALUATE_URL = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/evaluate`;

// Alert summary
const ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL = exports.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/alert_summary`;
const ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_BULK_ACTION = exports.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_BULK_ACTION = `${ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL}/_bulk_action`;
const ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_FIND = exports.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_FIND = `${ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL}/_find`;

// Security AI Prompts (prompt integration)
const ELASTIC_AI_ASSISTANT_SECURITY_AI_PROMPTS_URL = exports.ELASTIC_AI_ASSISTANT_SECURITY_AI_PROMPTS_URL = `${ELASTIC_AI_ASSISTANT_URL}/security_ai_prompts`;
const ELASTIC_AI_ASSISTANT_SECURITY_AI_PROMPTS_URL_FIND = exports.ELASTIC_AI_ASSISTANT_SECURITY_AI_PROMPTS_URL_FIND = `${ELASTIC_AI_ASSISTANT_SECURITY_AI_PROMPTS_URL}/_find`;

// Users suggest (user profiles)
const ELASTIC_USERS_SUGGEST_URL = exports.ELASTIC_USERS_SUGGEST_URL = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/users/_suggest`;

// Defend insights
const DEFEND_INSIGHTS_ID = exports.DEFEND_INSIGHTS_ID = 'defend-insights';
const DEFEND_INSIGHTS = exports.DEFEND_INSIGHTS = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/defend_insights`;
const DEFEND_INSIGHTS_BY_ID = exports.DEFEND_INSIGHTS_BY_ID = `${DEFEND_INSIGHTS}/{id}`;

// Attack Discovery
const ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID = exports.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID = 'attack-discovery';
const ATTACK_DISCOVERY_SCHEDULES_CONSUMER_ID = exports.ATTACK_DISCOVERY_SCHEDULES_CONSUMER_ID = 'siem';

// Attack discovery public API
const ATTACK_DISCOVERY = exports.ATTACK_DISCOVERY = '/api/attack_discovery';
const ATTACK_DISCOVERY_BULK = exports.ATTACK_DISCOVERY_BULK = `${ATTACK_DISCOVERY}/_bulk`;
const ATTACK_DISCOVERY_FIND = exports.ATTACK_DISCOVERY_FIND = `${ATTACK_DISCOVERY}/_find`;
const ATTACK_DISCOVERY_GENERATE = exports.ATTACK_DISCOVERY_GENERATE = `${ATTACK_DISCOVERY}/_generate`;
const ATTACK_DISCOVERY_GENERATIONS = exports.ATTACK_DISCOVERY_GENERATIONS = `${ATTACK_DISCOVERY}/generations`;
const ATTACK_DISCOVERY_GENERATIONS_BY_ID = exports.ATTACK_DISCOVERY_GENERATIONS_BY_ID = `${ATTACK_DISCOVERY_GENERATIONS}/{execution_uuid}`;
const ATTACK_DISCOVERY_GENERATIONS_BY_ID_DISMISS = exports.ATTACK_DISCOVERY_GENERATIONS_BY_ID_DISMISS = `${ATTACK_DISCOVERY_GENERATIONS_BY_ID}/_dismiss`;
const ATTACK_DISCOVERY_SCHEDULES = exports.ATTACK_DISCOVERY_SCHEDULES = `${ATTACK_DISCOVERY}/schedules`; // <-- create
const ATTACK_DISCOVERY_SCHEDULES_BY_ID = exports.ATTACK_DISCOVERY_SCHEDULES_BY_ID = `${ATTACK_DISCOVERY_SCHEDULES}/{id}`;
const ATTACK_DISCOVERY_SCHEDULES_BY_ID_ENABLE = exports.ATTACK_DISCOVERY_SCHEDULES_BY_ID_ENABLE = `${ATTACK_DISCOVERY_SCHEDULES}/{id}/_enable`;
const ATTACK_DISCOVERY_SCHEDULES_BY_ID_DISABLE = exports.ATTACK_DISCOVERY_SCHEDULES_BY_ID_DISABLE = `${ATTACK_DISCOVERY_SCHEDULES}/{id}/_disable`;
const ATTACK_DISCOVERY_SCHEDULES_FIND = exports.ATTACK_DISCOVERY_SCHEDULES_FIND = `${ATTACK_DISCOVERY_SCHEDULES}/_find`;

// Attack discovery internal API (depreciated)
const ATTACK_DISCOVERY_INTERNAL = exports.ATTACK_DISCOVERY_INTERNAL = `${ELASTIC_AI_ASSISTANT_INTERNAL_URL}/attack_discovery`;
const ATTACK_DISCOVERY_INTERNAL_BULK = exports.ATTACK_DISCOVERY_INTERNAL_BULK = `${ATTACK_DISCOVERY_INTERNAL}/_bulk`;
const ATTACK_DISCOVERY_INTERNAL_FIND = exports.ATTACK_DISCOVERY_INTERNAL_FIND = `${ATTACK_DISCOVERY_INTERNAL}/_find`;
const ATTACK_DISCOVERY_GENERATIONS_INTERNAL = exports.ATTACK_DISCOVERY_GENERATIONS_INTERNAL = `${ATTACK_DISCOVERY_INTERNAL}/generations`;
const ATTACK_DISCOVERY_INTERNAL_GENERATIONS_BY_ID = exports.ATTACK_DISCOVERY_INTERNAL_GENERATIONS_BY_ID = `${ATTACK_DISCOVERY_GENERATIONS_INTERNAL}/{execution_uuid}`;
const ATTACK_DISCOVERY_INTERNAL_GENERATIONS_BY_ID_DISMISS = exports.ATTACK_DISCOVERY_INTERNAL_GENERATIONS_BY_ID_DISMISS = `${ATTACK_DISCOVERY_INTERNAL_GENERATIONS_BY_ID}/_dismiss`;

// Attack discovery internal schedules API (depreciated)
const ATTACK_DISCOVERY_INTERNAL_SCHEDULES = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES = `${ATTACK_DISCOVERY_INTERNAL}/schedules`;
const ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID = `${ATTACK_DISCOVERY_INTERNAL_SCHEDULES}/{id}`;
const ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID_ENABLE = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID_ENABLE = `${ATTACK_DISCOVERY_INTERNAL_SCHEDULES}/{id}/_enable`;
const ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID_DISABLE = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_BY_ID_DISABLE = `${ATTACK_DISCOVERY_INTERNAL_SCHEDULES}/{id}/_disable`;
const ATTACK_DISCOVERY_INTERNAL_SCHEDULES_FIND = exports.ATTACK_DISCOVERY_INTERNAL_SCHEDULES_FIND = `${ATTACK_DISCOVERY_INTERNAL_SCHEDULES}/_find`;

/** A fake `kibana.alert.rule.uuid` for ad hock rules */
const ATTACK_DISCOVERY_AD_HOC_RULE_ID = exports.ATTACK_DISCOVERY_AD_HOC_RULE_ID = 'attack_discovery_ad_hoc_rule_id';

/** A fake `kibana.alert.rule.rule_type_id` for ad hock rules */
const ATTACK_DISCOVERY_AD_HOC_RULE_TYPE_ID = exports.ATTACK_DISCOVERY_AD_HOC_RULE_TYPE_ID = 'attack_discovery_ad_hoc_rule_type_id';

/**
 * This feature flag enables the Attack discoveries public API feature.
 *
 * It may be overridden via the following setting in `kibana.yml` or `kibana.dev.yml`:
 * ```
 * feature_flags.overrides:
 *   securitySolution.attackDiscoveryPublicApiEnabled: true
 * ```
 */
const ATTACK_DISCOVERY_PUBLIC_API_ENABLED_FEATURE_FLAG = exports.ATTACK_DISCOVERY_PUBLIC_API_ENABLED_FEATURE_FLAG = 'securitySolution.attackDiscoveryPublicApiEnabled';

/**
 * The common prefix for all (ad hoc and scheduled) Attack discovery alerts indices
 */
const ATTACK_DISCOVERY_ALERTS_COMMON_INDEX_PREFIX = exports.ATTACK_DISCOVERY_ALERTS_COMMON_INDEX_PREFIX = '.alerts-security.attack.discovery.alerts';

/**
 * This feature flag disables the InferenceChatModel feature.
 *
 * It may be overridden via the following setting in `kibana.yml` or `kibana.dev.yml`:
 * ```
 * feature_flags.overrides:
 *   securitySolution.inferenceChatModelDisabled: true
 * ```
 */
const INFERENCE_CHAT_MODEL_DISABLED_FEATURE_FLAG = exports.INFERENCE_CHAT_MODEL_DISABLED_FEATURE_FLAG = 'securitySolution.inferenceChatModelDisabled';
const ELASTIC_AI_ASSISTANT_CHECKPOINT_SAVER_ENABLED_FEATURE_FLAG = exports.ELASTIC_AI_ASSISTANT_CHECKPOINT_SAVER_ENABLED_FEATURE_FLAG = 'elasticAssistant.checkpointSaverEnabled';
const ASSISTANT_INTERRUPTS_ENABLED_FEATURE_FLAG = exports.ASSISTANT_INTERRUPTS_ENABLED_FEATURE_FLAG = 'securitySolution.assistantInterruptsEnabled';