"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUnsavedChanges = void 0;
var _rxjs = require("rxjs");
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _redux = require("../redux");
var _use_discover_services = require("../../../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useUnsavedChanges = ({
  internalState,
  runtimeStateManager,
  onAppLeave
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const [onChange$] = (0, _react.useState)(() => (0, _rxjs.from)(internalState).pipe((0, _rxjs.map)(state => [(0, _redux.selectAllTabs)(state), state.persistedDiscoverSession]), (0, _rxjs.distinctUntilChanged)(([prevTabs, prevSession], [currTabs, currSession]) => {
    return prevTabs === currTabs && prevSession === currSession;
  }), (0, _rxjs.switchMap)(([allTabs]) => {
    const stateContainerObservables = allTabs.map(tab => (0, _redux.selectTabRuntimeState)(runtimeStateManager, tab.id).stateContainer$);
    return (0, _rxjs.combineLatest)(stateContainerObservables);
  }), (0, _rxjs.switchMap)(allTabStateContainers => {
    const savedSearchObservables = [];
    for (const tabStateContainer of allTabStateContainers) {
      const savedSearch$ = tabStateContainer === null || tabStateContainer === void 0 ? void 0 : tabStateContainer.savedSearchState.getCurrent$();
      if (savedSearch$) {
        savedSearchObservables.push(savedSearch$);
      }
    }
    return (0, _rxjs.combineLatest)(savedSearchObservables);
  })));
  (0, _react.useEffect)(() => {
    const subscription = onChange$.subscribe(() => {
      internalState.dispatch(_redux.internalStateActions.setUnsavedChanges((0, _redux.selectHasUnsavedChanges)(internalState.getState(), {
        runtimeStateManager,
        services
      })));
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [internalState, onChange$, runtimeStateManager, services]);
  (0, _react.useEffect)(() => {
    onAppLeave === null || onAppLeave === void 0 ? void 0 : onAppLeave(actions => {
      const {
        hasUnsavedChanges
      } = internalState.getState();
      if (!hasUnsavedChanges) return actions.default();
      return actions.confirm(_i18n.i18n.translate('discover.confirmModal.confirmTextDescription', {
        defaultMessage: "You'll lose unsaved changes if you open another Discover session before returning to this one."
      }), _i18n.i18n.translate('discover.confirmModal.title', {
        defaultMessage: 'Unsaved changes'
      }), () => {}, _i18n.i18n.translate('discover.confirmModal.confirmText', {
        defaultMessage: 'Leave without saving'
      }), 'danger');
    });
  }, [internalState, onAppLeave]);
};
exports.useUnsavedChanges = useUnsavedChanges;