"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFieldLimitFailedNotifier = exports.updateFailureStoreSuccessNotifier = exports.updateFailureStoreFailedNotifier = exports.rolloverDataStreamFailedNotifier = exports.fetchIntegrationDashboardsFailedNotifier = exports.fetchDataStreamSettingsFailedNotifier = exports.fetchDataStreamIntegrationFailedNotifier = exports.fetchDataStreamDetailsFailedNotifier = exports.assertBreakdownFieldEcsFailedNotifier = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchDataStreamDetailsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.fetchDataStreamDetailsFailed', {
      defaultMessage: "We couldn't get your datastream details."
    }),
    text: error.message
  });
};
exports.fetchDataStreamDetailsFailedNotifier = fetchDataStreamDetailsFailedNotifier;
const assertBreakdownFieldEcsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.checkBreakdownFieldEcsFailed', {
      defaultMessage: "We couldn't retrieve breakdown field metadata."
    }),
    text: error.message
  });
};
exports.assertBreakdownFieldEcsFailedNotifier = assertBreakdownFieldEcsFailedNotifier;
const fetchDataStreamSettingsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.fetchDataStreamSettingsFailed', {
      defaultMessage: "Data stream settings couldn't be loaded."
    }),
    text: error.message
  });
};
exports.fetchDataStreamSettingsFailedNotifier = fetchDataStreamSettingsFailedNotifier;
const fetchIntegrationDashboardsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.fetchIntegrationDashboardsFailed', {
      defaultMessage: "We couldn't get your integration dashboards."
    }),
    text: error.message
  });
};
exports.fetchIntegrationDashboardsFailedNotifier = fetchIntegrationDashboardsFailedNotifier;
const fetchDataStreamIntegrationFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.fetchIntegrationsFailed', {
      defaultMessage: "We couldn't get integration info."
    }),
    text: error.message
  });
};
exports.fetchDataStreamIntegrationFailedNotifier = fetchDataStreamIntegrationFailedNotifier;
const updateFieldLimitFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.updateFieldLimitFailed', {
      defaultMessage: "We couldn't update the field limit."
    }),
    text: error.message
  });
};
exports.updateFieldLimitFailedNotifier = updateFieldLimitFailedNotifier;
const rolloverDataStreamFailedNotifier = (toasts, error, dataStream) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.rolloverDataStreamFailed', {
      defaultMessage: "We couldn't rollover the data stream: {dataStream}.",
      values: {
        dataStream
      }
    }),
    text: error.message
  });
};
exports.rolloverDataStreamFailedNotifier = rolloverDataStreamFailedNotifier;
const updateFailureStoreFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.updateFailureStoreFailed', {
      defaultMessage: "We couldn't update the failure store settings."
    }),
    text: error.message
  });
};
exports.updateFailureStoreFailedNotifier = updateFailureStoreFailedNotifier;
const updateFailureStoreSuccessNotifier = toasts => {
  toasts.addSuccess({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.updateFailureStoreSuccess', {
      defaultMessage: 'Failure store settings saved'
    })
  });
};
exports.updateFailureStoreSuccessNotifier = updateFailureStoreSuccessNotifier;