"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGrokHighlighter = useGrokHighlighter;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana_context = require("../../../../kibana_context");
var _field_badge = require("./field_badge");
var _grok_highlighter = require("./grok_highlighter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/file_contents/use_text_parser.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useGrokHighlighter() {
  const {
    services: {
      http
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const createLines = (0, _react.useMemo)(() => async (text, grokPattern, mappings, ecsCompatibility, multilineStartPattern, excludeLinesPattern) => {
    const grokHighlighter = new _grok_highlighter.GrokHighlighter({
      multilineStartPattern,
      excludeLinesPattern
    }, http);
    const lines = await grokHighlighter.createLines(text, grokPattern, mappings, ecsCompatibility);
    return lines.map(line => {
      const formattedWords = [];
      for (let j = 0; j < line.length; j++) {
        const {
          word,
          field
        } = line[j];
        const key = `word-${j}`;
        if (field) {
          formattedWords.push(/*#__PURE__*/_react.default.createElement(_field_badge.FieldBadge, {
            type: field.type,
            value: word,
            name: field.name,
            key: key,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 49,
              columnNumber: 17
            }
          }));
        } else {
          formattedWords.push(/*#__PURE__*/_react.default.createElement("span", {
            key: key,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 52,
              columnNumber: 35
            }
          }, word));
        }
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        css: {
          lineHeight: euiTheme.size.l
        },
        "data-test-subj": "dataVisualizerHighlightedLine",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("code", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 15
        }
      }, formattedWords));
    });
  }, [euiTheme, http]);
  return createLines;
}