"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStateSelector = useStateSelector;
var _rxjs = require("rxjs");
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function useStateSelector(state$, selector, equalityFn) {
  const memoizedObservable = (0, _react.useMemo)(() => state$.pipe((0, _rxjs.map)(selector), (0, _rxjs.distinctUntilChanged)(equalityFn)), [state$, selector, equalityFn]);
  const defaultValue = (0, _react.useMemo)(() => selector(state$.value), [selector, state$]);
  return (0, _useObservable.default)(memoizedObservable, defaultValue);
}