"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = mountManagementSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPromptNoDataViews = require("@kbn/shared-ux-prompt-no-data-views");
var _components = require("../components");
var _data_view_management_service = require("./data_view_management_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/management_app/mount_management_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const readOnlyBadge = {
  text: _i18n.i18n.translate('indexPatternManagement.indexPatterns.badge.readOnly.text', {
    defaultMessage: 'Read only'
  }),
  tooltip: _i18n.i18n.translate('indexPatternManagement.dataViews.badge.readOnly.tooltip', {
    defaultMessage: 'Unable to save data views'
  }),
  iconType: 'glasses'
};
async function mountManagementSection(getStartServices, {
  noDataPage
}, params) {
  const [{
    application,
    chrome,
    uiSettings,
    settings,
    notifications,
    overlays,
    http,
    docLinks,
    ...startServices
  }, {
    data,
    dataViewFieldEditor,
    dataViewEditor,
    dataViews,
    fieldFormats,
    unifiedSearch,
    share,
    spaces,
    savedObjectsManagement
  }, indexPatternManagementStart] = await getStartServices();
  const canSave = dataViews.getCanSaveSync();
  if (!canSave) {
    chrome.setBadge(readOnlyBadge);
  }
  const deps = {
    dataViewMgmtService: new _data_view_management_service.DataViewMgmtService({
      services: {
        dataViews,
        application,
        savedObjectsManagement,
        uiSettings
      },
      initialValues: {}
    }),
    application,
    chrome,
    uiSettings,
    settings,
    share,
    notifications,
    overlays,
    unifiedSearch,
    http,
    docLinks,
    data,
    dataViewFieldEditor,
    dataViews,
    indexPatternManagementStart: indexPatternManagementStart,
    setBreadcrumbs: params.setBreadcrumbs,
    fieldFormatEditors: dataViewFieldEditor.fieldFormatEditors,
    IndexPatternEditor: dataViewEditor.IndexPatternEditorComponent,
    fieldFormats,
    spaces: spaces !== null && spaces !== void 0 && spaces.hasOnlyDefaultSpace ? undefined : spaces,
    savedObjectsManagement,
    noDataPage,
    ...startServices
  };
  const editPath = '/dataView/:id/field/:fieldName';
  const createPath = '/dataView/:id/create-field/';
  const createEditPath = dataViews.scriptedFieldsEnabled ? [editPath, createPath] : [editPath];
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: deps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPromptNoDataViews.NoDataViewsPromptKibanaProvider, {
    coreStart: {
      ...startServices,
      docLinks,
      application
    },
    dataViewEditor: dataViewEditor,
    share: share,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: params.history,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/create'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.IndexPatternTableContainerRouter, {
    canSave: canSave,
    showCreateDialog: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: createEditPath,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.CreateEditFieldContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/dataView/:id'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.EditIndexPatternContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    path: '/patterns*',
    to: 'dataView*',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.IndexPatternTableContainerRouter, {
    canSave: canSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 17
    }
  }))))))), params.element);
  return () => {
    chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(params.element);
  };
}