"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFieldPreviewRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../common/constants");
var _shared_imports = require("../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const bodySchema = _configSchema.schema.object({
  index: _configSchema.schema.string(),
  script: _configSchema.schema.object({
    source: _configSchema.schema.string()
  }),
  context: _configSchema.schema.oneOf([_configSchema.schema.literal('boolean_field'), _configSchema.schema.literal('date_field'), _configSchema.schema.literal('double_field'), _configSchema.schema.literal('geo_point_field'), _configSchema.schema.literal('ip_field'), _configSchema.schema.literal('keyword_field'), _configSchema.schema.literal('long_field'), _configSchema.schema.literal('composite_field')]),
  document: _configSchema.schema.object({}, {
    unknowns: 'allow'
  })
});
const responseSchema = () => {
  const geoPoint = _configSchema.schema.object({
    type: _configSchema.schema.literal('Point'),
    coordinates: _configSchema.schema.arrayOf(_configSchema.schema.number(), {
      minSize: 2,
      maxSize: 2
    })
  });
  const valueSchema = _configSchema.schema.oneOf([_configSchema.schema.boolean(), _configSchema.schema.number(), _configSchema.schema.string(), geoPoint]);
  return _configSchema.schema.object({
    values: _configSchema.schema.oneOf([
    // composite field
    _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.arrayOf(valueSchema)),
    // primitive field
    _configSchema.schema.arrayOf(valueSchema)]),
    error: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    })),
    status: _configSchema.schema.maybe(_configSchema.schema.number())
  });
};
const registerFieldPreviewRoute = ({
  router
}) => {
  router.versioned.post({
    path: _constants.FIELD_PREVIEW_PATH,
    access: 'internal',
    security: {
      authz: {
        enabled: false,
        reason: 'Authorization provided by Elasticsearch'
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: bodySchema
      },
      response: {
        200: {
          body: responseSchema
        }
      }
    }
  }, async (ctx, req, res) => {
    const {
      client
    } = (await ctx.core).elasticsearch;
    const body = {
      script: req.body.script,
      context: req.body.context,
      context_setup: {
        document: req.body.document,
        index: req.body.index
      }
    };
    try {
      // client types need to be updated to support this request format
      // when it does, supply response types
      const {
        result
      } = await client.asCurrentUser.scriptsPainlessExecute(body);
      return res.ok({
        body: {
          values: result
        }
      });
    } catch (error) {
      // Assume invalid painless script was submitted
      // Return 200 with error object
      const handleCustomError = () => {
        var _error$body;
        return res.ok({
          body: {
            values: [],
            error: (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.error,
            status: error.statusCode
          }
        });
      };
      return (0, _shared_imports.handleEsError)({
        error,
        response: res,
        handleCustomError
      });
    }
  });
};
exports.registerFieldPreviewRoute = registerFieldPreviewRoute;