"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticLookupFormatEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _default = require("../default/default");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_format_editor/editors/static_lookup/static_lookup.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class StaticLookupFormatEditor extends _default.DefaultFormatEditor {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onLookupChange", (newLookupParams, index) => {
      const lookupEntries = [...this.props.formatParams.lookupEntries];
      lookupEntries[index] = {
        ...lookupEntries[index],
        ...newLookupParams
      };
      this.onChange({
        lookupEntries
      });
    });
    (0, _defineProperty2.default)(this, "addLookup", () => {
      const lookupEntries = [...(this.props.formatParams.lookupEntries || [])];
      this.onChange({
        lookupEntries: [...lookupEntries, {}]
      });
    });
    (0, _defineProperty2.default)(this, "removeLookup", index => {
      const lookupEntries = [...this.props.formatParams.lookupEntries];
      lookupEntries.splice(index, 1);
      this.onChange({
        lookupEntries
      });
    });
  }
  render() {
    const {
      formatParams
    } = this.props;
    const items = formatParams.lookupEntries && formatParams.lookupEntries.length && formatParams.lookupEntries.map((lookup, index) => {
      return {
        ...lookup,
        index
      };
    }) || [];
    const columns = [{
      field: 'key',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.staticLookup.keyLabel",
        defaultMessage: "Key",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 11
        }
      }),
      render: (value, item) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          value: value || '',
          "data-test-subj": `staticLookupEditorKey ${item.index}`,
          onChange: e => {
            this.onLookupChange({
              key: e.target.value
            }, item.index);
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 88,
            columnNumber: 13
          }
        });
      }
    }, {
      field: 'value',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.staticLookup.valueLabel",
        defaultMessage: "Value",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 11
        }
      }),
      render: (value, item) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          value: value || '',
          "data-test-subj": `staticLookupEditorValue ${item.index}`,
          onChange: e => {
            this.onLookupChange({
              value: e.target.value
            }, item.index);
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 13
          }
        });
      }
    }, {
      field: 'actions',
      name: _i18n.i18n.translate('indexPatternFieldEditor.staticLookup.actions', {
        defaultMessage: 'actions'
      }),
      actions: [{
        name: _i18n.i18n.translate('indexPatternFieldEditor.staticLookup.deleteAria', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('indexPatternFieldEditor.staticLookup.deleteTitle', {
          defaultMessage: 'Delete entry'
        }),
        onClick: item => {
          this.removeLookup(item.index);
        },
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        'data-test-subj': 'staticLookupEditorRemoveEntry',
        available: () => items.length > 1
      }],
      width: '30px'
    }];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: items,
      columns: columns,
      css: {
        maxWidth: '400px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      size: "s",
      onClick: this.addLookup,
      "data-test-subj": 'staticLookupEditorAddEntry',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.staticLookup.addEntryButton",
      defaultMessage: "Add entry",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.staticLookup.unknownKeyLabel",
        defaultMessage: "Value for unknown key",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: formatParams.unknownKeyValue || '',
      "data-test-subj": 'staticLookupEditorUnknownValue',
      placeholder: _i18n.i18n.translate('indexPatternFieldEditor.staticLookup.leaveBlankPlaceholder', {
        defaultMessage: 'Leave blank to keep value as-is'
      }),
      onChange: e => {
        this.onChange({
          unknownKeyValue: e.target.value
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 9
      }
    }));
  }
}
exports.StaticLookupFormatEditor = StaticLookupFormatEditor;
(0, _defineProperty2.default)(StaticLookupFormatEditor, "formatId", _constants.formatId);