"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceDefinition = getServiceDefinition;
var _configSchema = require("@kbn/config-schema");
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getServiceDefinition() {
  return {
    get: {
      out: {
        result: {
          schema: (0, _schema.getDashboardGetResultSchema)()
        }
      }
    },
    create: {
      in: {
        options: {
          schema: _schema.dashboardCreateOptionsSchema
        },
        data: {
          schema: _configSchema.schema.object((0, _schema.getDashboardStateSchema)())
        }
      },
      out: {
        result: {
          schema: (0, _schema.getDashboardItemSchema)()
        }
      }
    },
    update: {
      in: {
        options: {
          schema: _schema.dashboardUpdateOptionsSchema
        },
        data: {
          schema: (0, _schema.getDashboardUpdateRequestAttributesSchema)()
        }
      }
    },
    search: {
      in: {
        options: {
          schema: _schema.dashboardSearchOptionsSchema
        }
      }
    }
  };
}