"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadDashboardState = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _ = require("..");
var _default_dashboard_state = require("../../../dashboard_api/default_dashboard_state");
var _telemetry_constants = require("../../../utils/telemetry_constants");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const loadDashboardState = async ({
  id
}) => {
  var _savedObjectsTaggingS, _savedObjectsTaggingS2;
  const dashboardContentManagementCache = (0, _.getDashboardContentManagementCache)();
  const savedObjectId = id;
  const newDashboardState = {
    ..._default_dashboard_state.DEFAULT_DASHBOARD_STATE
  };

  /**
   * This is a newly created dashboard, so there is no saved object state to load.
   */
  if (!savedObjectId) {
    return {
      dashboardInput: newDashboardState,
      dashboardFound: true,
      newDashboardCreated: true,
      references: []
    };
  }

  /**
   * Load the saved object from Content Management
   */
  let rawDashboardContent;
  let resolveMeta;
  const cachedDashboard = dashboardContentManagementCache.fetchDashboard(id);
  if (cachedDashboard) {
    /** If the dashboard exists in the cache, use the cached version to load the dashboard */
    ({
      item: rawDashboardContent,
      meta: resolveMeta
    } = cachedDashboard);
  } else {
    /** Otherwise, fetch and load the dashboard from the content management client, and add it to the cache */
    const result = await _kibana_services.contentManagementService.client.get({
      contentTypeId: _telemetry_constants.DASHBOARD_CONTENT_ID,
      id
    }).catch(e => {
      var _e$response, _message, _e$body;
      if (((_e$response = e.response) === null || _e$response === void 0 ? void 0 : _e$response.status) === 404) {
        throw new _public.SavedObjectNotFound({
          type: _telemetry_constants.DASHBOARD_CONTENT_ID,
          id
        });
      }
      const message = (_message = (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) !== null && _message !== void 0 ? _message : e.message;
      throw new Error(message);
    });
    ({
      item: rawDashboardContent,
      meta: resolveMeta
    } = result);
    const {
      outcome: loadOutcome
    } = resolveMeta;
    if (loadOutcome !== 'aliasMatch') {
      /**
       * Only add the dashboard to the cache if it does not require a redirect - otherwise, the meta
       * alias info gets cached and prevents the dashboard contents from being updated
       */
      dashboardContentManagementCache.addDashboard(result);
    }
  }
  if (!rawDashboardContent || !rawDashboardContent.version) {
    return {
      dashboardInput: newDashboardState,
      dashboardFound: false,
      dashboardId: savedObjectId,
      references: []
    };
  }
  const {
    references,
    attributes,
    managed,
    version
  } = rawDashboardContent;
  const {
    refreshInterval,
    description,
    timeRestore,
    options,
    panels,
    filters,
    query,
    timeRange,
    title
  } = attributes;
  return {
    managed,
    references,
    resolveMeta: {
      ...resolveMeta,
      version
    },
    dashboardInput: {
      options,
      refreshInterval,
      timeRestore,
      description,
      timeRange,
      filters,
      panels,
      query,
      title,
      tags: (_savedObjectsTaggingS = _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : (_savedObjectsTaggingS2 = _kibana_services.savedObjectsTaggingService.getTaggingApi()) === null || _savedObjectsTaggingS2 === void 0 ? void 0 : _savedObjectsTaggingS2.ui.getTagIdsFromReferences(references)) !== null && _savedObjectsTaggingS !== void 0 ? _savedObjectsTaggingS : [],
      controlGroupInput: attributes.controlGroupInput
    },
    dashboardFound: true,
    dashboardId: savedObjectId
  };
};
exports.loadDashboardState = loadDashboardState;