"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeSettingsManager = initializeSettingsManager;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _content_management = require("../../common/content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_SETTINGS = {
  ..._content_management.DEFAULT_DASHBOARD_OPTIONS,
  description: undefined,
  tags: [],
  timeRestore: false,
  title: ''
};
const comparators = {
  title: 'referenceEquality',
  description: 'referenceEquality',
  hidePanelTitles: 'referenceEquality',
  syncColors: 'referenceEquality',
  syncCursor: 'referenceEquality',
  syncTooltips: 'referenceEquality',
  timeRestore: 'referenceEquality',
  useMargins: 'referenceEquality',
  tags: 'deepEquality'
};
function deserializeState(state) {
  return {
    ...state.options,
    description: state.description,
    tags: state.tags,
    timeRestore: state.timeRestore,
    title: state.title
  };
}
function initializeSettingsManager(initialState) {
  const stateManager = (0, _presentationPublishing.initializeStateManager)(deserializeState(initialState), DEFAULT_SETTINGS, comparators);
  function serializeSettings() {
    const {
      description,
      tags,
      timeRestore,
      title,
      ...options
    } = stateManager.getLatestState();
    return {
      ...(description && {
        description
      }),
      tags,
      timeRestore,
      title,
      options
    };
  }
  return {
    api: {
      description$: stateManager.api.description$,
      getSettings: stateManager.getLatestState,
      hideTitle$: stateManager.api.hidePanelTitles$,
      settings: {
        syncColors$: stateManager.api.syncColors$,
        syncCursor$: stateManager.api.syncCursor$,
        syncTooltips$: stateManager.api.syncTooltips$,
        useMargins$: stateManager.api.useMargins$
      },
      setSettings: stateManager.reinitializeState,
      setTags: stateManager.api.setTags,
      timeRestore$: stateManager.api.timeRestore$,
      title$: stateManager.api.title$
    },
    internalApi: {
      serializeSettings,
      startComparing$: lastSavedState$ => {
        return stateManager.anyStateChange$.pipe((0, _rxjs.debounceTime)(100), (0, _rxjs.map)(() => stateManager.getLatestState()), (0, _rxjs.combineLatestWith)(lastSavedState$), (0, _rxjs.map)(([latestState, lastSavedState]) => {
          const {
            description,
            tags,
            timeRestore,
            title,
            ...optionDiffs
          } = (0, _presentationPublishing.diffComparators)(comparators, deserializeState(lastSavedState), latestState, DEFAULT_SETTINGS);
          // options needs to contain all values and not just diffs since is spread into saved state
          const options = Object.keys(optionDiffs).length ? {
            ...serializeSettings().options,
            ...optionDiffs
          } : undefined;
          return {
            ...(description && {
              description
            }),
            ...(tags && {
              tags
            }),
            ...(typeof timeRestore === 'boolean' && {
              timeRestore
            }),
            ...(title && {
              title
            }),
            ...(options && {
              options
            })
          };
        }));
      },
      reset: lastSavedState => {
        stateManager.reinitializeState(deserializeState(lastSavedState));
      }
    }
  };
}