"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PricingService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _corePricingCommon = require("@kbn/core-pricing-common");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
class PricingService {
  constructor(core) {
    (0, _defineProperty2.default)(this, "configService", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "productFeaturesRegistry", void 0);
    (0, _defineProperty2.default)(this, "isEvaluated$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "isEvaluatedPromise", (0, _rxjs.firstValueFrom)(this.isEvaluated$));
    (0, _defineProperty2.default)(this, "pricingConfig", void 0);
    (0, _defineProperty2.default)(this, "tiersClient", void 0);
    this.logger = core.logger.get('pricing-service');
    this.configService = core.configService;
    this.productFeaturesRegistry = new _corePricingCommon.ProductFeaturesRegistry();
    this.pricingConfig = {
      tiers: {
        enabled: false,
        products: []
      }
    };
    this.tiersClient = new _corePricingCommon.PricingTiersClient(this.pricingConfig.tiers, this.productFeaturesRegistry);
  }
  preboot({
    http
  }) {
    this.logger.debug('Prebooting pricing service');

    // The preboot server has no need for real pricing.
    http.registerRoutes('', router => {
      (0, _routes.registerRoutes)(router, {
        pricingConfig: this.pricingConfig,
        productFeaturesRegistry: this.productFeaturesRegistry
      });
    });
  }
  async setup({
    http
  }) {
    this.logger.debug('Setting up pricing service');
    this.pricingConfig = await (0, _rxjs.firstValueFrom)(this.configService.atPath('pricing'));
    this.tiersClient.setTiers(this.pricingConfig.tiers);
    (0, _routes.registerRoutes)(http.createRouter(''), {
      pricingConfig: this.pricingConfig,
      productFeaturesRegistry: this.productFeaturesRegistry
    });
    return {
      /**
       * Evaluates the product features and emits the `isEvaluated$` signal.
       * This should be called after all plugins have registered their features.
       */
      evaluateProductFeatures: () => this.isEvaluated$.next(),
      /**
       * Checks if a specific feature is available in the current pricing tier configuration.
       * Resolves asynchronously after the pricing service has been set up and all the plugins have registered their features.
       */
      isFeatureAvailable: async featureId => {
        await this.isEvaluatedPromise;
        return this.tiersClient.isFeatureAvailable(featureId);
      },
      registerProductFeatures: features => {
        features.forEach(feature => {
          this.productFeaturesRegistry.register(feature);
        });
      }
    };
  }
  start() {
    if (this.logger.isLevelEnabled('debug')) {
      this.logger.debug(`Starting pricing service with config: ${JSON.stringify(this.pricingConfig.tiers)}`);
    }
    return {
      isFeatureAvailable: this.tiersClient.isFeatureAvailable.bind(this.tiersClient),
      getActiveProduct: this.tiersClient.getActiveProduct.bind(this.tiersClient)
    };
  }
  stop() {
    // No-op
  }
}
exports.PricingService = PricingService;