"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHighContrastModeStyles = exports.highContrastHoverStyle = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const highContrastHoverStyle = ({
  euiTheme
}) => `
    outline-color: var(--high-contrast-hover-indicator-color, ${euiTheme.border.color});
    outline-width: ${euiTheme.border.width.thin};
    outline-style: dashed;
    outline-offset: -${euiTheme.border.width.thin};
`;

/**
 * Hook to get the high contrast mode hover styles for buttons.
 *
 * @returns The high contrast mode hover styles.
 */
exports.highContrastHoverStyle = highContrastHoverStyle;
const useHighContrastModeStyles = (selector = '') => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    highContrastMode
  } = euiThemeContext;
  const styles = {
    preferred: (0, _react.css)`
      border: ${euiThemeContext.euiTheme.border.width.thin} solid transparent;
      transition: none;

      &:hover ${selector} {
        ${highContrastHoverStyle(euiThemeContext)}
      }
    `,
    forced: (0, _react.css)`
      border: none;

      &:hover ${selector} {
        ${highContrastHoverStyle(euiThemeContext)}
      }
    `
  };
  return highContrastMode ? styles[highContrastMode] : undefined;
};
exports.useHighContrastModeStyles = useHighContrastModeStyles;