"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecondaryMenuItemComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_scroll_to_active = require("../../hooks/use_scroll_to_active");
var _beta_badge = require("../beta_badge");
var _use_high_contrast_mode_styles = require("../../hooks/use_high_contrast_mode_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/secondary_menu/item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * `EuiButton` and `EuiButtonEmpty` are used for consistency with the component library.
 * The only style overrides are making the button labels left-aligned.
 */
const SecondaryMenuItemComponent = ({
  badgeType,
  children,
  iconType,
  id,
  isHighlighted,
  isCurrent,
  isExternal,
  testSubjPrefix = 'secondaryMenuItem',
  ...props
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // TODO: remove once the fix is available on EUI side
  const highContrastModeStyles = (0, _use_high_contrast_mode_styles.useHighContrastModeStyles)();
  const activeItemRef = (0, _use_scroll_to_active.useScrollToActive)(isCurrent);
  const iconSide = iconType ? 'left' : 'right';
  const iconProps = {
    iconSide: iconSide,
    iconType: isExternal ? 'popout' : iconType,
    // Ensure external links open in a new tab
    ...(isExternal && {
      target: '_blank'
    })
  };
  const buttonStyles = (0, _react2.css)`
    font-weight: ${isHighlighted ? euiTheme.font.weight.semiBold : euiTheme.font.weight.regular};
    // 6px comes from Figma, no token
    padding: 6px ${euiTheme.size.s};
    width: 100%;

    > span {
      justify-content: ${iconSide === 'left' ? 'flex-start' : 'space-between'};
    }

    svg:not(.euiBetaBadge__icon) {
      color: ${euiTheme.colors.textDisabled};
    }

    --high-contrast-hover-indicator-color: ${isHighlighted ? euiTheme.colors.textPrimary : euiTheme.colors.textParagraph};
    ${highContrastModeStyles};
  `;
  const labelAndBadgeStyles = (0, _react2.css)`
    align-items: center;
    display: flex;
    gap: ${euiTheme.size.xs};
  `;
  const content = /*#__PURE__*/_react.default.createElement("div", {
    css: labelAndBadgeStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, children, badgeType && /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
    type: badgeType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 21
    }
  }));
  return /*#__PURE__*/_react.default.createElement("li", {
    ref: activeItemRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, isHighlighted ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "aria-current": isCurrent ? 'page' : undefined,
    css: buttonStyles,
    "data-highlighted": "true",
    "data-test-subj": `${testSubjPrefix}-${id}`,
    fullWidth: true,
    size: "s",
    textProps: false
  }, iconProps, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }), content) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "aria-current": isCurrent ? 'page' : undefined,
    css: buttonStyles,
    color: "text",
    "data-highlighted": "false",
    "data-test-subj": `${testSubjPrefix}-${id}`,
    size: "s",
    textProps: false
  }, iconProps, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }), content));
};
exports.SecondaryMenuItemComponent = SecondaryMenuItemComponent;