"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRouteDeprecationsHandler = createRouteDeprecationsHandler;
exports.registerApiDeprecationsPostValidationHandler = void 0;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _logging = require("@kbn/core-http-server-internal/src/logging");
var _deprecations = require("../deprecations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * listens to http post validation events to increment deprecated api calls
 * This will keep track of any called deprecated API.
 */
const registerApiDeprecationsPostValidationHandler = ({
  coreUsageData,
  http,
  logger
}) => {
  http.registerOnPostValidation(createRouteDeprecationsHandler({
    coreUsageData,
    logger
  }));
};
exports.registerApiDeprecationsPostValidationHandler = registerApiDeprecationsPostValidationHandler;
function createRouteDeprecationsHandler({
  coreUsageData,
  logger
}) {
  return (req, metadata) => {
    const hasRouteDeprecation = (0, _deprecations.getIsRouteApiDeprecation)(metadata);
    const hasAccessDeprecation = (0, _deprecations.getIsAccessApiDeprecation)(metadata);
    const isApiDeprecation = hasAccessDeprecation || hasRouteDeprecation;
    if (isApiDeprecation && req.route.routePath) {
      const counterName = (0, _deprecations.buildApiDeprecationId)({
        routeMethod: req.route.method,
        routePath: req.route.routePath,
        routeVersion: req.apiVersion
      });
      const client = coreUsageData.getClient();
      // no await we just fire it off.
      void client.incrementDeprecatedApi(counterName, {
        resolved: false
      });
      if (logger.isLevelEnabled('debug')) {
        const {
          message,
          meta
        } = (0, _logging.getEcsResponseLog)((0, _coreHttpRouterServerInternal.ensureRawRequest)(req), logger);
        logger.debug(message, meta);
      }
    }
  };
}