"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateApiKey = exports.GenerateConnectorApiKeyApiLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateApiKey = async ({
  indexName,
  isNative,
  http
}) => {
  const route = `/internal/content_connectors/indices/${indexName}/api_key`;
  const params = {
    is_native: isNative
  };
  return await (http === null || http === void 0 ? void 0 : http.post(route, {
    body: JSON.stringify(params)
  }));
};
exports.generateApiKey = generateApiKey;
const GenerateConnectorApiKeyApiLogic = exports.GenerateConnectorApiKeyApiLogic = (0, _create_api_logic.createApiLogic)(['generate_connector_api_key_api_logic'], generateApiKey);