"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertRequestToLanguage = convertRequestToLanguage;
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function convertRequestToLanguage({
  requests,
  language,
  esHost,
  kibanaHost
}) {
  return (0, _use_request.sendRequest)({
    path: `/api/console/convert_request_to_language`,
    method: 'post',
    query: {
      language,
      esHost,
      kibanaHost
    },
    body: requests
  });
}